/*
 * $Id: MnemonicNamerTest.java,v 1.2 2004/04/14 02:58:54 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests;

import junit.framework.TestCase;

import com.narucy.webpub.ui.MnemonicNamer;

/**
 * 
 */
public class MnemonicNamerTest extends TestCase {
	
	public void testGetLabel() {
		MnemonicNamer namer = new MnemonicNamer() {
			public String toLabel(Object obj) {
				return obj.toString();
			}
		};
		
		String a = "aaa";
		String b = "bbb";
		String c = "ccc";
		String d = "ddd";
		
		assertEquals("&1 aaa", namer.getLabel(a) );
		assertEquals("&2 bbb", namer.getLabel(b) );
		assertEquals("&3 ccc", namer.getLabel(c) );
		
		namer.release(b);
		assertEquals("&2 ddd", namer.getLabel(d) );
	}
	
}
