/*
 * $Id: PresetSelectionWizardPageTest.java,v 1.4 2004/04/25 00:42:33 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.wizards;

import java.util.Arrays;

import junit.framework.TestCase;

import org.eclipse.swt.widgets.*;

import com.narucy.webpub.core.preset.*;
import com.narucy.webpub.ui.tests.UITestUtils;
import com.narucy.webpub.ui.wizards.PresetSelectionWizardPage;

/**
 * <ul>
 * <li>List control display presets names.
 * <li>Initial selection index is 0.
 * <li>List control selection changed when update presets description for selected index.
 * </ul>
 */
public class PresetSelectionWizardPageTest extends TestCase {

	public void testCreateControl() {
		PresetManager mgr = PresetManager.getInstance();
		
		Shell sh = new Shell();
		PresetSelectionWizardPage page = new PresetSelectionWizardPage();
		page.createControl(sh);
		
		List list = (List)UITestUtils.findControl(page.getControl(), "presetList");
		Text text = (Text)UITestUtils.findControl(page.getControl(), "descriptionText");
		
		assertTrue( Arrays.equals(
				mgr.getPresetNames(),
				list.getItems()));
		
		Preset[] presets = mgr.getPresets();
		assertEquals(0, list.getSelectionIndex());
		assertEquals(presets[0].getDescription(), text.getText());
		
		page.setSelectionIndex(1);
		assertEquals(1, list.getSelectionIndex());
		assertEquals(presets[1].getDescription(), text.getText());
		
		page.setSelectionIndex(-1);
		assertEquals(-1, list.getSelectionIndex());
		assertEquals("", text.getText());
	}
	
}
