/*
 * $Id: FileExtensionValidator.java,v 1.1 2004/04/11 08:23:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import org.eclipse.jface.dialogs.IInputValidator;

public class FileExtensionValidator implements IInputValidator {

	char[] invalidChars = "\\/:;*,?<>| \t\r\n".toCharArray();
	
	public String isValid(String newName) {
		for (int i = 0; i < invalidChars.length; i++) {
			char ch = invalidChars[i];
			if(newName.indexOf(ch) != -1){
				return "invalid char code \"" + ch + "\"";
			}
		}
		if (newName.length() > 0 && newName.charAt(0) == '.'){
			return "not need to specify first char \".\"";
		}
		return null;
	}
}

