package com.narucy.webpub.ui.editors;

import java.util.HashMap;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.*;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.Display;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * ColorManager provides editor color and image.
 */
public class ColorManager implements ISharedTextColors {

	HashMap
		colorTable = new HashMap(),
		sharedImage = new HashMap();

	public ColorManager(){
	}

	/**
	 * Return color for NN,NN,NN or UIPluginPreferenceKey
	 */
	public Color getColor(String key) {
		IPreferenceStore store = WebpubUIPlugin.getDefault().getPreferenceStore();
		RGB rgb = StringConverter.asRGB(store.contains(key) ? store.getString(key) : key);
		return getColor(rgb);
	}

	public Color getColor(RGB rgb) {
		Color color = (Color)colorTable.get(rgb);
		if( color == null){
			color = new Color(Display.getCurrent(), rgb);
			colorTable.put(rgb, color);
		}
		return color;
	}
	
	public Image getImage(String path){
		Image img = (Image)sharedImage.get(path);
		if(img == null){
			ImageDescriptor desc = WebpubUIPlugin.getImageDescriptor(path);
			if(desc != null){
				img = desc.createImage();
			}
			sharedImage.put(path, img);
		}
		return img;
	}

	public void dispose() {
		Object[] colors = colorTable.values().toArray();
		for (int i = 0; i < colors.length; i++) {
			((Color)colors[i]).dispose();
		}
		Object[] imgs = sharedImage.values().toArray();
		for (int i = 0; i < imgs.length; i++) {
			((Image)imgs[i]).dispose();
		}
	}

}
