/*
 * $Id: HTContentAssistEngine.java,v 1.1 2004/04/11 08:23:38 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.xml.parsers.*;

import org.eclipse.core.runtime.Path;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

import com.narucy.webpub.ui.WebpubUIPlugin;

public class HTContentAssistEngine {

	final public static String
		XHTML_BASIC = "xhtml-basic.rng",
		XHTML_STRICT = "xhtml-strict.rng",
		XHTML_TRANSITIONAL = "xhtml.rng";

	static URL xhtmlRelaxNGBaseUrl;

	static {
		URL zipFileUrl = WebpubUIPlugin.getDefault().find(new Path("resources/xhtml-rng.zip"));
		try {
			xhtmlRelaxNGBaseUrl = new URL("jar:" + zipFileUrl.toString() + "!/");
		} catch (MalformedURLException e) {
			throw new RuntimeException(e);
		}
	}
	
	String flavor = null;

	HashMap
		rngReadCache = new HashMap(),
		definedCache = new HashMap(),
		bindedDefineCache = new HashMap(),
		childElementsCache = new HashMap(),
		attributesCache = new HashMap();
	
	DocumentBuilder builder;
	
	public HTContentAssistEngine(String flavor) {
		DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		try {
			builder = docBuilderFactory.newDocumentBuilder();
			URL url = new URL(xhtmlRelaxNGBaseUrl, flavor);
			doInitGrammar( getDocumentElement(url), url);
			this.flavor = flavor;
		} catch (ParserConfigurationException e) {
			throw new RuntimeException(e);
		} catch (MalformedURLException e) {
			throw new RuntimeException(e);
		} catch (DOMException e) {
			throw new RuntimeException(e);
		} catch (SAXException e) {
			throw new RuntimeException(e);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
	
	public String getFlavor(){
		return flavor;
	}
	
	Element getDocumentElement(URL url) throws SAXException, IOException{
		Element e = (Element)rngReadCache.get(url);
		if(e == null){
			InputStream stream = null;
			try{
				stream = url.openStream();
				Document doc = builder.parse(stream);
				e = doc.getDocumentElement();
				rngReadCache.put(url, e);
			}finally{
				if(stream != null){
					stream.close();
				}
			}
		}
		return e;
	}

	void doInitGrammar(Element elem, URL loadedUrl) throws MalformedURLException, DOMException, SAXException, IOException{
		NodeList nl = elem.getChildNodes();
		for(int i=0; i<nl.getLength(); i++){
			if(nl.item(i) instanceof Element){
				Element e = (Element)nl.item(i);
				String elemName = e.getTagName();
				if(elemName.equals("include")){
					URL url = new URL(loadedUrl, e.getAttribute("href"));
					doInitGrammar( getDocumentElement(url), url);
				}else if( elemName.equals("define") ){
					String name = e.getAttribute("name");
					if( definedCache.containsKey(name) && e.getAttribute("combine") != null){
						addBindedElem(e);
					}else{
						definedCache.put(name, e);
					}
				}
			}
		}
	}
	
	void addBindedElem(Element e){
		String name = e.getAttribute("name");
		List list = (List)bindedDefineCache.get(name);
		if(list == null){
			list = new ArrayList();
			bindedDefineCache.put(name, list);
		}
		list.add(e);
	}

	public String[] getCandidateElements(String elemName) {
		if( !childElementsCache.containsKey(elemName)){
			String[] elems = findChildElements(elemName);
			if(elems != null){
				Arrays.sort(elems);
			}
			childElementsCache.put(elemName, elems);
		}
		return (String[])childElementsCache.get(elemName);
	}
	
	Element findHTElement(String elemName){
		Object[] defs = definedCache.values().toArray();
		for(int i=0; i<defs.length; i++){
			NodeList ls = ((Element)defs[i]).getElementsByTagName("element");
			for(int j=0; j<ls.getLength(); j++){
				Element e = (Element)ls.item(j);
				if( e.getAttribute("name").equals(elemName) ){
					return e;
				}
			}
		}
		return null;
	}
	
	String[] findChildElements(String elemName){
		Element elem = findHTElement(elemName);
		if( elem == null){
			return null;
		}

		Element[] childs = toFlatChildren(elem);
		ArrayList dist = new ArrayList();
		for (int i = 0; i < childs.length; i++) {
			Element e = childs[i];
			if( e.getTagName().equals("element") ){
				dist.add( e.getAttribute("name") );
			}
		}
		return dist.size() > 0 ? (String[])dist.toArray(new String[dist.size()]) : null;
	}

	public String[] getCandidateAttribute(String elementName){
		if(!attributesCache.containsKey(elementName)){
			String[] attrs = findAttributes(elementName);
			if( attrs != null){
				Arrays.sort(attrs);
			}
			attributesCache.put(elementName, attrs);
		}
		return (String[])attributesCache.get(elementName);
	}

	String[] findAttributes(String name){
		Element elem = findHTElement(name);
		if(elem == null){
			return null;
		}
		Element[] childs = toFlatChildren(elem);
		ArrayList dist = new ArrayList();
		for (int i = 0; i < childs.length; i++) {
			Element e = childs[i];
			if( e.getTagName().equals("attribute") ){
				dist.add(e.getAttribute("name"));
			}
		}
		return dist.size() > 0 ? (String[])dist.toArray(new String[dist.size()]) : null;
	}
	
	public boolean isEmptyElement(String elemName){
		return findHTElement(elemName).getElementsByTagName("empty").getLength() > 0;
	}
	
	Element[] toFlatChildren(Element elem){
		ArrayList dist = new ArrayList();
		toFlat(elem, dist);
		return (Element[])dist.toArray(new Element[dist.size()]);
	}
	
	void toFlat(Element elem, List dist){
		NodeList nl = elem.getChildNodes();
		for(int i=0; i<nl.getLength(); i++){
			if (nl.item(i) instanceof Element){
				Element e = (Element)nl.item(i);
				dist.add(e);
				
				String tn = e.getTagName();
				if( tn.equals("zeroOrMore") || tn.equals("oneOrMore") ||  tn.equals("choice") || tn.equals("optional")){
					toFlat(e, dist);
				}else if(tn.equals("ref") ){
					String name = e.getAttribute("name");
					toFlat( (Element)definedCache.get(name), dist);
					List elems = (List)bindedDefineCache.get(name);
					for(int j=0; elems != null && j<elems.size(); j++){
						toFlat( (Element)elems.get(j), dist);
					}
				}
			}
		}
	}
	
	
}
