/*
 * $Id: HTLabelProvider.java,v 1.2 2004/04/24 05:04:45 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.viewers.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.*;

import com.narucy.webpub.core.template.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

class TemplateLabelProvider extends LabelProvider {

	Image tmplImage = WebpubUIPlugin.getImageDescriptor("obj16/template.gif").createImage();
	
	public String getText(Object element) {
		if(element instanceof Template){
			Template teml = (Template)element;
			return teml.getName();
		}
		else if(element instanceof Exception){
			return ((Exception)element).getMessage();
		}
		return super.getText(element);
	}

	public Image getImage(Object element) {
		if(element instanceof Template){
			return tmplImage;
		} else if(element instanceof TemplateParseException){
			return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJS_ERROR_TSK);
		}
		return null;
	}
	
	public void dispose() {
		tmplImage.dispose();
	}

}

/**
 * 
 */
public class HTLabelProvider extends DecoratingLabelProvider {

	public HTLabelProvider() {
		this(new TemplateLabelProvider());
	}
	
	HTLabelProvider(TemplateLabelProvider provider){
		super(provider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
	}


}
