/*
 * $Id: InsertTemplateWizard.java,v 1.2 2004/04/20 00:44:14 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.*;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.template.TemplateManager;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * InsertTemplateWizard.
 */
public class InsertTemplateWizard extends Wizard {

	ITextEditor editor;
	TemplateManager tmplMgr;
	
	public InsertTemplateWizard(ITextEditor editor) throws CoreException {
		this.editor = editor;
		
		IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
		tmplMgr = ((WebProject)file.getProject().getNature(WebProject.ID_NATURE)).getTemplateManager();

		setWindowTitle("Insert Template");
		setDefaultPageImageDescriptor(WebpubUIPlugin.getImageDescriptor("wizban/inserttmpl_wiz.gif") );

		addPage(new TemplateNameInputWizardPage());
		addPage(new TemplateContentSelectionWizardPage());
	}
	
	public TemplateManager getTemplateManager() {
		return tmplMgr;
	}

	public boolean performFinish() {
		try {
			doInsertTemplate((IPreviewer)getContainer().getCurrentPage());
		} catch (BadLocationException e) {
			WebpubUIPlugin.handleException(e);
		}
		return true;
	}
	
	void doInsertTemplate(IPreviewer page) throws BadLocationException{
		ITextSelection sel = getTextSelection();
		int offset = sel.getOffset();
		int len = sel.getLength();
		IDocument doc = editor.getDocumentProvider().getDocument(editor.getEditorInput());
		
		StringBuffer preview = new StringBuffer();
		if( doc.getChar(offset) != '\n'){
			preview.append('\n');
		}
		preview.append( page.getPreviewText() );
		int endIndex = offset + len;
		if( doc.getLength() > endIndex && doc.getChar(endIndex) != '\n'){
			preview.append('\n');
		}
		doc.replace(offset, len, preview.toString());
		editor.getSelectionProvider().setSelection(new TextSelection(offset + preview.length(), 0) );
	}
	
	protected ITextSelection getTextSelection(){
		return (ITextSelection)editor.getSelectionProvider().getSelection();
	}
	
	protected static Text createPreview(Composite parent){
		createPreviewLabel(parent);
		return createPreviewText(parent);
	}
	
	protected static Label createPreviewLabel(Composite parent){
		Label labe = new Label(parent, SWT.NONE);
		labe.setText("Preview:");
		GridData gd = new GridData();
		gd.horizontalSpan = 2;
		labe.setLayoutData(gd);
		return labe;
	}
	
	protected static Text createPreviewText(Composite parent){
		Text preview = new Text(parent, SWT.BORDER | SWT.READ_ONLY | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 2;
		preview.setLayoutData(gd);
		return preview;
	}
	
}
