package com.narucy.webpub.ui.preferences;

import java.util.regex.Pattern;

import org.eclipse.jface.preference.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.*;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * @see PreferencePage
 */
public class HTEditorPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {
	
	StringFieldEditor delayEditor;
	
	public HTEditorPreferencePage() {
		super(FieldEditorPreferencePage.GRID);
		setPreferenceStore( WebpubUIPlugin.getDefault().getPreferenceStore() );
	}

	public void init(IWorkbench workbench)  {
	}

	protected void createFieldEditors() {
		final Composite parent = getFieldEditorParent();
		
		addField(new IntegerFieldEditor(
			WebpubUIPlugin.HT_EDITOR_DISPLAYED_TAB_WIDTH,
			"Displayed &tab width:",
			parent));
		
		addField(new BooleanFieldEditor(
			WebpubUIPlugin.HT_EDITOR_WORDWRAP,
			"&Word wrap",
			parent));
		
		addField(new ColorFieldEditor(
			WebpubUIPlugin.HT_EDITOR_COLOR_BACKGROUND,
			"&Background:",
			parent));
		
		addField(new ColorFieldEditor(
			WebpubUIPlugin.HT_EDITOR_COLOR_DEFAULT,
			"&Default:",
			parent));
		
		addField(new ColorFieldEditor(
			WebpubUIPlugin.HT_EDITOR_COLOR_TAG,
			"&Tag:",
			parent));

		addField(new ColorFieldEditor(
			WebpubUIPlugin.HT_EDITOR_COLOR_COMMENT,
			"&Comment:",
			parent));

		addField(new ColorFieldEditor(
			WebpubUIPlugin.HT_EDITOR_COLOR_ERB,
			"&ERB:",
			parent));

		addField(new ColorFieldEditor(
			WebpubUIPlugin.HT_EDITOR_COLOR_ATTR,
			"&String:",
			parent));

		addField(new ColorFieldEditor(
			WebpubUIPlugin.HT_EDITOR_COLOR_PROCESSOR,
			"&Processor:",
			parent));
		
		BooleanFieldEditor enableContentComplete = new BooleanFieldEditor(
			WebpubUIPlugin.HT_EDITOR_CONTENT_ASSIST,
			"&Use code assist",
			parent){
				
			public void valueChanged(boolean oldValue, boolean newValue){
				delayEditor.setEnabled(newValue, parent);
			}
		};	
		addField(enableContentComplete);
		
		delayEditor = new StringFieldEditor(
			WebpubUIPlugin.HT_EDITOR_CONTENT_ASSIST_DELAY,
			"Auto activation dela&y:",
			parent){
		
			public boolean isValid(){
				return Pattern.matches("^\\d+$", getStringValue());
			}
		};
		delayEditor.setEnabled( getPreferenceStore().getBoolean(WebpubUIPlugin.HT_EDITOR_CONTENT_ASSIST), parent);
		
		delayEditor.setEmptyStringAllowed(false);
		delayEditor.setTextLimit(5);
		addField(delayEditor);
	}
	

}
