/*
 * $Id: HTPreviewPreferencePage.java,v 1.2 2004/04/24 05:04:48 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.preferences;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.*;

import com.narucy.webpub.ui.*;

/**
 * 
 */
public class HTPreviewPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {
	
	ListEditor createExtensionListEditor(String name, String labelText, Composite parent){
		return new ListEditor( name, labelText, parent ){

			protected String createList(String[] items) {
				return WebpubUIPlugin.join(items);
			}

			protected String getNewInputObject() {
				InputDialog dialog = new InputDialog(
					getShell(),
					null,
					"Input name extension of to use publish",
					null,
					new FileExtensionValidator());
				
				dialog.open();
				return dialog.getValue();
			}

			protected String[] parseString(String stringList) {
				return StringConverter.asArray(stringList);
			}
			
		};
	}
	
	public HTPreviewPreferencePage() {
		super(FieldEditorPreferencePage.GRID);
		setPreferenceStore( WebpubUIPlugin.getDefault().getPreferenceStore() );
	}

	public void init(IWorkbench workbench) {
	}

	protected void createFieldEditors() {
		Composite parent = getFieldEditorParent();
		ListEditor list = createExtensionListEditor(
			WebpubUIPlugin.HT_PREVIEW_EXTENSIONS,
			"Preview target file extensions",
			parent);
		
		addField(list);
	}

}
