/*
 * $Id: NewWebPageWizard.java,v 1.3 2004/04/26 06:46:11 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;

import java.io.InputStream;
import java.util.Arrays;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.*;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;


/**
 * 
 */
public class NewWebPageWizard extends BasicNewResourceWizard {

	WizardNewFileCreationPage newFilePage;
	InitialWebPageWizardPage newPageSelectionPage;

	public NewWebPageWizard() {
		setWindowTitle("New Web Page");
		setNeedsProgressMonitor(true);
	}
	
	class NewHTFileCreationPage extends WizardNewFileCreationPage {
		
		IInputValidator validator;
		
		NewHTFileCreationPage(IStructuredSelection sel, IInputValidator validator){
			super("NewHTFileCreationPage", sel);
			setDescription("Enter the required data to generate website source files");
			this.validator = validator;
		}
		
		protected InputStream getInitialContents() {
			IFile file = newPageSelectionPage.getResult();
			if( file != null){
				try {
					return file.getContents();
				} catch (CoreException e) {
					WebpubUIPlugin.handleException(e);
				}
			}
			return null;
		}
		
		protected boolean validatePage() {
			String errMsg = validator.isValid(getFileName());
			if( errMsg != null){
				setErrorMessage(errMsg);
				return false;
			}
			return super.validatePage();
		}

	}
	
	public void addPages() {
		try{
			IResource res = (IResource)getSelection().getFirstElement();
			WebProject webProj = (WebProject)res.getProject().getNature(WebProject.ID_NATURE);

			String[] htExtensions = webProj.getArray(WebProject.KEY_HT_EXTENSIONS);
			IInputValidator validator = createHTFileValidator(htExtensions);
			
			// create new file page.
			newFilePage = new NewHTFileCreationPage(
				getSelection(),
				validator);
			addPage(newFilePage);	
			
			// create initial content file selection page
			IContainer folder = webProj.getFolder(WebProject.KEY_HTSOURCES_FOLDER);
			newPageSelectionPage = new InitialWebPageWizardPage(folder, validator);
			addPage(newPageSelectionPage);
		} catch (CoreException e){
			WebpubUIPlugin.handleException(e);
		}
		
		// sets image
		ImageDescriptor pageImgDesc = WebpubUIPlugin.getImageDescriptor("wizban/newwebpage_wiz.gif");

		IWizardPage[] pages = getPages();
		for (int i = 0; i < pages.length; i++) {
			pages[i].setImageDescriptor(pageImgDesc);
		}
	}

	/**
	 * Returns validator for check specify text represent html file name.
	 */
	static IInputValidator createHTFileValidator(String[] htExts){
		final String[] htExtensions = (String[])htExts.clone();
		Arrays.sort(htExtensions);
		
		return new IInputValidator() {
			public String isValid(String fileName) {
				int dotIndex = fileName.lastIndexOf('.');
				if( dotIndex == -1){
					return "Need to specify extension.";
				}
				String ext = fileName.substring(dotIndex+1);
				if( Arrays.binarySearch(htExtensions, ext) < 0){
					return "Specify text is not representation html file.";
				}
				return null;
			}
		};
	}

	public boolean performFinish() {
		IFile file = newFilePage.createNewFile();
		selectAndReveal(file);
		// Open editor on new file.
		IWorkbenchWindow window = getWorkbench().getActiveWorkbenchWindow();
		try {
			if (window != null) {
				IWorkbenchPage page = window.getActivePage();
				if (page != null)
					IDE.openEditor(page, file, true);
			}
		} catch (PartInitException e) {
			WebpubUIPlugin.handleException(e);
		}
		
		newPageSelectionPage.putHistory();
		
		return true;
	}

}
