/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class CfsSubsetEval
extends SubsetEvaluator
implements OptionHandler {
    private Instances m_trainInstances;
    private Discretize m_disTransform;
    private int m_classIndex;
    private boolean m_isNumeric;
    private int m_numAttribs;
    private int m_numInstances;
    private boolean m_missingSeperate;
    private boolean m_locallyPredictive;
    private float[][] m_corr_matrix;
    private double[] m_std_devs;
    private double m_c_Threshold;

    public String globalInfo() {
        return LocalString.get("CfsSubsetEval :\n\nEvaluates the worth of a subset of attributes ") + LocalString.get("by considering the individual predictive ability of each feature ") + LocalString.get("along with the degree of redundancy between them.\n\n") + LocalString.get("Subsets of features that are highly correlated with the class ") + LocalString.get("while having low intercorrelation are preferred.\n");
    }

    public CfsSubsetEval() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tTreat missing values as a seperate") + "\n\tvalue.", "M", 0, "-M"));
        vector.addElement(new Option(LocalString.get("\tDon't include locally predictive attributes") + ".", "L", 0, "-L"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setMissingSeperate(Utils.getFlag('M', stringArray));
        this.setLocallyPredictive(!Utils.getFlag('L', stringArray));
    }

    public String locallyPredictiveTipText() {
        return LocalString.get("Identify locally predictive attributes. Iteratively adds ") + LocalString.get("attributes with the highest correlation with the class as long ") + LocalString.get("as there is not already an attribute in the subset that has a ") + LocalString.get("higher correlation with the attribute in question");
    }

    public void setLocallyPredictive(boolean bl) {
        this.m_locallyPredictive = bl;
    }

    public boolean getLocallyPredictive() {
        return this.m_locallyPredictive;
    }

    public String missingSeperateTipText() {
        return LocalString.get("Treat missing as a separate value. Otherwise, counts for missing ") + LocalString.get("values are distributed across other values in proportion to their ") + "frequency.";
    }

    public void setMissingSeperate(boolean bl) {
        this.m_missingSeperate = bl;
    }

    public boolean getMissingSeperate() {
        return this.m_missingSeperate;
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        if (this.getMissingSeperate()) {
            stringArray[n++] = "-M";
        }
        if (!this.getLocallyPredictive()) {
            stringArray[n++] = "-L";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        int n;
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Can't handle string attributes!"));
        }
        this.m_trainInstances = instances;
        this.m_trainInstances.deleteWithMissingClass();
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_isNumeric = this.m_trainInstances.attribute(this.m_classIndex).isNumeric();
        if (!this.m_isNumeric) {
            this.m_disTransform = new Discretize();
            this.m_disTransform.setUseBetterEncoding(true);
            this.m_disTransform.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_disTransform);
        }
        this.m_std_devs = new double[this.m_numAttribs];
        this.m_corr_matrix = new float[this.m_numAttribs][];
        for (n = 0; n < this.m_numAttribs; ++n) {
            this.m_corr_matrix[n] = new float[n + 1];
        }
        for (n = 0; n < this.m_corr_matrix.length; ++n) {
            this.m_corr_matrix[n][n] = 1.0f;
            this.m_std_devs[n] = 1.0;
        }
        for (n = 0; n < this.m_numAttribs; ++n) {
            for (int i = 0; i < this.m_corr_matrix[n].length - 1; ++i) {
                this.m_corr_matrix[n][i] = -999.0f;
            }
        }
    }

    public double evaluateSubset(BitSet bitSet) throws Exception {
        float f;
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            int n2;
            int n3;
            if (n == this.m_classIndex || !bitSet.get(n)) continue;
            if (n > this.m_classIndex) {
                n3 = n;
                n2 = this.m_classIndex;
            } else {
                n2 = n;
                n3 = this.m_classIndex;
            }
            if (this.m_corr_matrix[n3][n2] == -999.0f) {
                this.m_corr_matrix[n3][n2] = f = this.correlate(n, this.m_classIndex);
                d += this.m_std_devs[n] * (double)f;
                continue;
            }
            d += this.m_std_devs[n] * (double)this.m_corr_matrix[n3][n2];
        }
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (n == this.m_classIndex || !bitSet.get(n)) continue;
            d2 += 1.0 * this.m_std_devs[n] * this.m_std_devs[n];
            for (int i = 0; i < this.m_corr_matrix[n].length - 1; ++i) {
                if (!bitSet.get(i)) continue;
                if (this.m_corr_matrix[n][i] == -999.0f) {
                    this.m_corr_matrix[n][i] = f = this.correlate(n, i);
                    d2 += 2.0 * this.m_std_devs[n] * this.m_std_devs[i] * (double)f;
                    continue;
                }
                d2 += 2.0 * this.m_std_devs[n] * this.m_std_devs[i] * (double)this.m_corr_matrix[n][i];
            }
        }
        if (d2 < 0.0) {
            d2 *= -1.0;
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = d / Math.sqrt(d2);
        if (d3 < 0.0) {
            d3 *= -1.0;
        }
        return d3;
    }

    private float correlate(int n, int n2) {
        if (!this.m_isNumeric) {
            return (float)this.symmUncertCorr(n, n2);
        }
        boolean bl = this.m_trainInstances.attribute(n).isNumeric();
        boolean bl2 = this.m_trainInstances.attribute(n2).isNumeric();
        if (bl && bl2) {
            return (float)this.num_num(n, n2);
        }
        if (bl2) {
            return (float)this.num_nom2(n, n2);
        }
        if (bl) {
            return (float)this.num_nom2(n2, n);
        }
        return (float)this.nom_nom(n, n2);
    }

    private double symmUncertCorr(int n, int n2) {
        double d;
        int n3;
        int n4;
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        if (n == this.m_classIndex || n2 == this.m_classIndex) {
            bl = true;
        }
        int n5 = this.m_trainInstances.attribute(n).numValues() + 1;
        int n6 = this.m_trainInstances.attribute(n2).numValues() + 1;
        double[][] dArray = new double[n5][n6];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n6];
        for (n4 = 0; n4 < n5; ++n4) {
            dArray2[n4] = 0.0;
            for (n3 = 0; n3 < n6; ++n3) {
                dArray3[n3] = 0.0;
                dArray[n4][n3] = 0.0;
            }
        }
        for (n4 = 0; n4 < this.m_numInstances; ++n4) {
            Instance instance = this.m_trainInstances.instance(n4);
            int n7 = instance.isMissing(n) ? n5 - 1 : (int)instance.value(n);
            int n8 = instance.isMissing(n2) ? n6 - 1 : (int)instance.value(n2);
            double[] dArray4 = dArray[n7];
            int n9 = n8;
            dArray4[n9] = dArray4[n9] + 1.0;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            dArray2[n4] = 0.0;
            for (n3 = 0; n3 < n6; ++n3) {
                int n10 = n4;
                dArray2[n10] = dArray2[n10] + dArray[n4][n3];
                d2 += dArray[n4][n3];
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            dArray3[n3] = 0.0;
            for (n4 = 0; n4 < n5; ++n4) {
                int n11 = n3;
                dArray3[n11] = dArray3[n11] + dArray[n4][n3];
            }
        }
        if (!this.m_missingSeperate && dArray2[n5 - 1] < (double)this.m_numInstances && dArray3[n6 - 1] < (double)this.m_numInstances) {
            double[] dArray5 = new double[dArray2.length];
            double[] dArray6 = new double[dArray3.length];
            double[][] dArray7 = new double[dArray2.length][dArray3.length];
            for (n4 = 0; n4 < n5; ++n4) {
                System.arraycopy(dArray[n4], 0, dArray7[n4], 0, dArray3.length);
            }
            System.arraycopy(dArray2, 0, dArray5, 0, dArray2.length);
            System.arraycopy(dArray3, 0, dArray6, 0, dArray3.length);
            double d4 = dArray2[n5 - 1] + dArray3[n6 - 1] - dArray[n5 - 1][n6 - 1];
            if (dArray2[n5 - 1] > 0.0) {
                for (n3 = 0; n3 < n6 - 1; ++n3) {
                    if (!(dArray[n5 - 1][n3] > 0.0)) continue;
                    n4 = 0;
                    while (n4 < n5 - 1) {
                        d3 = dArray5[n4] / (d2 - dArray5[n5 - 1]) * dArray[n5 - 1][n3];
                        double[] dArray8 = dArray[n4];
                        int n12 = n3;
                        dArray8[n12] = dArray8[n12] + d3;
                        int n13 = n4++;
                        dArray2[n13] = dArray2[n13] + d3;
                    }
                    dArray[n5 - 1][n3] = 0.0;
                }
            }
            dArray2[n5 - 1] = 0.0;
            if (dArray3[n6 - 1] > 0.0) {
                for (n4 = 0; n4 < n5 - 1; ++n4) {
                    if (!(dArray[n4][n6 - 1] > 0.0)) continue;
                    n3 = 0;
                    while (n3 < n6 - 1) {
                        d3 = dArray6[n3] / (d2 - dArray6[n6 - 1]) * dArray[n4][n6 - 1];
                        double[] dArray9 = dArray[n4];
                        int n14 = n3;
                        dArray9[n14] = dArray9[n14] + d3;
                        int n15 = n3++;
                        dArray3[n15] = dArray3[n15] + d3;
                    }
                    dArray[n4][n6 - 1] = 0.0;
                }
            }
            dArray3[n6 - 1] = 0.0;
            if (dArray[n5 - 1][n6 - 1] > 0.0 && d4 != d2) {
                for (n4 = 0; n4 < n5 - 1; ++n4) {
                    n3 = 0;
                    while (n3 < n6 - 1) {
                        d3 = dArray7[n4][n3] / (d2 - d4) * dArray7[n5 - 1][n6 - 1];
                        double[] dArray10 = dArray[n4];
                        int n16 = n3;
                        dArray10[n16] = dArray10[n16] + d3;
                        int n17 = n4;
                        dArray2[n17] = dArray2[n17] + d3;
                        int n18 = n3++;
                        dArray3[n18] = dArray3[n18] + d3;
                    }
                }
                dArray[n5 - 1][n6 - 1] = 0.0;
            }
        }
        if (Utils.eq(d = ContingencyTables.symmetricalUncertainty(dArray), 0.0)) {
            if (bl) {
                return 0.0;
            }
            return 1.0;
        }
        return d;
    }

    private double num_num(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(n));
        double d5 = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(n2));
        for (int i = 0; i < this.m_numInstances; ++i) {
            Instance instance = this.m_trainInstances.instance(i);
            double d6 = instance.isMissing(n) ? 0.0 : instance.value(n) - d4;
            double d7 = instance.isMissing(n2) ? 0.0 : instance.value(n2) - d5;
            d += d6 * d7;
            d2 += d6 * d6;
            d3 += d7 * d7;
        }
        if (d2 != 0.0 && this.m_std_devs[n] == 1.0) {
            this.m_std_devs[n] = Math.sqrt(d2 / (double)this.m_numInstances);
        }
        if (d3 != 0.0 && this.m_std_devs[n2] == 1.0) {
            this.m_std_devs[n2] = Math.sqrt(d3 / (double)this.m_numInstances);
        }
        if (d2 * d3 > 0.0) {
            double d8 = d / Math.sqrt(d2 * d3);
            return d8 < 0.0 ? -d8 : d8;
        }
        if (n != this.m_classIndex && n2 != this.m_classIndex) {
            return 1.0;
        }
        return 0.0;
    }

    private double num_nom2(int n, int n2) {
        double d;
        Instance instance;
        int n3;
        int n4 = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(n));
        double d2 = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(n2));
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = !this.m_missingSeperate ? this.m_trainInstances.attribute(n).numValues() : this.m_trainInstances.attribute(n).numValues() + 1;
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            dArray[n3] = 0.0;
            dArray3[n3] = 0.0;
            dArray2[n3] = 0.0;
        }
        for (n3 = 0; n3 < this.m_numInstances; ++n3) {
            instance = this.m_trainInstances.instance(n3);
            int n6 = instance.isMissing(n) ? (!this.m_missingSeperate ? n4 : n5 - 1) : (int)instance.value(n);
            int n7 = n6;
            dArray[n7] = dArray[n7] + 1.0;
        }
        for (int i = 0; i < this.m_numInstances; ++i) {
            instance = this.m_trainInstances.instance(i);
            double d6 = instance.isMissing(n2) ? 0.0 : instance.value(n2) - d2;
            d3 += d6 * d6;
            n3 = 0;
            while (n3 < n5) {
                d = instance.isMissing(n) ? (!this.m_missingSeperate ? (n3 == n4 ? 1.0 : 0.0) : (n3 == n5 - 1 ? 1.0 : 0.0)) : ((double)n3 == instance.value(n) ? 1.0 : 0.0);
                double d7 = d - dArray[n3] / (double)this.m_numInstances;
                int n8 = n3;
                dArray2[n8] = dArray2[n8] + d7 * d7;
                int n9 = n3++;
                dArray3[n9] = dArray3[n9] + d7 * d6;
            }
        }
        d = 0.0;
        for (n3 = 0; n3 < n5; ++n3) {
            d += dArray[n3] / (double)this.m_numInstances * (dArray2[n3] / (double)this.m_numInstances);
            if (dArray2[n3] * d3 > 0.0) {
                double d8 = dArray3[n3] / Math.sqrt(dArray2[n3] * d3);
                if (d8 < 0.0) {
                    d8 = -d8;
                }
                d4 += dArray[n3] / (double)this.m_numInstances * d8;
                continue;
            }
            if (n == this.m_classIndex || n2 == this.m_classIndex) continue;
            d4 += dArray[n3] / (double)this.m_numInstances * 1.0;
        }
        if (d != 0.0 && this.m_std_devs[n] == 1.0) {
            this.m_std_devs[n] = Math.sqrt(d);
        }
        if (d3 != 0.0 && this.m_std_devs[n2] == 1.0) {
            this.m_std_devs[n2] = Math.sqrt(d3 / (double)this.m_numInstances);
        }
        if (d4 == 0.0 && n != this.m_classIndex && n2 != this.m_classIndex) {
            d4 = 1.0;
        }
        return d4;
    }

    private double nom_nom(int n, int n2) {
        double d;
        double d2;
        Instance instance;
        int n3;
        int n4;
        int n5 = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(n));
        int n6 = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(n2));
        double d3 = 0.0;
        double d4 = 0.0;
        int n7 = !this.m_missingSeperate ? this.m_trainInstances.attribute(n).numValues() : this.m_trainInstances.attribute(n).numValues() + 1;
        int n8 = !this.m_missingSeperate ? this.m_trainInstances.attribute(n2).numValues() : this.m_trainInstances.attribute(n2).numValues() + 1;
        double[][] dArray = new double[n7][n8];
        double[] dArray2 = new double[n7];
        double[] dArray3 = new double[n8];
        double[] dArray4 = new double[n7];
        double[] dArray5 = new double[n8];
        double[][] dArray6 = new double[n7][n8];
        for (n4 = 0; n4 < n7; ++n4) {
            dArray4[n4] = 0.0;
            dArray2[n4] = 0.0;
        }
        for (n3 = 0; n3 < n8; ++n3) {
            dArray5[n3] = 0.0;
            dArray3[n3] = 0.0;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            for (n3 = 0; n3 < n8; ++n3) {
                dArray[n4][n3] = 0.0;
                dArray6[n4][n3] = 0.0;
            }
        }
        for (n4 = 0; n4 < this.m_numInstances; ++n4) {
            instance = this.m_trainInstances.instance(n4);
            int n9 = instance.isMissing(n) ? (!this.m_missingSeperate ? n5 : n7 - 1) : (int)instance.value(n);
            int n10 = instance.isMissing(n2) ? (!this.m_missingSeperate ? n6 : n8 - 1) : (int)instance.value(n2);
            double[] dArray7 = dArray[n9];
            int n11 = n10;
            dArray7[n11] = dArray7[n11] + 1.0;
            int n12 = n9;
            dArray2[n12] = dArray2[n12] + 1.0;
            int n13 = n10;
            dArray3[n13] = dArray3[n13] + 1.0;
        }
        for (int i = 0; i < this.m_numInstances; ++i) {
            double d5;
            instance = this.m_trainInstances.instance(i);
            n3 = 0;
            while (n3 < n8) {
                d2 = instance.isMissing(n2) ? (!this.m_missingSeperate ? (n3 == n6 ? 1.0 : 0.0) : (n3 == n8 - 1 ? 1.0 : 0.0)) : ((double)n3 == instance.value(n2) ? 1.0 : 0.0);
                d5 = d2 - dArray3[n3] / (double)this.m_numInstances;
                int n14 = n3++;
                dArray5[n14] = dArray5[n14] + d5 * d5;
            }
            for (n4 = 0; n4 < n7; ++n4) {
                d = instance.isMissing(n) ? (!this.m_missingSeperate ? (n4 == n5 ? 1.0 : 0.0) : (n4 == n7 - 1 ? 1.0 : 0.0)) : ((double)n4 == instance.value(n) ? 1.0 : 0.0);
                double d6 = d - dArray2[n4] / (double)this.m_numInstances;
                int n15 = n4;
                dArray4[n15] = dArray4[n15] + d6 * d6;
                n3 = 0;
                while (n3 < n8) {
                    d2 = instance.isMissing(n2) ? (!this.m_missingSeperate ? (n3 == n6 ? 1.0 : 0.0) : (n3 == n8 - 1 ? 1.0 : 0.0)) : ((double)n3 == instance.value(n2) ? 1.0 : 0.0);
                    d5 = d2 - dArray3[n3] / (double)this.m_numInstances;
                    double[] dArray8 = dArray6[n4];
                    int n16 = n3++;
                    dArray8[n16] = dArray8[n16] + d6 * d5;
                }
            }
        }
        for (n4 = 0; n4 < n7; ++n4) {
            for (n3 = 0; n3 < n8; ++n3) {
                if (dArray4[n4] * dArray5[n3] > 0.0) {
                    double d7 = dArray6[n4][n3] / Math.sqrt(dArray4[n4] * dArray5[n3]);
                    if (d7 < 0.0) {
                        d7 = -d7;
                    }
                    d3 += dArray[n4][n3] / (double)this.m_numInstances * d7;
                    continue;
                }
                if (n == this.m_classIndex || n2 == this.m_classIndex) continue;
                d3 += dArray[n4][n3] / (double)this.m_numInstances * 1.0;
            }
        }
        d = 0.0;
        for (n4 = 0; n4 < n7; ++n4) {
            d += dArray2[n4] / (double)this.m_numInstances * (dArray4[n4] / (double)this.m_numInstances);
        }
        if (d != 0.0 && this.m_std_devs[n] == 1.0) {
            this.m_std_devs[n] = Math.sqrt(d);
        }
        d2 = 0.0;
        for (n3 = 0; n3 < n8; ++n3) {
            d2 += dArray3[n3] / (double)this.m_numInstances * (dArray5[n3] / (double)this.m_numInstances);
        }
        if (d2 != 0.0 && this.m_std_devs[n2] == 1.0) {
            this.m_std_devs[n2] = Math.sqrt(d2);
        }
        if (d3 == 0.0 && n != this.m_classIndex && n2 != this.m_classIndex) {
            d3 = 1.0;
        }
        return d3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainInstances == null) {
            stringBuffer.append(LocalString.get("CFS subset evaluator has not been built yet\n"));
        } else {
            stringBuffer.append(LocalString.get("\tCFS Subset Evaluator\n"));
            if (this.m_missingSeperate) {
                stringBuffer.append(LocalString.get("\tTreating missing values as a seperate value\n"));
            }
            if (this.m_locallyPredictive) {
                stringBuffer.append(LocalString.get("\tIncluding locally predictive attributes\n"));
            }
        }
        return stringBuffer.toString();
    }

    private void addLocallyPredictive(BitSet bitSet) {
        boolean bl = false;
        boolean bl2 = true;
        double d = -1.0;
        int n = 0;
        BitSet bitSet2 = (BitSet)bitSet.clone();
        while (!bl) {
            float f;
            int n2;
            int n3;
            int n4;
            d = -1.0;
            for (n4 = 0; n4 < this.m_numAttribs; ++n4) {
                if (n4 > this.m_classIndex) {
                    n3 = n4;
                    n2 = this.m_classIndex;
                } else {
                    n2 = n4;
                    n3 = this.m_classIndex;
                }
                if (bitSet2.get(n4) || n4 == this.m_classIndex) continue;
                if (this.m_corr_matrix[n3][n2] == -999.0f) {
                    this.m_corr_matrix[n3][n2] = f = this.correlate(n4, this.m_classIndex);
                }
                if (!((double)this.m_corr_matrix[n3][n2] > d)) continue;
                d = this.m_corr_matrix[n3][n2];
                n = n4;
            }
            if (d == -1.0) {
                bl = true;
                continue;
            }
            bl2 = true;
            bitSet2.set(n);
            for (n4 = 0; n4 < this.m_numAttribs; ++n4) {
                if (n4 > n) {
                    n3 = n4;
                    n2 = n;
                } else {
                    n3 = n;
                    n2 = n4;
                }
                if (!bitSet.get(n4)) continue;
                if (this.m_corr_matrix[n3][n2] == -999.0f) {
                    this.m_corr_matrix[n3][n2] = f = this.correlate(n4, n);
                }
                if (!((double)this.m_corr_matrix[n3][n2] > d - this.m_c_Threshold)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            bitSet.set(n);
        }
    }

    public int[] postProcess(int[] nArray) throws Exception {
        int n;
        int n2 = 0;
        if (!this.m_locallyPredictive) {
            return nArray;
        }
        BitSet bitSet = new BitSet(this.m_numAttribs);
        for (n = 0; n < nArray.length; ++n) {
            bitSet.set(nArray[n]);
        }
        this.addLocallyPredictive(bitSet);
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        n2 = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray2[n2++] = i;
        }
        return nArray2;
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_missingSeperate = false;
        this.m_locallyPredictive = true;
        this.m_c_Threshold = 0.0;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(AttributeSelection.SelectAttributes(new CfsSubsetEval(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

