/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.util.Random;
import weka.LocalString;
import weka.classifiers.functions.pace.DoubleVector;
import weka.core.Statistics;

public class Maths {
    public static final double PSI = 0.3989422804014327;
    public static final double logPSI = -0.9189385332046727;
    public static final int undefinedDistribution = 0;
    public static final int normalDistribution = 1;
    public static final int chisqDistribution = 2;

    public static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static double square(double d) {
        return d * d;
    }

    public static double pnorm(double d) {
        return Statistics.normalProbability(d);
    }

    public static double pnorm(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException(LocalString.get("standard deviation <= 0.0"));
        }
        return Maths.pnorm((d - d2) / d3);
    }

    public static DoubleVector pnorm(double d, DoubleVector doubleVector, double d2) {
        DoubleVector doubleVector2 = new DoubleVector(doubleVector.size());
        for (int i = 0; i < doubleVector.size(); ++i) {
            doubleVector2.set(i, Maths.pnorm(d, doubleVector.get(i), d2));
        }
        return doubleVector2;
    }

    public static double dnorm(double d) {
        return Math.exp(-d * d / 2.0) * 0.3989422804014327;
    }

    public static double dnorm(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException(LocalString.get("standard deviation <= 0.0"));
        }
        return Maths.dnorm((d - d2) / d3);
    }

    public static DoubleVector dnorm(double d, DoubleVector doubleVector, double d2) {
        DoubleVector doubleVector2 = new DoubleVector(doubleVector.size());
        for (int i = 0; i < doubleVector.size(); ++i) {
            doubleVector2.set(i, Maths.dnorm(d, doubleVector.get(i), d2));
        }
        return doubleVector2;
    }

    public static double dnormLog(double d) {
        return -0.9189385332046727 - d * d / 2.0;
    }

    public static double dnormLog(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException(LocalString.get("standard deviation <= 0.0"));
        }
        return -Math.log(d3) + Maths.dnormLog((d - d2) / d3);
    }

    public static DoubleVector dnormLog(double d, DoubleVector doubleVector, double d2) {
        DoubleVector doubleVector2 = new DoubleVector(doubleVector.size());
        for (int i = 0; i < doubleVector.size(); ++i) {
            doubleVector2.set(i, Maths.dnormLog(d, doubleVector.get(i), d2));
        }
        return doubleVector2;
    }

    public static DoubleVector rnorm(int n, double d, double d2, Random random) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException(LocalString.get("standard deviation < 0.0"));
        }
        if (d2 == 0.0) {
            return new DoubleVector(n, d);
        }
        DoubleVector doubleVector = new DoubleVector(n);
        for (int i = 0; i < n; ++i) {
            doubleVector.set(i, (random.nextGaussian() + d) / d2);
        }
        return doubleVector;
    }

    public static double pchisq(double d) {
        double d2 = Math.sqrt(d);
        return Maths.pnorm(d2) - Maths.pnorm(-d2);
    }

    public static double pchisq(double d, double d2) {
        double d3 = Math.sqrt(d2);
        double d4 = Math.sqrt(d);
        return Maths.pnorm(d4 - d3) - Maths.pnorm(-d4 - d3);
    }

    public static DoubleVector pchisq(double d, DoubleVector doubleVector) {
        int n = doubleVector.size();
        DoubleVector doubleVector2 = new DoubleVector(n);
        double d2 = Math.sqrt(d);
        for (int i = 0; i < n; ++i) {
            double d3 = Math.sqrt(doubleVector.get(i));
            doubleVector2.set(i, Maths.pnorm(d2 - d3) - Maths.pnorm(-d2 - d3));
        }
        return doubleVector2;
    }

    public static double dchisq(double d) {
        if (d == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = Math.sqrt(d);
        return Maths.dnorm(d2) / d2;
    }

    public static double dchisq(double d, double d2) {
        if (d2 == 0.0) {
            return Maths.dchisq(d);
        }
        double d3 = Math.sqrt(d);
        double d4 = Math.sqrt(d2);
        return (Maths.dnorm(d3 - d4) + Maths.dnorm(-d3 - d4)) / (2.0 * d3);
    }

    public static DoubleVector dchisq(double d, DoubleVector doubleVector) {
        int n = doubleVector.size();
        DoubleVector doubleVector2 = new DoubleVector(n);
        double d2 = Math.sqrt(d);
        for (int i = 0; i < n; ++i) {
            double d3 = Math.sqrt(doubleVector.get(i));
            if (doubleVector.get(i) == 0.0) {
                doubleVector2.set(i, Maths.dchisq(d));
                continue;
            }
            doubleVector2.set(i, (Maths.dnorm(d2 - d3) + Maths.dnorm(-d2 - d3)) / (2.0 * d2));
        }
        return doubleVector2;
    }

    public static double dchisqLog(double d) {
        if (d == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = Math.sqrt(d);
        return Maths.dnormLog(d2) - Math.log(d2);
    }

    public static double dchisqLog(double d, double d2) {
        if (d2 == 0.0) {
            return Maths.dchisqLog(d);
        }
        double d3 = Math.sqrt(d);
        double d4 = Math.sqrt(d2);
        return Math.log(Maths.dnorm(d3 - d4) + Maths.dnorm(-d3 - d4)) - Math.log(2.0 * d3);
    }

    public static DoubleVector dchisqLog(double d, DoubleVector doubleVector) {
        DoubleVector doubleVector2 = new DoubleVector(doubleVector.size());
        double d2 = Math.sqrt(d);
        for (int i = 0; i < doubleVector.size(); ++i) {
            double d3 = Math.sqrt(doubleVector.get(i));
            if (doubleVector.get(i) == 0.0) {
                doubleVector2.set(i, Maths.dchisqLog(d));
                continue;
            }
            doubleVector2.set(i, Math.log(Maths.dnorm(d2 - d3) + Maths.dnorm(-d2 - d3)) - Math.log(2.0 * d2));
        }
        return doubleVector2;
    }

    public static DoubleVector rchisq(int n, double d, Random random) {
        DoubleVector doubleVector = new DoubleVector(n);
        double d2 = Math.sqrt(d);
        for (int i = 0; i < n; ++i) {
            double d3 = random.nextGaussian() + d2;
            doubleVector.set(i, d3 * d3);
        }
        return doubleVector;
    }
}

