/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;

public class OrdinalClassClassifier
extends SingleClassifierEnhancer
implements OptionHandler {
    private Classifier[] m_Classifiers;
    private MakeIndicator[] m_ClassFilters;
    private Attribute m_ClassAttribute;
    private ZeroR m_ZeroR;

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public OrdinalClassClassifier() {
        this.m_Classifier = new J48();
    }

    public String globalInfo() {
        return LocalString.get(" Meta classifier that allows standard classification algorithms ") + LocalString.get("to be applied to ordinal class problems.  For more information see: ") + LocalString.get("Frank, E. and Hall, M. (in press). A simple approach to ordinal ") + LocalString.get("prediction. 12th European Conference on Machine Learning. Freiburg, ") + "Germany.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException(LocalString.get("OrdinalClassClassifier: class should ") + LocalString.get("be declared nominal!"));
        }
        if (this.m_Classifier == null) {
            throw new Exception(LocalString.get("No base classifier has been set!"));
        }
        this.m_ZeroR = new ZeroR();
        this.m_ZeroR.buildClassifier(instances);
        int n = instances.numClasses() - 1;
        int n2 = n = n == 0 ? 1 : n;
        if (n == 1) {
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, 1);
            this.m_Classifiers[0].buildClassifier(instances);
        } else {
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, n);
            this.m_ClassFilters = new MakeIndicator[n];
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                this.m_ClassFilters[i] = new MakeIndicator();
                this.m_ClassFilters[i].setAttributeIndex("" + (instances.classIndex() + 1));
                this.m_ClassFilters[i].setValueIndices("" + (i + 2) + "-last");
                this.m_ClassFilters[i].setNumeric(false);
                this.m_ClassFilters[i].setInputFormat(instances);
                Instances instances2 = Filter.useFilter(instances, this.m_ClassFilters[i]);
                this.m_Classifiers[i].buildClassifier(instances2);
            }
        }
        this.m_ClassAttribute = instances.classAttribute();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        if (this.m_Classifiers.length == 1) {
            return this.m_Classifiers[0].distributionForInstance(instance);
        }
        double[] dArray = new double[instance.numClasses()];
        double[][] dArray2 = new double[this.m_ClassFilters.length][0];
        for (n = 0; n < this.m_ClassFilters.length; ++n) {
            this.m_ClassFilters[n].input(instance);
            this.m_ClassFilters[n].batchFinished();
            dArray2[n] = this.m_Classifiers[n].distributionForInstance(this.m_ClassFilters[n].output());
        }
        for (n = 0; n < instance.numClasses(); ++n) {
            if (n == 0) {
                dArray[n] = dArray2[0][0];
                continue;
            }
            if (n == instance.numClasses() - 1) {
                dArray[n] = dArray2[n - 1][1];
                continue;
            }
            dArray[n] = dArray2[n - 1][1] - dArray2[n][1];
            if (dArray[n] > 0.0) continue;
            System.err.println(LocalString.get("Warning: estimated probability ") + dArray[n] + LocalString.get(". Rounding to 0."));
            dArray[n] = 0.0;
        }
        if (Utils.gr(Utils.sum(dArray), 0.0)) {
            Utils.normalize(dArray);
            return dArray;
        }
        return this.m_ZeroR.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        return super.getOptions();
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return LocalString.get("OrdinalClassClassifier: No model built yet.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OrdinalClassClassifier\n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append(LocalString.get("Classifier ")).append(i + 1);
            if (this.m_Classifiers[i] != null) {
                if (this.m_ClassFilters != null && this.m_ClassFilters[i] != null) {
                    stringBuffer.append(LocalString.get(", using indicator values: "));
                    stringBuffer.append(this.m_ClassFilters[i].getValueRange());
                }
                stringBuffer.append('\n');
                stringBuffer.append(this.m_Classifiers[i].toString() + "\n");
                continue;
            }
            stringBuffer.append(LocalString.get(" Skipped (no training examples)\n"));
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            OrdinalClassClassifier ordinalClassClassifier = new OrdinalClassClassifier();
            System.out.println(Evaluation.evaluateModel(ordinalClassClassifier, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

