/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.IterativeClassifier;
import weka.classifiers.trees.adtree.PredictionNode;
import weka.classifiers.trees.adtree.ReferenceInstances;
import weka.classifiers.trees.adtree.Splitter;
import weka.classifiers.trees.adtree.TwoWayNominalSplit;
import weka.classifiers.trees.adtree.TwoWayNumericSplit;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.Tag;
import weka.core.UnassignedClassException;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class ADTree
extends Classifier
implements OptionHandler,
Drawable,
AdditionalMeasureProducer,
WeightedInstancesHandler,
IterativeClassifier {
    public static final int SEARCHPATH_ALL = 0;
    public static final int SEARCHPATH_HEAVIEST = 1;
    public static final int SEARCHPATH_ZPURE = 2;
    public static final int SEARCHPATH_RANDOM = 3;
    public static final Tag[] TAGS_SEARCHPATH = new Tag[]{new Tag(0, LocalString.get("Expand all paths")), new Tag(1, LocalString.get("Expand the heaviest path")), new Tag(2, LocalString.get("Expand the best z-pure path")), new Tag(3, LocalString.get("Expand a random path"))};
    protected Instances m_trainInstances;
    protected PredictionNode m_root = null;
    protected Random m_random = null;
    protected int m_lastAddedSplitNum = 0;
    protected int[] m_numericAttIndices;
    protected int[] m_nominalAttIndices;
    protected double m_trainTotalWeight;
    protected ReferenceInstances m_posTrainInstances;
    protected ReferenceInstances m_negTrainInstances;
    protected PredictionNode m_search_bestInsertionNode;
    protected Splitter m_search_bestSplitter;
    protected double m_search_smallestZ;
    protected Instances m_search_bestPathPosInstances;
    protected Instances m_search_bestPathNegInstances;
    protected int m_nodesExpanded = 0;
    protected int m_examplesCounted = 0;
    protected int m_boostingIterations = 10;
    protected int m_searchPath = 0;
    protected int m_randomSeed = 0;
    protected boolean m_saveInstanceData = false;

    public String globalInfo() {
        return LocalString.get("Class for generating an alternating decision tree. The basic ") + LocalString.get("algorithm is based on:\n\n") + LocalString.get("Freund, Y., Mason, L.: \"The alternating decision tree learning algorithm\". ") + LocalString.get("Proceeding of the Sixteenth International Conference on Machine Learning, ") + LocalString.get("Bled, Slovenia, (1999) 124-133.\n\n") + LocalString.get("This version currently only supports two-class problems. The number of boosting ") + LocalString.get("iterations needs to be manually tuned to suit the dataset and the desired ") + LocalString.get("complexity/accuracy tradeoff. Induction of the trees has been optimized, and heuristic ") + LocalString.get("search methods have been introduced to speed learning.");
    }

    public void initClassifier(Instances instances) throws Exception {
        this.m_nodesExpanded = 0;
        this.m_examplesCounted = 0;
        this.m_lastAddedSplitNum = 0;
        if (instances.classIndex() < 0) {
            throw new UnassignedClassException(LocalString.get("ADTree: Needs a class to be assigned"));
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("ADTree: Can't handle string attributes"));
        }
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException(LocalString.get("ADTree: Class must be nominal"));
        }
        if (instances.numClasses() != 2) {
            throw new UnsupportedClassTypeException(LocalString.get("ADTree: Must be a two-class problem"));
        }
        this.m_random = new Random(this.m_randomSeed);
        this.m_trainInstances = new Instances(instances);
        this.m_trainInstances.deleteWithMissingClass();
        this.m_posTrainInstances = new ReferenceInstances(this.m_trainInstances, this.m_trainInstances.numInstances());
        this.m_negTrainInstances = new ReferenceInstances(this.m_trainInstances, this.m_trainInstances.numInstances());
        Enumeration enumeration = this.m_trainInstances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if ((int)instance.classValue() == 0) {
                this.m_negTrainInstances.addReference(instance);
                continue;
            }
            this.m_posTrainInstances.addReference(instance);
        }
        this.m_posTrainInstances.compactify();
        this.m_negTrainInstances.compactify();
        double d = this.calcPredictionValue(this.m_posTrainInstances, this.m_negTrainInstances);
        this.m_root = new PredictionNode(d);
        this.updateWeights(this.m_posTrainInstances, this.m_negTrainInstances, d);
        this.generateAttributeIndicesSingle();
    }

    public void next(int n) throws Exception {
        this.boost();
    }

    public void boost() throws Exception {
        if (this.m_trainInstances == null || this.m_trainInstances.numInstances() == 0) {
            throw new Exception(LocalString.get("Trying to boost with no training data"));
        }
        this.searchForBestTestSingle();
        if (this.m_search_bestSplitter == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            ReferenceInstances referenceInstances = this.m_search_bestSplitter.instancesDownBranch(i, this.m_search_bestPathPosInstances);
            ReferenceInstances referenceInstances2 = this.m_search_bestSplitter.instancesDownBranch(i, this.m_search_bestPathNegInstances);
            double d = this.calcPredictionValue(referenceInstances, referenceInstances2);
            PredictionNode predictionNode = new PredictionNode(d);
            this.updateWeights(referenceInstances, referenceInstances2, d);
            this.m_search_bestSplitter.setChildForBranch(i, predictionNode);
        }
        this.m_search_bestInsertionNode.addChild(this.m_search_bestSplitter, this);
        this.m_search_bestPathPosInstances = null;
        this.m_search_bestPathNegInstances = null;
        this.m_search_bestSplitter = null;
    }

    private void generateAttributeIndicesSingle() {
        int n;
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector();
        for (n = 0; n < this.m_trainInstances.numAttributes(); ++n) {
            if (n == this.m_trainInstances.classIndex()) continue;
            if (this.m_trainInstances.attribute(n).isNumeric()) {
                fastVector2.addElement(new Integer(n));
                continue;
            }
            fastVector.addElement(new Integer(n));
        }
        this.m_nominalAttIndices = new int[fastVector.size()];
        for (n = 0; n < fastVector.size(); ++n) {
            this.m_nominalAttIndices[n] = (Integer)fastVector.elementAt(n);
        }
        this.m_numericAttIndices = new int[fastVector2.size()];
        for (n = 0; n < fastVector2.size(); ++n) {
            this.m_numericAttIndices[n] = (Integer)fastVector2.elementAt(n);
        }
    }

    private void searchForBestTestSingle() throws Exception {
        this.m_trainTotalWeight = this.m_trainInstances.sumOfWeights();
        this.m_search_smallestZ = Double.POSITIVE_INFINITY;
        this.searchForBestTestSingle(this.m_root, this.m_posTrainInstances, this.m_negTrainInstances);
    }

    private void searchForBestTestSingle(PredictionNode predictionNode, Instances instances, Instances instances2) throws Exception {
        if (instances.numInstances() == 0 || instances2.numInstances() == 0) {
            return;
        }
        if (this.calcZpure(instances, instances2) >= this.m_search_smallestZ) {
            return;
        }
        ++this.m_nodesExpanded;
        this.m_examplesCounted += instances.numInstances() + instances2.numInstances();
        for (int i = 0; i < this.m_nominalAttIndices.length; ++i) {
            this.evaluateNominalSplitSingle(this.m_nominalAttIndices[i], predictionNode, instances, instances2);
        }
        if (this.m_numericAttIndices.length > 0) {
            Instances instances3 = new Instances(instances);
            Enumeration enumeration = instances2.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                instances3.add((Instance)enumeration.nextElement());
            }
            for (int i = 0; i < this.m_numericAttIndices.length; ++i) {
                this.evaluateNumericSplitSingle(this.m_numericAttIndices[i], predictionNode, instances, instances2, instances3);
            }
        }
        if (predictionNode.getChildren().size() == 0) {
            return;
        }
        switch (this.m_searchPath) {
            case 0: {
                this.goDownAllPathsSingle(predictionNode, instances, instances2);
                break;
            }
            case 1: {
                this.goDownHeaviestPathSingle(predictionNode, instances, instances2);
                break;
            }
            case 2: {
                this.goDownZpurePathSingle(predictionNode, instances, instances2);
                break;
            }
            case 3: {
                this.goDownRandomPathSingle(predictionNode, instances, instances2);
            }
        }
    }

    private void goDownAllPathsSingle(PredictionNode predictionNode, Instances instances, Instances instances2) throws Exception {
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                this.searchForBestTestSingle(splitter.getChildForBranch(i), splitter.instancesDownBranch(i, instances), splitter.instancesDownBranch(i, instances2));
            }
        }
    }

    private void goDownHeaviestPathSingle(PredictionNode predictionNode, Instances instances, Instances instances2) throws Exception {
        Splitter splitter = null;
        int n = 0;
        double d = 0.0;
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter2 = (Splitter)enumeration.nextElement();
            for (int i = 0; i < splitter2.getNumOfBranches(); ++i) {
                double d2 = splitter2.instancesDownBranch(i, instances).sumOfWeights() + splitter2.instancesDownBranch(i, instances2).sumOfWeights();
                if (!(d2 > d)) continue;
                splitter = splitter2;
                n = i;
                d = d2;
            }
        }
        if (splitter != null) {
            this.searchForBestTestSingle(splitter.getChildForBranch(n), splitter.instancesDownBranch(n, instances), splitter.instancesDownBranch(n, instances2));
        }
    }

    private void goDownZpurePathSingle(PredictionNode predictionNode, Instances instances, Instances instances2) throws Exception {
        double d = this.m_search_smallestZ;
        PredictionNode predictionNode2 = null;
        ReferenceInstances referenceInstances = null;
        ReferenceInstances referenceInstances2 = null;
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                ReferenceInstances referenceInstances3;
                ReferenceInstances referenceInstances4 = splitter.instancesDownBranch(i, instances);
                double d2 = this.calcZpure(referenceInstances4, referenceInstances3 = splitter.instancesDownBranch(i, instances2));
                if (!(d2 < d)) continue;
                d = d2;
                predictionNode2 = splitter.getChildForBranch(i);
                referenceInstances = referenceInstances4;
                referenceInstances2 = referenceInstances3;
            }
        }
        if (predictionNode2 != null) {
            this.searchForBestTestSingle(predictionNode2, referenceInstances, referenceInstances2);
        }
    }

    private void goDownRandomPathSingle(PredictionNode predictionNode, Instances instances, Instances instances2) throws Exception {
        FastVector fastVector = predictionNode.getChildren();
        Splitter splitter = (Splitter)fastVector.elementAt(this.getRandom(fastVector.size()));
        int n = this.getRandom(splitter.getNumOfBranches());
        this.searchForBestTestSingle(splitter.getChildForBranch(n), splitter.instancesDownBranch(n, instances), splitter.instancesDownBranch(n, instances2));
    }

    private void evaluateNominalSplitSingle(int n, PredictionNode predictionNode, Instances instances, Instances instances2) {
        double[] dArray = this.findLowestZNominalSplit(instances, instances2, n);
        if (dArray[1] < this.m_search_smallestZ) {
            this.m_search_smallestZ = dArray[1];
            this.m_search_bestInsertionNode = predictionNode;
            this.m_search_bestSplitter = new TwoWayNominalSplit(n, (int)dArray[0]);
            this.m_search_bestPathPosInstances = instances;
            this.m_search_bestPathNegInstances = instances2;
        }
    }

    private void evaluateNumericSplitSingle(int n, PredictionNode predictionNode, Instances instances, Instances instances2, Instances instances3) throws Exception {
        double[] dArray = this.findLowestZNumericSplit(instances3, n);
        if (dArray[1] < this.m_search_smallestZ) {
            this.m_search_smallestZ = dArray[1];
            this.m_search_bestInsertionNode = predictionNode;
            this.m_search_bestSplitter = new TwoWayNumericSplit(n, dArray[0]);
            this.m_search_bestPathPosInstances = instances;
            this.m_search_bestPathNegInstances = instances2;
        }
    }

    private double calcPredictionValue(Instances instances, Instances instances2) {
        return 0.5 * Math.log((instances.sumOfWeights() + 1.0) / (instances2.sumOfWeights() + 1.0));
    }

    private double calcZpure(Instances instances, Instances instances2) {
        double d = instances.sumOfWeights();
        double d2 = instances2.sumOfWeights();
        return 2.0 * (Math.sqrt(d + 1.0) + Math.sqrt(d2 + 1.0)) + (this.m_trainTotalWeight - (d + d2));
    }

    private void updateWeights(Instances instances, Instances instances2, double d) {
        Instance instance;
        double d2 = Math.pow(Math.E, -d);
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            instance = (Instance)enumeration.nextElement();
            instance.setWeight(instance.weight() * d2);
        }
        d2 = Math.pow(Math.E, d);
        enumeration = instances2.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            instance = (Instance)enumeration.nextElement();
            instance.setWeight(instance.weight() * d2);
        }
    }

    private double[] findLowestZNominalSplit(Instances instances, Instances instances2, int n) {
        double d = Double.MAX_VALUE;
        int n2 = 0;
        double[] dArray = this.attributeValueWeights(instances, n);
        double[] dArray2 = this.attributeValueWeights(instances2, n);
        double d2 = Utils.sum(dArray);
        double d3 = Utils.sum(dArray2);
        int n3 = dArray.length;
        if (n3 == 2) {
            n3 = 1;
        }
        for (int i = 0; i < n3; ++i) {
            double d4 = dArray[i] + 1.0;
            double d5 = dArray2[i] + 1.0;
            double d6 = d2 - d4 + 2.0;
            double d7 = d3 - d5 + 2.0;
            double d8 = this.m_trainTotalWeight + 4.0 - (d4 + d5 + d6 + d7);
            double d9 = 2.0 * (Math.sqrt(d4 * d5) + Math.sqrt(d6 * d7)) + d8;
            if (!(d9 < d)) continue;
            d = d9;
            n2 = i;
        }
        double[] dArray3 = new double[]{n2, d};
        return dArray3;
    }

    private double[] attributeValueWeights(Instances instances, int n) {
        double[] dArray = new double[instances.attribute(n).numValues()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (instance.isMissing(n)) continue;
            int n2 = (int)instance.value(n);
            dArray[n2] = dArray[n2] + instance.weight();
        }
        return dArray;
    }

    private double[] findLowestZNumericSplit(Instances instances, int n) throws Exception {
        Instance instance;
        int n2;
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        int n3 = 0;
        double[][] dArray = new double[3][instances.numClasses()];
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            instance = instances.instance(n2);
            if (!instance.isMissing(n)) {
                double[] dArray2 = dArray[1];
                int n4 = (int)instance.classValue();
                dArray2[n4] = dArray2[n4] + instance.weight();
                continue;
            }
            double[] dArray3 = dArray[2];
            int n5 = (int)instance.classValue();
            dArray3[n5] = dArray3[n5] + instance.weight();
            ++n3;
        }
        instances.sort(n);
        for (n2 = 0; n2 < instances.numInstances() - (n3 + 1); ++n2) {
            instance = instances.instance(n2);
            Instance instance2 = instances.instance(n2 + 1);
            double[] dArray4 = dArray[0];
            int n6 = (int)instance.classValue();
            dArray4[n6] = dArray4[n6] + instance.weight();
            double[] dArray5 = dArray[1];
            int n7 = (int)instance.classValue();
            dArray5[n7] = dArray5[n7] - instance.weight();
            if (!Utils.sm(instance.value(n), instance2.value(n))) continue;
            double d3 = (instance.value(n) + instance2.value(n)) / 2.0;
            double d4 = this.conditionedZOnRows(dArray);
            if (!(d4 < d2)) continue;
            d = d3;
            d2 = d4;
        }
        double[] dArray6 = new double[]{d, d2};
        return dArray6;
    }

    private double conditionedZOnRows(double[][] dArray) {
        double d = dArray[0][0] + 1.0;
        double d2 = dArray[0][1] + 1.0;
        double d3 = dArray[1][0] + 1.0;
        double d4 = dArray[1][1] + 1.0;
        double d5 = this.m_trainTotalWeight + 4.0 - (d + d2 + d3 + d4);
        return 2.0 * (Math.sqrt(d * d2) + Math.sqrt(d3 * d4)) + d5;
    }

    public double[] distributionForInstance(Instance instance) {
        double d = this.predictionValueForInstance(instance, this.m_root, 0.0);
        double[] dArray = new double[]{1.0 / (1.0 + Math.pow(Math.E, d)), 1.0 / (1.0 + Math.pow(Math.E, -d))};
        return dArray;
    }

    protected double predictionValueForInstance(Instance instance, PredictionNode predictionNode, double d) {
        d += predictionNode.getValue();
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            int n = splitter.branchInstanceGoesDown(instance);
            if (n < 0) continue;
            d = this.predictionValueForInstance(instance, splitter.getChildForBranch(n), d);
        }
        return d;
    }

    public String toString() {
        if (this.m_root == null) {
            return LocalString.get("ADTree not built yet");
        }
        return LocalString.get("Alternating decision tree:\n\n") + this.toString(this.m_root, 1) + LocalString.get("\nLegend: ") + this.legend() + LocalString.get("\nTree size (total number of nodes): ") + this.numOfAllNodes(this.m_root) + LocalString.get("\nLeaves (number of predictor nodes): ") + this.numOfPredictionNodes(this.m_root);
    }

    protected String toString(PredictionNode predictionNode, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(": " + Utils.doubleToString(predictionNode.getValue(), 3));
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                PredictionNode predictionNode2 = splitter.getChildForBranch(i);
                if (predictionNode2 == null) continue;
                stringBuffer.append("\n");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append("|  ");
                }
                stringBuffer.append("(" + splitter.orderAdded + ")");
                stringBuffer.append(splitter.attributeString(this.m_trainInstances) + " " + splitter.comparisonString(i, this.m_trainInstances));
                stringBuffer.append(this.toString(predictionNode2, n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("digraph ADTree {\n"));
        this.graphTraverse(this.m_root, stringBuffer, 0, 0, this.m_trainInstances);
        return stringBuffer.toString() + "}\n";
    }

    protected void graphTraverse(PredictionNode predictionNode, StringBuffer stringBuffer, int n, int n2, Instances instances) throws Exception {
        stringBuffer.append("S" + n + "P" + n2 + LocalString.get(" [label=\""));
        stringBuffer.append(Utils.doubleToString(predictionNode.getValue(), 3));
        if (n == 0) {
            stringBuffer.append(" (" + this.legend() + ")");
        }
        stringBuffer.append(LocalString.get("\" shape=box style=filled"));
        if (instances.numInstances() > 0) {
            stringBuffer.append(LocalString.get(" data=\n") + instances + "\n,\n");
        }
        stringBuffer.append("]\n");
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            stringBuffer.append("S" + n + "P" + n2 + "->" + "S" + splitter.orderAdded + LocalString.get(" [style=dotted]\n"));
            stringBuffer.append("S" + splitter.orderAdded + LocalString.get(" [label=\"") + splitter.orderAdded + ": " + splitter.attributeString(this.m_trainInstances) + "\"]\n");
            for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                PredictionNode predictionNode2 = splitter.getChildForBranch(i);
                if (predictionNode2 == null) continue;
                stringBuffer.append("S" + splitter.orderAdded + "->" + "S" + splitter.orderAdded + "P" + i + LocalString.get(" [label=\"") + splitter.comparisonString(i, this.m_trainInstances) + "\"]\n");
                this.graphTraverse(predictionNode2, stringBuffer, splitter.orderAdded, i, splitter.instancesDownBranch(i, instances));
            }
        }
    }

    public String legend() {
        Attribute attribute = null;
        if (this.m_trainInstances == null) {
            return "";
        }
        try {
            attribute = this.m_trainInstances.classAttribute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "-ve = " + attribute.value(0) + ", +ve = " + attribute.value(1);
    }

    public String numOfBoostingIterationsTipText() {
        return LocalString.get("Sets the number of boosting iterations to perform. You will need to manually ") + LocalString.get("tune this parameter to suit the dataset and the desired complexity/accuracy ") + LocalString.get("tradeoff. More boosting iterations will result in larger (potentially more ") + LocalString.get(" accurate) trees, but will make learning slower. Each iteration will add 3 nodes ") + LocalString.get("(1 split + 2 prediction) to the tree unless merging occurs.");
    }

    public int getNumOfBoostingIterations() {
        return this.m_boostingIterations;
    }

    public void setNumOfBoostingIterations(int n) {
        this.m_boostingIterations = n;
    }

    public String searchPathTipText() {
        return LocalString.get("Sets the type of search to perform when building the tree. The default option") + LocalString.get(" (Expand all paths) will do an exhaustive search. The other search methods are") + LocalString.get(" heuristic, so they are not guaranteed to find an optimal solution but they are") + LocalString.get(" much faster. Expand the heaviest path: searches the path with the most heavily") + LocalString.get(" weighted instances. Expand the best z-pure path: searches the path determined") + LocalString.get(" by the best z-pure estimate. Expand a random path: the fastest method, simply") + LocalString.get(" searches down a single random path on each iteration.");
    }

    public SelectedTag getSearchPath() {
        return new SelectedTag(this.m_searchPath, TAGS_SEARCHPATH);
    }

    public void setSearchPath(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SEARCHPATH) {
            this.m_searchPath = selectedTag.getSelectedTag().getID();
        }
    }

    public String randomSeedTipText() {
        return LocalString.get("Sets the random seed to use for a random search.");
    }

    public int getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_randomSeed = n;
    }

    public String saveInstanceDataTipText() {
        return LocalString.get("Sets whether the tree is to save instance data - the model will take up more") + LocalString.get(" memory if it does. If enabled you will be able to visualize the instances at") + LocalString.get(" the prediction nodes when visualizing the tree.");
    }

    public boolean getSaveInstanceData() {
        return this.m_saveInstanceData;
    }

    public void setSaveInstanceData(boolean bl) {
        this.m_saveInstanceData = bl;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tNumber of boosting iterations.\n") + LocalString.get("\t(Default = 10)"), "B", 1, LocalString.get("-B <number of boosting iterations>")));
        vector.addElement(new Option(LocalString.get("\tExpand nodes: -3(all), -2(weight), -1(z_pure), ") + LocalString.get(">=0 seed for random walk\n") + LocalString.get("\t(Default = -3)"), "E", 1, LocalString.get("-E <-3|-2|-1|>=0>")));
        vector.addElement(new Option(LocalString.get("\tSave the instance data with the model"), "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('B', stringArray);
        if (string2.length() != 0) {
            this.setNumOfBoostingIterations(Integer.parseInt(string2));
        }
        if ((string = Utils.getOption('E', stringArray)).length() != 0) {
            int n = Integer.parseInt(string);
            if (n >= 0) {
                this.setSearchPath(new SelectedTag(3, TAGS_SEARCHPATH));
                this.setRandomSeed(n);
            } else {
                this.setSearchPath(new SelectedTag(n + 3, TAGS_SEARCHPATH));
            }
        }
        this.setSaveInstanceData(Utils.getFlag('D', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getNumOfBoostingIterations();
        stringArray[n++] = "-E";
        stringArray[n++] = "" + (this.m_searchPath == 3 ? this.m_randomSeed : this.m_searchPath - 3);
        if (this.getSaveInstanceData()) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public double measureTreeSize() {
        return this.numOfAllNodes(this.m_root);
    }

    public double measureNumLeaves() {
        return this.numOfPredictionNodes(this.m_root);
    }

    public double measureNumPredictionLeaves() {
        return this.numOfPredictionLeafNodes(this.m_root);
    }

    public double measureNodesExpanded() {
        return this.m_nodesExpanded;
    }

    public double measureExamplesProcessed() {
        return this.m_examplesCounted;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(4);
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        vector.addElement("measureNumPredictionLeaves");
        vector.addElement("measureNodesExpanded");
        vector.addElement("measureExamplesProcessed");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.equalsIgnoreCase("measureTreeSize")) {
            return this.measureTreeSize();
        }
        if (string.equalsIgnoreCase("measureNumLeaves")) {
            return this.measureNumLeaves();
        }
        if (string.equalsIgnoreCase("measureNumPredictionLeaves")) {
            return this.measureNumPredictionLeaves();
        }
        if (string.equalsIgnoreCase("measureNodesExpanded")) {
            return this.measureNodesExpanded();
        }
        if (string.equalsIgnoreCase("measureExamplesProcessed")) {
            return this.measureExamplesProcessed();
        }
        throw new IllegalArgumentException(string + LocalString.get(" not supported (ADTree)"));
    }

    protected int numOfAllNodes(PredictionNode predictionNode) {
        int n = 0;
        if (predictionNode != null) {
            ++n;
            Enumeration enumeration = predictionNode.children();
            while (enumeration.hasMoreElements()) {
                ++n;
                Splitter splitter = (Splitter)enumeration.nextElement();
                for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                    n += this.numOfAllNodes(splitter.getChildForBranch(i));
                }
            }
        }
        return n;
    }

    protected int numOfPredictionNodes(PredictionNode predictionNode) {
        int n = 0;
        if (predictionNode != null) {
            ++n;
            Enumeration enumeration = predictionNode.children();
            while (enumeration.hasMoreElements()) {
                Splitter splitter = (Splitter)enumeration.nextElement();
                for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                    n += this.numOfPredictionNodes(splitter.getChildForBranch(i));
                }
            }
        }
        return n;
    }

    protected int numOfPredictionLeafNodes(PredictionNode predictionNode) {
        int n = 0;
        if (predictionNode.getChildren().size() > 0) {
            Enumeration enumeration = predictionNode.children();
            while (enumeration.hasMoreElements()) {
                Splitter splitter = (Splitter)enumeration.nextElement();
                for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                    n += this.numOfPredictionLeafNodes(splitter.getChildForBranch(i));
                }
            }
        } else {
            n = 1;
        }
        return n;
    }

    protected int getRandom(int n) {
        return this.m_random.nextInt(n);
    }

    public int nextSplitAddedOrder() {
        return ++this.m_lastAddedSplitNum;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.initClassifier(instances);
        for (int i = 0; i < this.m_boostingIterations; ++i) {
            this.boost();
        }
        if (!this.m_saveInstanceData) {
            this.done();
        }
    }

    public void done() {
        this.m_trainInstances = new Instances(this.m_trainInstances, 0);
        this.m_random = null;
        this.m_numericAttIndices = null;
        this.m_nominalAttIndices = null;
        this.m_posTrainInstances = null;
        this.m_negTrainInstances = null;
    }

    public Object clone() {
        ADTree aDTree = new ADTree();
        if (this.m_root != null) {
            Object object;
            aDTree.m_root = (PredictionNode)this.m_root.clone();
            aDTree.m_trainInstances = new Instances(this.m_trainInstances);
            if (this.m_random != null) {
                object = null;
                try {
                    object = new SerializedObject(this.m_random);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                aDTree.m_random = (Random)((SerializedObject)object).getObject();
            }
            aDTree.m_lastAddedSplitNum = this.m_lastAddedSplitNum;
            aDTree.m_numericAttIndices = this.m_numericAttIndices;
            aDTree.m_nominalAttIndices = this.m_nominalAttIndices;
            aDTree.m_trainTotalWeight = this.m_trainTotalWeight;
            if (this.m_posTrainInstances != null) {
                aDTree.m_posTrainInstances = new ReferenceInstances(this.m_trainInstances, this.m_posTrainInstances.numInstances());
                aDTree.m_negTrainInstances = new ReferenceInstances(this.m_trainInstances, this.m_negTrainInstances.numInstances());
                object = aDTree.m_trainInstances.enumerateInstances();
                while (object.hasMoreElements()) {
                    Instance instance = (Instance)object.nextElement();
                    try {
                        if ((int)instance.classValue() == 0) {
                            aDTree.m_negTrainInstances.addReference(instance);
                            continue;
                        }
                        aDTree.m_posTrainInstances.addReference(instance);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        aDTree.m_nodesExpanded = this.m_nodesExpanded;
        aDTree.m_examplesCounted = this.m_examplesCounted;
        aDTree.m_boostingIterations = this.m_boostingIterations;
        aDTree.m_searchPath = this.m_searchPath;
        aDTree.m_randomSeed = this.m_randomSeed;
        return aDTree;
    }

    public void merge(ADTree aDTree) throws Exception {
        if (this.m_root == null || aDTree.m_root == null) {
            throw new Exception(LocalString.get("Trying to merge an uninitialized tree"));
        }
        this.m_root.merge(aDTree.m_root, this);
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new ADTree(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

