/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.trees.m5.PreConstructedLinearModel;
import weka.classifiers.trees.m5.Rule;
import weka.classifiers.trees.m5.SplitEvaluate;
import weka.classifiers.trees.m5.YongSplitInfo;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class RuleNode
extends Classifier {
    private Instances m_instances;
    private int m_classIndex;
    protected int m_numInstances;
    private int m_numAttributes;
    private boolean m_isLeaf;
    private int m_splitAtt;
    private double m_splitValue;
    private PreConstructedLinearModel m_nodeModel = null;
    public int m_numParameters;
    private double m_rootMeanSquaredError;
    protected RuleNode m_left = null;
    protected RuleNode m_right = null;
    private RuleNode m_parent;
    private double m_splitNum = 4.0;
    private double m_devFraction = 0.05;
    private double m_pruningMultiplier = 2.0;
    private int m_leafModelNum;
    private double m_globalDeviation;
    private double m_globalAbsDeviation;
    private int[] m_indices;
    private static final double SMOOTHING_CONSTANT = 15.0;
    private int m_id;
    private boolean m_saveInstances = false;
    private boolean m_regressionTree;

    public RuleNode(double d, double d2, RuleNode ruleNode) {
        this.m_parent = ruleNode;
        this.m_globalDeviation = d;
        this.m_globalAbsDeviation = d2;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.m_rootMeanSquaredError = Double.MAX_VALUE;
        this.m_instances = instances;
        this.m_classIndex = this.m_instances.classIndex();
        this.m_numInstances = this.m_instances.numInstances();
        this.m_numAttributes = this.m_instances.numAttributes();
        this.m_nodeModel = null;
        this.m_right = null;
        this.m_left = null;
        this.m_isLeaf = (double)this.m_numInstances < this.m_splitNum || Rule.stdDev(this.m_classIndex, this.m_instances) < this.m_globalDeviation * this.m_devFraction;
        this.split();
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = 0.0;
        if (this.m_isLeaf) {
            if (this.m_nodeModel == null) {
                throw new Exception(LocalString.get("Classifier has not been built correctly."));
            }
            return this.m_nodeModel.classifyInstance(instance);
        }
        if (instance.value(this.m_splitAtt) <= this.m_splitValue) {
            return this.m_left.classifyInstance(instance);
        }
        return this.m_right.classifyInstance(instance);
    }

    protected static double smoothingOriginal(double d, double d2, double d3) throws Exception {
        double d4 = (d * d2 + 15.0 * d3) / (d + 15.0);
        return d4;
    }

    public void split() throws Exception {
        if (!this.m_isLeaf) {
            int n;
            SplitEvaluate splitEvaluate = new YongSplitInfo(0, this.m_numInstances - 1, -1);
            YongSplitInfo yongSplitInfo = new YongSplitInfo(0, this.m_numInstances - 1, -1);
            for (n = 0; n < this.m_numAttributes; ++n) {
                if (n == this.m_classIndex) continue;
                this.m_instances.sort(n);
                yongSplitInfo.attrSplit(n, this.m_instances);
                if (!(Math.abs(yongSplitInfo.maxImpurity() - splitEvaluate.maxImpurity()) > 1.0E-6) || !(yongSplitInfo.maxImpurity() > splitEvaluate.maxImpurity() + 1.0E-6)) continue;
                splitEvaluate = yongSplitInfo.copy();
            }
            if (splitEvaluate.splitAttr() < 0 || splitEvaluate.position() < 1 || splitEvaluate.position() > this.m_numInstances - 1) {
                this.m_isLeaf = true;
            } else {
                this.m_splitAtt = splitEvaluate.splitAttr();
                this.m_splitValue = splitEvaluate.splitValue();
                Instances instances = new Instances(this.m_instances, this.m_numInstances);
                Instances instances2 = new Instances(this.m_instances, this.m_numInstances);
                for (n = 0; n < this.m_numInstances; ++n) {
                    if (this.m_instances.instance(n).value(this.m_splitAtt) <= this.m_splitValue) {
                        instances.add(this.m_instances.instance(n));
                        continue;
                    }
                    instances2.add(this.m_instances.instance(n));
                }
                instances.compactify();
                instances2.compactify();
                this.m_left = new RuleNode(this.m_globalDeviation, this.m_globalAbsDeviation, this);
                this.m_left.setMinNumInstances(this.m_splitNum);
                this.m_left.setRegressionTree(this.m_regressionTree);
                this.m_left.setSaveInstances(this.m_saveInstances);
                this.m_left.buildClassifier(instances);
                this.m_right = new RuleNode(this.m_globalDeviation, this.m_globalAbsDeviation, this);
                this.m_right.setMinNumInstances(this.m_splitNum);
                this.m_right.setRegressionTree(this.m_regressionTree);
                this.m_right.setSaveInstances(this.m_saveInstances);
                this.m_right.buildClassifier(instances2);
                if (!this.m_regressionTree) {
                    int n2;
                    boolean[] blArray = this.attsTestedBelow();
                    blArray[this.m_classIndex] = true;
                    int n3 = 0;
                    for (n2 = 0; n2 < this.m_numAttributes; ++n2) {
                        if (!blArray[n2]) continue;
                        ++n3;
                    }
                    int[] nArray = new int[n3];
                    n3 = 0;
                    for (n2 = 0; n2 < this.m_numAttributes; ++n2) {
                        if (!blArray[n2] || n2 == this.m_classIndex) continue;
                        nArray[n3++] = n2;
                    }
                    nArray[n3] = this.m_classIndex;
                    this.m_indices = nArray;
                } else {
                    this.m_indices = new int[1];
                    this.m_indices[0] = this.m_classIndex;
                    this.m_numParameters = 1;
                }
            }
        }
        if (this.m_isLeaf) {
            int[] nArray = new int[]{this.m_classIndex};
            this.m_indices = nArray;
            this.m_numParameters = 1;
        }
    }

    private void buildLinearModel(int[] nArray) throws Exception {
        Instances instances = new Instances(this.m_instances);
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances);
        instances = Filter.useFilter(instances, remove);
        LinearRegression linearRegression = new LinearRegression();
        linearRegression.buildClassifier(instances);
        double[] dArray = linearRegression.coefficients();
        double[] dArray2 = new double[this.m_instances.numAttributes()];
        for (int i = 0; i < dArray.length - 1; ++i) {
            if (nArray[i] == this.m_classIndex) continue;
            dArray2[nArray[i]] = dArray[i];
        }
        this.m_nodeModel = new PreConstructedLinearModel(dArray2, dArray[dArray.length - 1]);
        this.m_nodeModel.buildClassifier(this.m_instances);
    }

    private boolean[] attsTestedAbove() {
        boolean[] blArray = new boolean[this.m_numAttributes];
        boolean[] blArray2 = null;
        if (this.m_parent != null) {
            blArray2 = this.m_parent.attsTestedAbove();
        }
        if (blArray2 != null) {
            for (int i = 0; i < this.m_numAttributes; ++i) {
                blArray[i] = blArray2[i];
            }
        }
        blArray[this.m_splitAtt] = true;
        return blArray;
    }

    private boolean[] attsTestedBelow() {
        boolean[] blArray = new boolean[this.m_numAttributes];
        boolean[] blArray2 = null;
        boolean[] blArray3 = null;
        if (this.m_right != null) {
            blArray3 = this.m_right.attsTestedBelow();
        }
        if (this.m_left != null) {
            blArray2 = this.m_left.attsTestedBelow();
        }
        for (int i = 0; i < this.m_numAttributes; ++i) {
            if (blArray2 != null) {
                boolean bl = blArray[i] = blArray[i] || blArray2[i];
            }
            if (blArray3 == null) continue;
            blArray[i] = blArray[i] || blArray3[i];
        }
        if (!this.m_isLeaf) {
            blArray[this.m_splitAtt] = true;
        }
        return blArray;
    }

    public int numLeaves(int n) {
        if (!this.m_isLeaf) {
            this.m_leafModelNum = 0;
            if (this.m_left != null) {
                n = this.m_left.numLeaves(n);
            }
            if (this.m_right != null) {
                n = this.m_right.numLeaves(n);
            }
        } else {
            this.m_leafModelNum = ++n;
        }
        return n;
    }

    public String toString() {
        return this.printNodeLinearModel();
    }

    public String printNodeLinearModel() {
        return this.m_nodeModel.toString();
    }

    public String printLeafModels() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_isLeaf) {
            stringBuffer.append(LocalString.get("\nLM num: ") + this.m_leafModelNum);
            stringBuffer.append(this.m_nodeModel.toString());
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(this.m_left.printLeafModels());
            stringBuffer.append(this.m_right.printLeafModels());
        }
        return stringBuffer.toString();
    }

    public String nodeToString() {
        StringBuffer stringBuffer = new StringBuffer();
        System.out.println(LocalString.get("In to string"));
        stringBuffer.append(LocalString.get("Node:\n\tnum inst: ") + this.m_numInstances);
        if (this.m_isLeaf) {
            stringBuffer.append("\n\tleaf");
        } else {
            stringBuffer.append("\tnode");
        }
        stringBuffer.append(LocalString.get("\n\tSplit att: ") + this.m_instances.attribute(this.m_splitAtt).name());
        stringBuffer.append(LocalString.get("\n\tSplit val: ") + Utils.doubleToString(this.m_splitValue, 1, 3));
        stringBuffer.append(LocalString.get("\n\tLM num: ") + this.m_leafModelNum);
        stringBuffer.append(LocalString.get("\n\tLinear model\n") + this.m_nodeModel.toString());
        stringBuffer.append("\n\n");
        if (this.m_left != null) {
            stringBuffer.append(this.m_left.nodeToString());
        }
        if (this.m_right != null) {
            stringBuffer.append(this.m_right.nodeToString());
        }
        return stringBuffer.toString();
    }

    public String treeToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.m_isLeaf) {
            int n2;
            stringBuffer.append("\n");
            for (n2 = 1; n2 <= n; ++n2) {
                stringBuffer.append("|   ");
            }
            if (this.m_instances.attribute(this.m_splitAtt).name().charAt(0) != '[') {
                stringBuffer.append(this.m_instances.attribute(this.m_splitAtt).name() + " <= " + Utils.doubleToString(this.m_splitValue, 1, 3) + " : ");
            } else {
                stringBuffer.append(this.m_instances.attribute(this.m_splitAtt).name() + LocalString.get(" false : "));
            }
            if (this.m_left != null) {
                stringBuffer.append(this.m_left.treeToString(n + 1));
            } else {
                stringBuffer.append("NULL\n");
            }
            for (n2 = 1; n2 <= n; ++n2) {
                stringBuffer.append("|   ");
            }
            if (this.m_instances.attribute(this.m_splitAtt).name().charAt(0) != '[') {
                stringBuffer.append(this.m_instances.attribute(this.m_splitAtt).name() + " >  " + Utils.doubleToString(this.m_splitValue, 1, 3) + " : ");
            } else {
                stringBuffer.append(this.m_instances.attribute(this.m_splitAtt).name() + LocalString.get(" true : "));
            }
            if (this.m_right != null) {
                stringBuffer.append(this.m_right.treeToString(n + 1));
            } else {
                stringBuffer.append("NULL\n");
            }
        } else {
            stringBuffer.append("LM" + this.m_leafModelNum);
            if (this.m_globalDeviation > 0.0) {
                stringBuffer.append(" (" + this.m_numInstances + "/" + Utils.doubleToString(100.0 * this.m_rootMeanSquaredError / this.m_globalAbsDeviation, 1, 3) + "%)\n");
            } else {
                stringBuffer.append(" (" + this.m_numInstances + ")\n");
            }
        }
        return stringBuffer.toString();
    }

    public void installLinearModels() throws Exception {
        if (this.m_isLeaf) {
            this.buildLinearModel(this.m_indices);
        } else {
            if (this.m_left != null) {
                this.m_left.installLinearModels();
            }
            if (this.m_right != null) {
                this.m_right.installLinearModels();
            }
            this.buildLinearModel(this.m_indices);
        }
        Evaluation evaluation = new Evaluation(this.m_instances);
        evaluation.evaluateModel(this.m_nodeModel, this.m_instances);
        this.m_rootMeanSquaredError = evaluation.rootMeanSquaredError();
        if (!this.m_saveInstances) {
            this.m_instances = new Instances(this.m_instances, 0);
        }
    }

    public void installSmoothedModels() throws Exception {
        if (this.m_isLeaf) {
            double[] dArray = new double[this.m_numAttributes];
            double[] dArray2 = this.m_nodeModel.coefficients();
            RuleNode ruleNode = this;
            for (int i = 0; i < dArray2.length; ++i) {
                if (i == this.m_classIndex) continue;
                dArray[i] = dArray2[i];
            }
            double d = this.m_nodeModel.intercept();
            do {
                int n;
                if (ruleNode.m_parent == null) continue;
                PreConstructedLinearModel preConstructedLinearModel = ruleNode.m_parent.getModel();
                double d2 = ruleNode.m_numInstances;
                for (n = 0; n < dArray.length; ++n) {
                    dArray[n] = dArray[n] * d2 / (d2 + 15.0);
                }
                d = d * d2 / (d2 + 15.0);
                dArray2 = ruleNode.m_parent.getModel().coefficients();
                for (n = 0; n < dArray2.length; ++n) {
                    if (n == this.m_classIndex) continue;
                    int n2 = n;
                    dArray[n2] = dArray[n2] + 15.0 * dArray2[n] / (d2 + 15.0);
                }
                d += 15.0 * ruleNode.m_parent.getModel().intercept() / (d2 + 15.0);
                ruleNode = ruleNode.m_parent;
            } while (ruleNode.m_parent != null);
            this.m_nodeModel = new PreConstructedLinearModel(dArray, d);
            this.m_nodeModel.buildClassifier(this.m_instances);
        }
        if (this.m_left != null) {
            this.m_left.installSmoothedModels();
        }
        if (this.m_right != null) {
            this.m_right.installSmoothedModels();
        }
    }

    public void prune() throws Exception {
        Evaluation evaluation = null;
        if (this.m_isLeaf) {
            this.buildLinearModel(this.m_indices);
            evaluation = new Evaluation(this.m_instances);
            evaluation.evaluateModel(this.m_nodeModel, this.m_instances);
            this.m_rootMeanSquaredError = evaluation.rootMeanSquaredError();
        } else {
            double d;
            if (this.m_left != null) {
                this.m_left.prune();
            }
            if (this.m_right != null) {
                this.m_right.prune();
            }
            this.buildLinearModel(this.m_indices);
            evaluation = new Evaluation(this.m_instances);
            evaluation.evaluateModel(this.m_nodeModel, this.m_instances);
            double d2 = evaluation.rootMeanSquaredError();
            double d3 = d2 * this.pruningFactor(this.m_numInstances, this.m_nodeModel.numParameters() + 1);
            Evaluation evaluation2 = new Evaluation(this.m_instances);
            int n = 0;
            int n2 = 0;
            evaluation2.evaluateModel(this, this.m_instances);
            double d4 = evaluation2.rootMeanSquaredError();
            if (this.m_left != null) {
                n = this.m_left.numParameters();
            }
            if (this.m_right != null) {
                n2 = this.m_right.numParameters();
            }
            if (d3 <= (d = d4 * this.pruningFactor(this.m_numInstances, n + n2 + 1)) || d3 < this.m_globalDeviation * 1.0E-5) {
                this.m_isLeaf = true;
                this.m_right = null;
                this.m_left = null;
                this.m_numParameters = this.m_nodeModel.numParameters() + 1;
                this.m_rootMeanSquaredError = d2;
            } else {
                this.m_numParameters = n + n2 + 1;
                this.m_rootMeanSquaredError = d4;
            }
        }
        if (!this.m_saveInstances) {
            this.m_instances = new Instances(this.m_instances, 0);
        }
    }

    private double pruningFactor(int n, int n2) {
        if (n <= n2) {
            return 10.0;
        }
        return ((double)n + this.m_pruningMultiplier * (double)n2) / (double)(n - n2);
    }

    public void findBestLeaf(double[] dArray, RuleNode[] ruleNodeArray) {
        if (!this.m_isLeaf) {
            if (this.m_left != null) {
                this.m_left.findBestLeaf(dArray, ruleNodeArray);
            }
            if (this.m_right != null) {
                this.m_right.findBestLeaf(dArray, ruleNodeArray);
            }
        } else if ((double)this.m_numInstances > dArray[0]) {
            dArray[0] = this.m_numInstances;
            ruleNodeArray[0] = this;
        }
    }

    public void returnLeaves(FastVector[] fastVectorArray) {
        if (this.m_isLeaf) {
            fastVectorArray[0].addElement(this);
        } else {
            if (this.m_left != null) {
                this.m_left.returnLeaves(fastVectorArray);
            }
            if (this.m_right != null) {
                this.m_right.returnLeaves(fastVectorArray);
            }
        }
    }

    public RuleNode parentNode() {
        return this.m_parent;
    }

    public RuleNode leftNode() {
        return this.m_left;
    }

    public RuleNode rightNode() {
        return this.m_right;
    }

    public int splitAtt() {
        return this.m_splitAtt;
    }

    public double splitVal() {
        return this.m_splitValue;
    }

    public int numberOfLinearModels() {
        if (this.m_isLeaf) {
            return 1;
        }
        return this.m_left.numberOfLinearModels() + this.m_right.numberOfLinearModels();
    }

    public boolean isLeaf() {
        return this.m_isLeaf;
    }

    protected double rootMeanSquaredError() {
        return this.m_rootMeanSquaredError;
    }

    public PreConstructedLinearModel getModel() {
        return this.m_nodeModel;
    }

    public int getNumInstances() {
        return this.m_numInstances;
    }

    private int numParameters() {
        return this.m_numParameters;
    }

    public boolean getRegressionTree() {
        return this.m_regressionTree;
    }

    public void setMinNumInstances(double d) {
        this.m_splitNum = d;
    }

    public double getMinNumInstances() {
        return this.m_splitNum;
    }

    public void setRegressionTree(boolean bl) {
        this.m_regressionTree = bl;
    }

    public void printAllModels() {
        if (this.m_isLeaf) {
            System.out.println(this.m_nodeModel.toString());
        } else {
            System.out.println(this.m_nodeModel.toString());
            this.m_left.printAllModels();
            this.m_right.printAllModels();
        }
    }

    protected int assignIDs(int n) {
        int n2;
        this.m_id = n2 = n + 1;
        if (this.m_left != null) {
            n2 = this.m_left.assignIDs(n2);
        }
        if (this.m_right != null) {
            n2 = this.m_right.assignIDs(n2);
        }
        return n2;
    }

    public void graph(StringBuffer stringBuffer) {
        this.assignIDs(-1);
        this.graphTree(stringBuffer);
    }

    protected void graphTree(StringBuffer stringBuffer) {
        stringBuffer.append("N" + this.m_id + (this.m_isLeaf ? LocalString.get(" [label=\"LM ") + this.m_leafModelNum : LocalString.get(" [label=\"") + this.m_instances.attribute(this.m_splitAtt).name()) + (this.m_isLeaf ? " (" + (this.m_globalDeviation > 0.0 ? this.m_numInstances + "/" + Utils.doubleToString(100.0 * this.m_rootMeanSquaredError / this.m_globalAbsDeviation, 1, 3) + "%)" : this.m_numInstances + ")") + LocalString.get("\" shape=box style=filled ") : "\"") + (this.m_saveInstances ? "data=\n" + this.m_instances + "\n,\n" : "") + "]\n");
        if (this.m_left != null) {
            stringBuffer.append("N" + this.m_id + "->" + "N" + this.m_left.m_id + LocalString.get(" [label=\"<=") + Utils.doubleToString(this.m_splitValue, 1, 3) + "\"]\n");
            this.m_left.graphTree(stringBuffer);
        }
        if (this.m_right != null) {
            stringBuffer.append("N" + this.m_id + "->" + "N" + this.m_right.m_id + LocalString.get(" [label=\">") + Utils.doubleToString(this.m_splitValue, 1, 3) + "\"]\n");
            this.m_right.graphTree(stringBuffer);
        }
    }

    protected void setSaveInstances(boolean bl) {
        this.m_saveInstances = bl;
    }
}

