/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import weka.LocalString;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.ProtectedProperties;
import weka.core.SerializedObject;
import weka.core.Utils;

public class Attribute
implements Copyable,
Serializable {
    public static final int NUMERIC = 0;
    public static final int NOMINAL = 1;
    public static final int STRING = 2;
    public static final int DATE = 3;
    public static final int ORDERING_SYMBOLIC = 0;
    public static final int ORDERING_ORDERED = 1;
    public static final int ORDERING_MODULO = 2;
    static String ARFF_ATTRIBUTE = "@attribute";
    static String ARFF_ATTRIBUTE_INTEGER = "integer";
    static String ARFF_ATTRIBUTE_REAL = "real";
    static String ARFF_ATTRIBUTE_NUMERIC = "numeric";
    static String ARFF_ATTRIBUTE_STRING = "string";
    static String ARFF_ATTRIBUTE_DATE = "date";
    private static final int STRING_COMPRESS_THRESHOLD = 200;
    private String m_Name;
    private int m_Type;
    private FastVector m_Values;
    private Hashtable m_Hashtable;
    private SimpleDateFormat m_DateFormat;
    private int m_Index;
    private ProtectedProperties m_Metadata;
    private int m_Ordering;
    private boolean m_IsRegular;
    private boolean m_IsAveragable;
    private boolean m_HasZeropoint;
    private double m_Weight;
    private double m_LowerBound;
    private boolean m_LowerBoundIsOpen;
    private double m_UpperBound;
    private boolean m_UpperBoundIsOpen;

    public Attribute(String string) {
        this(string, new ProtectedProperties(new Properties()));
    }

    public Attribute(String string, ProtectedProperties protectedProperties) {
        this.m_Name = string;
        this.m_Index = -1;
        this.m_Values = null;
        this.m_Hashtable = null;
        this.m_Type = 0;
        this.setMetadata(protectedProperties);
    }

    public Attribute(String string, String string2) {
        this(string, string2, new ProtectedProperties(new Properties()));
    }

    public Attribute(String string, String string2, ProtectedProperties protectedProperties) {
        this.m_Name = string;
        this.m_Index = -1;
        this.m_Values = null;
        this.m_Hashtable = null;
        this.m_Type = 3;
        this.m_DateFormat = string2 != null ? new SimpleDateFormat(string2) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.m_DateFormat.setLenient(false);
        this.setMetadata(protectedProperties);
    }

    public Attribute(String string, FastVector fastVector) {
        this(string, fastVector, new ProtectedProperties(new Properties()));
    }

    public Attribute(String string, FastVector fastVector, ProtectedProperties protectedProperties) {
        this.m_Name = string;
        this.m_Index = -1;
        if (fastVector == null) {
            this.m_Values = new FastVector();
            this.m_Hashtable = new Hashtable();
            this.m_Type = 2;
        } else {
            this.m_Values = new FastVector(fastVector.size());
            this.m_Hashtable = new Hashtable(fastVector.size());
            for (int i = 0; i < fastVector.size(); ++i) {
                Object object = fastVector.elementAt(i);
                if (((String)object).length() > 200) {
                    try {
                        object = new SerializedObject(fastVector.elementAt(i), true);
                    }
                    catch (Exception exception) {
                        System.err.println(LocalString.get("Couldn't compress nominal attribute value -") + LocalString.get(" storing uncompressed."));
                    }
                }
                if (this.m_Hashtable.containsKey(object)) {
                    throw new IllegalArgumentException(LocalString.get("A nominal attribute (") + string + LocalString.get(") cannot") + LocalString.get(" have duplicate labels (") + object + ").");
                }
                this.m_Values.addElement(object);
                this.m_Hashtable.put(object, new Integer(i));
            }
            this.m_Type = 1;
        }
        this.setMetadata(protectedProperties);
    }

    public Object copy() {
        Attribute attribute = new Attribute(this.m_Name);
        attribute.m_Index = this.m_Index;
        attribute.m_Type = this.m_Type;
        attribute.m_Values = this.m_Values;
        attribute.m_Hashtable = this.m_Hashtable;
        attribute.m_DateFormat = this.m_DateFormat;
        attribute.setMetadata(this.m_Metadata);
        return attribute;
    }

    public final Enumeration enumerateValues() {
        if (this.isNominal() || this.isString()) {
            final Enumeration enumeration = this.m_Values.elements();
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return enumeration.hasMoreElements();
                }

                public Object nextElement() {
                    Object e = enumeration.nextElement();
                    if (e instanceof SerializedObject) {
                        return ((SerializedObject)e).getObject();
                    }
                    return e;
                }
            };
        }
        return null;
    }

    public final boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        if (!this.m_Name.equals(attribute.m_Name)) {
            return false;
        }
        if (this.isNominal() && attribute.isNominal()) {
            if (this.m_Values.size() != attribute.m_Values.size()) {
                return false;
            }
            for (int i = 0; i < this.m_Values.size(); ++i) {
                if (this.m_Values.elementAt(i).equals(attribute.m_Values.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        return this.type() == attribute.type();
    }

    public final int index() {
        return this.m_Index;
    }

    public final int indexOfValue(String string) {
        Integer n;
        if (!this.isNominal() && !this.isString()) {
            return -1;
        }
        Object object = string;
        if (string.length() > 200) {
            try {
                object = new SerializedObject(string, true);
            }
            catch (Exception exception) {
                System.err.println(LocalString.get("Couldn't compress string attribute value -") + LocalString.get(" searching uncompressed."));
            }
        }
        if ((n = (Integer)this.m_Hashtable.get(object)) == null) {
            return -1;
        }
        return n;
    }

    public final boolean isNominal() {
        return this.m_Type == 1;
    }

    public final boolean isNumeric() {
        return this.m_Type == 0 || this.m_Type == 3;
    }

    public final boolean isString() {
        return this.m_Type == 2;
    }

    public final boolean isDate() {
        return this.m_Type == 3;
    }

    public final String name() {
        return this.m_Name;
    }

    public final int numValues() {
        if (!this.isNominal() && !this.isString()) {
            return 0;
        }
        return this.m_Values.size();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ARFF_ATTRIBUTE).append(" ").append(Utils.quote(this.m_Name)).append(" ");
        switch (this.m_Type) {
            case 1: {
                stringBuffer.append('{');
                Enumeration enumeration = this.enumerateValues();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(Utils.quote((String)enumeration.nextElement()));
                    if (!enumeration.hasMoreElements()) continue;
                    stringBuffer.append(',');
                }
                stringBuffer.append('}');
                break;
            }
            case 0: {
                stringBuffer.append(ARFF_ATTRIBUTE_NUMERIC);
                break;
            }
            case 2: {
                stringBuffer.append(ARFF_ATTRIBUTE_STRING);
                break;
            }
            case 3: {
                stringBuffer.append(ARFF_ATTRIBUTE_DATE).append(" ").append(Utils.quote(this.m_DateFormat.toPattern()));
                break;
            }
            default: {
                stringBuffer.append("UNKNOWN");
            }
        }
        return stringBuffer.toString();
    }

    public final int type() {
        return this.m_Type;
    }

    public final String value(int n) {
        if (!this.isNominal() && !this.isString()) {
            return "";
        }
        Object object = this.m_Values.elementAt(n);
        if (object instanceof SerializedObject) {
            object = ((SerializedObject)object).getObject();
        }
        return (String)object;
    }

    Attribute(String string, int n) {
        this(string);
        this.m_Index = n;
    }

    Attribute(String string, String string2, int n) {
        this(string, string2);
        this.m_Index = n;
    }

    Attribute(String string, FastVector fastVector, int n) {
        this(string, fastVector);
        this.m_Index = n;
    }

    public int addStringValue(String string) {
        Integer n;
        if (!this.isString()) {
            return -1;
        }
        Object object = string;
        if (string.length() > 200) {
            try {
                object = new SerializedObject(string, true);
            }
            catch (Exception exception) {
                System.err.println(LocalString.get("Couldn't compress string attribute value -") + LocalString.get(" storing uncompressed."));
            }
        }
        if ((n = (Integer)this.m_Hashtable.get(object)) != null) {
            return n;
        }
        int n2 = this.m_Values.size();
        this.m_Values.addElement(object);
        this.m_Hashtable.put(object, new Integer(n2));
        return n2;
    }

    public int addStringValue(Attribute attribute, int n) {
        if (!this.isString()) {
            return -1;
        }
        Object object = attribute.m_Values.elementAt(n);
        Integer n2 = (Integer)this.m_Hashtable.get(object);
        if (n2 != null) {
            return n2;
        }
        int n3 = this.m_Values.size();
        this.m_Values.addElement(object);
        this.m_Hashtable.put(object, new Integer(n3));
        return n3;
    }

    final void addValue(String string) {
        this.m_Values = (FastVector)this.m_Values.copy();
        this.m_Hashtable = (Hashtable)this.m_Hashtable.clone();
        this.forceAddValue(string);
    }

    final Attribute copy(String string) {
        Attribute attribute = new Attribute(string);
        attribute.m_Index = this.m_Index;
        attribute.m_DateFormat = this.m_DateFormat;
        attribute.m_Type = this.m_Type;
        attribute.m_Values = this.m_Values;
        attribute.m_Hashtable = this.m_Hashtable;
        attribute.setMetadata(this.m_Metadata);
        return attribute;
    }

    final void delete(int n) {
        if (!this.isNominal() && !this.isString()) {
            throw new IllegalArgumentException(LocalString.get("Can only remove value of") + LocalString.get("nominal or string attribute!"));
        }
        this.m_Values = (FastVector)this.m_Values.copy();
        this.m_Values.removeElementAt(n);
        Hashtable hashtable = new Hashtable(this.m_Hashtable.size());
        Enumeration enumeration = this.m_Hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Integer n2 = (Integer)this.m_Hashtable.get(k);
            int n3 = n2;
            if (n3 > n) {
                hashtable.put(k, new Integer(n3 - 1));
                continue;
            }
            if (n3 >= n) continue;
            hashtable.put(k, n2);
        }
        this.m_Hashtable = hashtable;
    }

    final void forceAddValue(String string) {
        Object object = string;
        if (string.length() > 200) {
            try {
                object = new SerializedObject(string, true);
            }
            catch (Exception exception) {
                System.err.println(LocalString.get("Couldn't compress string attribute value -") + LocalString.get(" storing uncompressed."));
            }
        }
        this.m_Values.addElement(object);
        this.m_Hashtable.put(object, new Integer(this.m_Values.size() - 1));
    }

    final void setIndex(int n) {
        this.m_Index = n;
    }

    final void setValue(int n, String string) {
        switch (this.m_Type) {
            case 1: 
            case 2: {
                this.m_Values = (FastVector)this.m_Values.copy();
                this.m_Hashtable = (Hashtable)this.m_Hashtable.clone();
                Object object = string;
                if (string.length() > 200) {
                    try {
                        object = new SerializedObject(string, true);
                    }
                    catch (Exception exception) {
                        System.err.println(LocalString.get("Couldn't compress string attribute value -") + LocalString.get(" storing uncompressed."));
                    }
                }
                this.m_Hashtable.remove(this.m_Values.elementAt(n));
                this.m_Values.setElementAt(object, n);
                this.m_Hashtable.put(object, new Integer(n));
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalString.get("Can only set values for nominal") + LocalString.get(" or string attributes!"));
            }
        }
    }

    public String formatDate(double d) {
        switch (this.m_Type) {
            case 3: {
                return this.m_DateFormat.format(new Date((long)d));
            }
        }
        throw new IllegalArgumentException(LocalString.get("Can only format date values for date") + LocalString.get(" attributes!"));
    }

    public double parseDate(String string) throws ParseException {
        switch (this.m_Type) {
            case 3: {
                long l = this.m_DateFormat.parse(string).getTime();
                return l;
            }
        }
        throw new IllegalArgumentException(LocalString.get("Can only parse date values for date") + LocalString.get(" attributes!"));
    }

    public final ProtectedProperties getMetadata() {
        return this.m_Metadata;
    }

    public final int ordering() {
        return this.m_Ordering;
    }

    public final boolean isRegular() {
        return this.m_IsRegular;
    }

    public final boolean isAveragable() {
        return this.m_IsAveragable;
    }

    public final boolean hasZeropoint() {
        return this.m_HasZeropoint;
    }

    public final double weight() {
        return this.m_Weight;
    }

    public final double getLowerNumericBound() {
        return this.m_LowerBound;
    }

    public final boolean lowerNumericBoundIsOpen() {
        return this.m_LowerBoundIsOpen;
    }

    public final double getUpperNumericBound() {
        return this.m_UpperBound;
    }

    public final boolean upperNumericBoundIsOpen() {
        return this.m_UpperBoundIsOpen;
    }

    public final boolean isInRange(double d) {
        if (this.m_Type == 3 || d == Instance.missingValue()) {
            return true;
        }
        if (this.m_Type != 0) {
            int n = (int)d;
            if (n < 0 || n >= this.m_Hashtable.size()) {
                return false;
            }
        } else {
            if (this.m_LowerBoundIsOpen ? d <= this.m_LowerBound : d < this.m_LowerBound) {
                return false;
            }
            if (this.m_UpperBoundIsOpen ? d >= this.m_UpperBound : d > this.m_UpperBound) {
                return false;
            }
        }
        return true;
    }

    private void setMetadata(ProtectedProperties protectedProperties) {
        String string;
        this.m_Metadata = protectedProperties;
        if (this.m_Type == 3) {
            this.m_Ordering = 1;
            this.m_IsRegular = true;
            this.m_IsAveragable = false;
            this.m_HasZeropoint = false;
        } else {
            string = this.m_Metadata.getProperty("ordering", "");
            String string2 = this.m_Type == 0 && string.compareTo("modulo") != 0 && string.compareTo("symbolic") != 0 ? "true" : "false";
            this.m_IsAveragable = this.m_Metadata.getProperty("averageable", string2).compareTo("true") == 0;
            boolean bl = this.m_HasZeropoint = this.m_Metadata.getProperty("zeropoint", string2).compareTo("true") == 0;
            if (this.m_IsAveragable || this.m_HasZeropoint) {
                string2 = "true";
            }
            boolean bl2 = this.m_IsRegular = this.m_Metadata.getProperty("regular", string2).compareTo("true") == 0;
            this.m_Ordering = string.compareTo("symbolic") == 0 ? 0 : (string.compareTo("ordered") == 0 ? 1 : (string.compareTo("modulo") == 0 ? 2 : (this.m_Type == 0 || this.m_IsAveragable || this.m_HasZeropoint ? 1 : 0)));
        }
        if (this.m_IsAveragable && !this.m_IsRegular) {
            throw new IllegalArgumentException(LocalString.get("An averagable attribute must be") + LocalString.get(" regular"));
        }
        if (this.m_HasZeropoint && !this.m_IsRegular) {
            throw new IllegalArgumentException(LocalString.get("A zeropoint attribute must be") + LocalString.get(" regular"));
        }
        if (this.m_IsRegular && this.m_Ordering == 0) {
            throw new IllegalArgumentException(LocalString.get("A symbolic attribute cannot be") + LocalString.get(" regular"));
        }
        if (this.m_IsAveragable && this.m_Ordering != 1) {
            throw new IllegalArgumentException(LocalString.get("An averagable attribute must be") + LocalString.get(" ordered"));
        }
        if (this.m_HasZeropoint && this.m_Ordering != 1) {
            throw new IllegalArgumentException(LocalString.get("A zeropoint attribute must be") + LocalString.get(" ordered"));
        }
        this.m_Weight = 1.0;
        string = this.m_Metadata.getProperty("weight");
        if (string != null) {
            try {
                this.m_Weight = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(LocalString.get("Not a valid attribute weight: '") + string + "'");
            }
        }
        if (this.m_Type == 0) {
            this.setNumericRange(this.m_Metadata.getProperty("range"));
        }
    }

    private void setNumericRange(String string) {
        this.m_LowerBound = Double.NEGATIVE_INFINITY;
        this.m_LowerBoundIsOpen = false;
        this.m_UpperBound = Double.POSITIVE_INFINITY;
        this.m_UpperBoundIsOpen = false;
        if (string == null) {
            return;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.ordinaryChar(91);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(44);
        streamTokenizer.ordinaryChar(93);
        streamTokenizer.ordinaryChar(41);
        try {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 91) {
                this.m_LowerBoundIsOpen = false;
            } else if (streamTokenizer.ttype == 40) {
                this.m_LowerBoundIsOpen = true;
            } else {
                throw new IllegalArgumentException(LocalString.get("Expected opening brace on range,") + LocalString.get(" found: ") + streamTokenizer.toString());
            }
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -3) {
                throw new IllegalArgumentException(LocalString.get("Expected lower bound in range,") + LocalString.get(" found: ") + streamTokenizer.toString());
            }
            if (streamTokenizer.sval.compareToIgnoreCase("-inf") == 0) {
                this.m_LowerBound = Double.NEGATIVE_INFINITY;
            } else if (streamTokenizer.sval.compareToIgnoreCase("+inf") == 0) {
                this.m_LowerBound = Double.POSITIVE_INFINITY;
            } else if (streamTokenizer.sval.compareToIgnoreCase("inf") == 0) {
                this.m_LowerBound = Double.NEGATIVE_INFINITY;
            } else {
                try {
                    this.m_LowerBound = Double.valueOf(streamTokenizer.sval);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(LocalString.get("Expected lower bound in range,") + LocalString.get(" found: '") + streamTokenizer.sval + "'");
                }
            }
            if (streamTokenizer.nextToken() != 44) {
                throw new IllegalArgumentException(LocalString.get("Expected comma in range,") + LocalString.get(" found: ") + streamTokenizer.toString());
            }
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -3) {
                throw new IllegalArgumentException(LocalString.get("Expected upper bound in range,") + LocalString.get(" found: ") + streamTokenizer.toString());
            }
            if (streamTokenizer.sval.compareToIgnoreCase("-inf") == 0) {
                this.m_UpperBound = Double.NEGATIVE_INFINITY;
            } else if (streamTokenizer.sval.compareToIgnoreCase("+inf") == 0) {
                this.m_UpperBound = Double.POSITIVE_INFINITY;
            } else if (streamTokenizer.sval.compareToIgnoreCase("inf") == 0) {
                this.m_UpperBound = Double.POSITIVE_INFINITY;
            } else {
                try {
                    this.m_UpperBound = Double.valueOf(streamTokenizer.sval);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(LocalString.get("Expected upper bound in range,") + LocalString.get(" found: '") + streamTokenizer.sval + "'");
                }
            }
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 93) {
                this.m_UpperBoundIsOpen = false;
            } else if (streamTokenizer.ttype == 41) {
                this.m_UpperBoundIsOpen = true;
            } else {
                throw new IllegalArgumentException(LocalString.get("Expected closing brace on range,") + LocalString.get(" found: ") + streamTokenizer.toString());
            }
            if (streamTokenizer.nextToken() != -1) {
                throw new IllegalArgumentException(LocalString.get("Expected end of range string,") + LocalString.get(" found: ") + streamTokenizer.toString());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(LocalString.get("IOException reading attribute range") + LocalString.get(" string: ") + iOException.getMessage());
        }
        if (this.m_UpperBound < this.m_LowerBound) {
            throw new IllegalArgumentException(LocalString.get("Upper bound (") + this.m_UpperBound + LocalString.get(") on numeric range is") + LocalString.get(" less than lower bound (") + this.m_LowerBound + ")!");
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Attribute attribute = new Attribute("length");
            Attribute attribute2 = new Attribute("weight");
            Attribute attribute3 = new Attribute("date", LocalString.get("yyyy-MM-dd HH:mm:ss"));
            System.out.println(attribute3);
            double d = attribute3.parseDate(LocalString.get("2001-04-04 14:13:55"));
            System.out.println(LocalString.get("Test date = ") + d);
            System.out.println(attribute3.formatDate(d));
            d = new Date().getTime();
            System.out.println(LocalString.get("Date now = ") + d);
            System.out.println(attribute3.formatDate(d));
            FastVector fastVector = new FastVector(3);
            fastVector.addElement("first");
            fastVector.addElement("second");
            fastVector.addElement("third");
            Attribute attribute4 = new Attribute("position", fastVector);
            System.out.println(LocalString.get("Name of \"position\": ") + attribute4.name());
            Enumeration enumeration = attribute4.enumerateValues();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                System.out.println(LocalString.get("Value of \"position\": ") + (String)object);
            }
            object = (Attribute)attribute4.copy();
            System.out.println(LocalString.get("Copy is the same as original: ") + ((Attribute)object).equals(attribute4));
            System.out.println(LocalString.get("Index of attribute \"weight\" (should be -1): ") + attribute2.index());
            System.out.println(LocalString.get("Index of value \"first\" of \"position\" (should be 0): ") + attribute4.indexOfValue("first"));
            System.out.println(LocalString.get("\"position\" is numeric: ") + attribute4.isNumeric());
            System.out.println(LocalString.get("\"position\" is nominal: ") + attribute4.isNominal());
            System.out.println(LocalString.get("\"position\" is string: ") + attribute4.isString());
            System.out.println(LocalString.get("Name of \"position\": ") + attribute4.name());
            System.out.println(LocalString.get("Number of values for \"position\": ") + attribute4.numValues());
            for (int i = 0; i < attribute4.numValues(); ++i) {
                System.out.println(LocalString.get("Value ") + i + ": " + attribute4.value(i));
            }
            System.out.println(attribute4);
            switch (attribute4.type()) {
                case 0: {
                    System.out.println(LocalString.get("\"position\" is numeric"));
                    break;
                }
                case 1: {
                    System.out.println(LocalString.get("\"position\" is nominal"));
                    break;
                }
                case 2: {
                    System.out.println(LocalString.get("\"position\" is string"));
                    break;
                }
                case 3: {
                    System.out.println(LocalString.get("\"position\" is date"));
                    break;
                }
                default: {
                    System.out.println(LocalString.get("\"position\" has unknown type"));
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

