/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import weka.LocalString;

public class SingleIndex
implements Serializable {
    protected String m_IndexString = "";
    protected int m_SelectedIndex = -1;
    protected int m_Upper = -1;

    public SingleIndex() {
    }

    public SingleIndex(String string) {
        this.setSingleIndex(string);
    }

    public void setUpper(int n) {
        if (n >= 0) {
            this.m_Upper = n;
            this.setValue();
        }
    }

    public String getSingleIndex() {
        return this.m_IndexString;
    }

    public void setSingleIndex(String string) {
        this.m_IndexString = string;
        this.m_SelectedIndex = -1;
    }

    public String toString() {
        if (this.m_IndexString.equals("")) {
            return LocalString.get("No index set");
        }
        if (this.m_Upper == -1) {
            throw new RuntimeException(LocalString.get("Upper limit has not been specified"));
        }
        return this.m_IndexString;
    }

    public int getIndex() {
        if (this.m_IndexString.equals("")) {
            throw new RuntimeException(LocalString.get("No index set"));
        }
        if (this.m_Upper == -1) {
            throw new RuntimeException(LocalString.get("No upper limit has been specified for index"));
        }
        return this.m_SelectedIndex;
    }

    public static String indexToString(int n) {
        return "" + (n + 1);
    }

    protected void setValue() {
        if (this.m_IndexString.equals("")) {
            throw new RuntimeException(LocalString.get("No index set"));
        }
        if (this.m_IndexString.toLowerCase().equals("first")) {
            this.m_SelectedIndex = 0;
        } else if (this.m_IndexString.toLowerCase().equals("last")) {
            this.m_SelectedIndex = this.m_Upper;
        } else {
            this.m_SelectedIndex = Integer.parseInt(this.m_IndexString) - 1;
            if (this.m_SelectedIndex < 0) {
                this.m_IndexString = "";
                throw new IllegalArgumentException(LocalString.get("Index must be greater than zero"));
            }
            if (this.m_SelectedIndex > this.m_Upper) {
                this.m_IndexString = "";
                throw new IllegalArgumentException(LocalString.get("Index is too large"));
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception(LocalString.get("Usage: SingleIndex <indexspec>"));
            }
            SingleIndex singleIndex = new SingleIndex();
            singleIndex.setSingleIndex(stringArray[0]);
            singleIndex.setUpper(9);
            System.out.println(LocalString.get("Input: ") + stringArray[0] + "\n" + singleIndex.toString());
            int n = singleIndex.getIndex();
            System.out.println(n + "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

