/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import weka.LocalString;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AbstractLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;

public class ArffLoader
extends AbstractLoader
implements FileSourcedConverter,
BatchConverter,
IncrementalConverter {
    public static String FILE_EXTENSION = Instances.FILE_EXTENSION;
    protected transient Instances m_structure = null;
    protected String m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
    private transient Reader m_sourceReader = null;

    public String globalInfo() {
        return LocalString.get("Reads a source that is in arff (attribute relation file format) ") + LocalString.get("format. ");
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String getFileDescription() {
        return LocalString.get("Arff data files");
    }

    public void reset() throws Exception {
        this.m_structure = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        }
    }

    public void setSource(File file) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException(LocalString.get("Source file object is null!"));
        }
        try {
            this.setSource(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(LocalString.get("File not found"));
        }
        this.m_File = file.getAbsolutePath();
    }

    public File retrieveFile() {
        return new File(this.m_File);
    }

    public void setFile(File file) throws IOException {
        this.m_File = file.getAbsolutePath();
        this.setSource(file);
    }

    public void setSource(InputStream inputStream) throws IOException {
        this.m_File = null;
        this.m_sourceReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException(LocalString.get("No source has been specified"));
        }
        if (this.m_structure == null) {
            try {
                this.m_structure = new Instances(this.m_sourceReader, 1);
            }
            catch (Exception exception) {
                throw new IOException(LocalString.get("Unable to determine structure as arff."));
            }
        }
        return new Instances(this.m_structure, 0);
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException(LocalString.get("No source has been specified"));
        }
        if (this.getRetrieval() == 2) {
            throw new IOException(LocalString.get("Cannot mix getting Instances in both incremental and batch modes"));
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        while (this.m_structure.readInstance(this.m_sourceReader)) {
        }
        Instances instances = new Instances(this.m_structure);
        return instances;
    }

    public Instance getNextInstance() throws IOException {
        if (this.m_structure == null) {
            this.getStructure();
        }
        if (this.getRetrieval() == 1) {
            throw new IOException(LocalString.get("Cannot mix getting Instances in both incremental and batch modes"));
        }
        this.setRetrieval(2);
        if (!this.m_structure.readInstance(this.m_sourceReader)) {
            return null;
        }
        Instance instance = this.m_structure.instance(0);
        this.m_structure.delete(0);
        if (instance == null) {
            try {
                this.reset();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return instance;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            File file = new File(stringArray[0]);
            try {
                Instance instance;
                ArffLoader arffLoader = new ArffLoader();
                arffLoader.setSource(file);
                System.out.println(arffLoader.getStructure());
                do {
                    if ((instance = arffLoader.getNextInstance()) == null) continue;
                    System.out.println(instance);
                } while (instance != null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println(LocalString.get("Usage:\n\tArffLoader <file.arff>\n"));
        }
    }
}

