/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.datagenerators.ClusterGenerator;

public class BIRCHCluster
extends ClusterGenerator
implements OptionHandler,
Serializable {
    private int m_MinInstNum = 1;
    private int m_MaxInstNum = 50;
    private double m_MinRadius = 0.1;
    private double m_MaxRadius = Math.sqrt(2.0);
    public static final int GRID = 0;
    public static final int SINE = 1;
    public static final int RANDOM = 2;
    private int m_Pattern = 2;
    private double m_DistMult = 4.0;
    private int m_NumCycles = 4;
    public static final int ORDERED = 0;
    public static final int RANDOMIZED = 1;
    private int m_InputOrder = 1;
    private double m_NoiseRate = 0.0;
    private int m_Seed = 1;
    private Instances m_DatasetFormat = null;
    private Random m_Random = null;
    private int m_Debug = 0;
    private FastVector m_ClusterList;
    private int m_GridSize;
    private double m_GridWidth;

    public String globalInfo() {
        return LocalString.get("A data generator that produces data points in ") + "clusters.";
    }

    public void setInstNums(String string) {
        int n = string.indexOf("..");
        String string2 = string.substring(0, n);
        this.setMinInstNum(Integer.parseInt(string2));
        String string3 = string.substring(n + 2, string.length());
        this.setMaxInstNum(Integer.parseInt(string3));
    }

    public String getInstNums() {
        String string = "" + this.getMinInstNum() + ".." + this.getMaxInstNum();
        return string;
    }

    public int getMinInstNum() {
        return this.m_MinInstNum;
    }

    public void setMinInstNum(int n) {
        this.m_MinInstNum = n;
    }

    public int getMaxInstNum() {
        return this.m_MaxInstNum;
    }

    public void setMaxInstNum(int n) {
        this.m_MaxInstNum = n;
    }

    public void setRadiuses(String string) {
        int n = string.indexOf("..");
        String string2 = string.substring(0, n);
        this.setMinRadius(Double.valueOf(string2));
        String string3 = string.substring(n + 2, string.length());
        this.setMaxRadius(Double.valueOf(string3));
    }

    public String getRadiuses() {
        String string = "" + Utils.doubleToString(this.getMinRadius(), 2) + ".." + Utils.doubleToString(this.getMaxRadius(), 2);
        return string;
    }

    public double getMinRadius() {
        return this.m_MinRadius;
    }

    public void setMinRadius(double d) {
        this.m_MinRadius = d;
    }

    public double getMaxRadius() {
        return this.m_MaxRadius;
    }

    public void setMaxRadius(double d) {
        this.m_MaxRadius = d;
    }

    public boolean getGridFlag() {
        return this.m_Pattern == 0;
    }

    public boolean getSineFlag() {
        return this.m_Pattern == 1;
    }

    public int getPattern() {
        return this.m_Pattern;
    }

    public void setPattern(int n) {
        this.m_Pattern = n;
    }

    public double getDistMult() {
        return this.m_DistMult;
    }

    public void setDistMult(double d) {
        this.m_DistMult = d;
    }

    public int getNumCycles() {
        return this.m_NumCycles;
    }

    public void setNumCycles(int n) {
        this.m_NumCycles = n;
    }

    public int getInputOrder() {
        return this.m_InputOrder;
    }

    public void setInputOrder(int n) {
        this.m_InputOrder = n;
    }

    public boolean getOrderedFlag() {
        return this.m_InputOrder == 0;
    }

    public double getNoiseRate() {
        return this.m_NoiseRate;
    }

    public void setNoiseRate(double d) {
        this.m_NoiseRate = d;
    }

    public Random getRandom() {
        if (this.m_Random == null) {
            this.m_Random = new Random(this.getSeed());
        }
        return this.m_Random;
    }

    public void setRandom(Random random) {
        this.m_Random = random;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public Instances getDatasetFormat() {
        return this.m_DatasetFormat;
    }

    public void setDatasetFormat(Instances instances) {
        this.m_DatasetFormat = instances;
    }

    public boolean getSingleModeFlag() {
        return false;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option(LocalString.get("\tSet pattern to grid (default is random)."), "G", 1, "-G"));
        vector.addElement(new Option(LocalString.get("\tSet pattern to sine (default is random)."), "S", 1, "-S"));
        vector.addElement(new Option(LocalString.get("\tThe range of number of instances per cluster (default 1..50)."), "N", 1, LocalString.get("-N <num>..<num>")));
        vector.addElement(new Option(LocalString.get("\tThe range of radius per cluster (default 0.1..sqrt(2))."), "R", 1, LocalString.get("-R <num>..<num>")));
        vector.addElement(new Option(LocalString.get("\tThe distance multiplier (default 4)."), "M", 1, LocalString.get("-M <num>")));
        vector.addElement(new Option(LocalString.get("\tThe number of cycles (default 4)."), "C", 1, LocalString.get("-C <num>")));
        vector.addElement(new Option(LocalString.get("\tSet input order to ordered (default is randomized)."), "O", 1, "-O"));
        vector.addElement(new Option(LocalString.get("\tThe noise rate in percent (default 0)."), "P", 1, LocalString.get("-P <num>")));
        vector.addElement(new Option(LocalString.get("\tThe Seed for random function (default 1)."), "S", 1, "-S"));
        return vector.elements();
    }

    public void setDefaultOptions() {
        this.m_MinInstNum = 1;
        this.m_MaxInstNum = 50;
        this.m_MinRadius = 0.1;
        this.m_MaxRadius = Math.sqrt(2.0);
        this.m_Pattern = 2;
        this.m_DistMult = 4.0;
        this.m_NumCycles = 4;
        this.m_InputOrder = 1;
        this.m_NoiseRate = 0.0;
        this.m_Seed = 1;
    }

    public void setOptions(String[] stringArray) throws Exception {
        boolean bl;
        String string;
        this.setDefaultOptions();
        String string2 = Utils.getOption('N', stringArray);
        if (string2.length() != 0) {
            this.setInstNums(string2);
        }
        if ((string2 = Utils.getOption('R', stringArray)).length() != 0) {
            this.setRadiuses(string2);
        }
        boolean bl2 = Utils.getFlag('G', stringArray);
        boolean bl3 = Utils.getFlag('I', stringArray);
        if (bl2 && bl3) {
            throw new Exception(LocalString.get("Flags G and I can only be set mutually exclusiv."));
        }
        if (bl2) {
            this.setPattern(0);
        }
        if (bl3) {
            this.setPattern(1);
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            if (!bl2) {
                throw new Exception(LocalString.get("Option M can only be used with GRID pattern."));
            }
            this.setDistMult(Double.valueOf(string));
        }
        if ((string = Utils.getOption('C', stringArray)).length() != 0) {
            if (!bl3) {
                throw new Exception(LocalString.get("Option C can only be used with SINE pattern."));
            }
            this.setNumCycles((int)Double.valueOf(string).doubleValue());
        }
        if (bl = Utils.getFlag('O', stringArray)) {
            this.setInputOrder(0);
        }
        if ((string = Utils.getOption('P', stringArray)).length() != 0) {
            this.setNoiseRate(Double.valueOf(string));
        }
        if ((string = Utils.getOption('S', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[20];
        int n = 0;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getInstNums();
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getRadiuses();
        if (this.getGridFlag()) {
            stringArray[n++] = "-G";
            stringArray[n++] = "";
            stringArray[n++] = "-D";
            stringArray[n++] = "" + this.getDistMult();
        }
        if (this.getSineFlag()) {
            stringArray[n++] = "-I";
            stringArray[n++] = "";
            stringArray[n++] = "-C";
            stringArray[n++] = "" + this.getNumCycles();
        }
        if (this.getOrderedFlag()) {
            stringArray[n++] = "-O";
            stringArray[n++] = "";
        }
        stringArray[n++] = "-P";
        stringArray[n++] = "" + this.getNoiseRate();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Instances defineDataFormat() throws Exception {
        Attribute attribute;
        int n;
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        FastVector fastVector = new FastVector(3);
        boolean bl = this.getClassFlag();
        FastVector fastVector2 = null;
        if (bl) {
            fastVector2 = new FastVector(this.m_NumClusters);
        }
        for (n = 0; n < this.getNumAttributes(); ++n) {
            attribute = new Attribute("X" + n);
            fastVector.addElement(attribute);
        }
        if (bl) {
            for (n = 0; n < this.m_NumClusters; ++n) {
                fastVector2.addElement("c" + n);
            }
            attribute = new Attribute("class", fastVector2);
            fastVector.addElement(attribute);
        }
        Instances instances = new Instances(this.getRelationName(), fastVector, 0);
        if (bl) {
            instances.setClassIndex(this.m_NumAttributes);
        }
        Instances instances2 = new Instances(instances, 0);
        this.setDatasetFormat(instances2);
        this.m_ClusterList = this.defineClusters(random);
        System.out.println("dataset" + instances.numAttributes());
        return instances;
    }

    public Instance generateExample() throws Exception {
        throw new Exception(LocalString.get("Examples cannot be generated") + LocalString.get(" one by one."));
    }

    public Instances generateExamples() throws Exception {
        Random random = this.getRandom();
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception(LocalString.get("Dataset format not defined."));
        }
        if (!this.getOrderedFlag()) {
            throw new Exception(LocalString.get("RANDOMIZED is not yet implemented."));
        }
        instances = this.generateExamples(random, instances);
        return instances;
    }

    public Instances generateExamples(Random random, Instances instances) throws Exception {
        Instance instance = null;
        if (instances == null) {
            throw new Exception(LocalString.get("Dataset format not defined."));
        }
        int n = 0;
        Enumeration enumeration = this.m_ClusterList.elements();
        while (enumeration.hasMoreElements()) {
            Cluster cluster = (Cluster)enumeration.nextElement();
            double d = cluster.getStdDev();
            int n2 = cluster.getInstNum();
            double[] dArray = cluster.getCenter();
            String string = "c" + n;
            for (int i = 0; i < n2; ++i) {
                instance = this.generateInstance(instances, random, d, dArray, string);
                if (instance != null) {
                    instance.setDataset(instances);
                }
                instances.add(instance);
            }
            ++n;
        }
        return instances;
    }

    private Instance generateInstance(Instances instances, Random random, double d, double[] dArray, String string) {
        int n = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++n;
        }
        Instance instance = new Instance(n);
        instance.setDataset(instances);
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            instance.setValue(i, random.nextGaussian() * d + dArray[i]);
        }
        if (this.getClassFlag()) {
            instance.setClassValue(string);
        }
        return instance;
    }

    private FastVector defineClusters(Random random) throws Exception {
        if (this.m_Pattern == 0) {
            return this.defineClustersGRID(random);
        }
        return this.defineClustersRANDOM(random);
    }

    private FastVector defineClustersGRID(Random random) throws Exception {
        FastVector fastVector = new FastVector(this.m_NumClusters);
        double d = this.m_MaxInstNum - this.m_MinInstNum;
        double d2 = this.m_MinInstNum;
        double d3 = this.m_MaxRadius - this.m_MinRadius;
        double d4 = Math.pow(this.m_NumClusters, 1.0 / (double)this.m_NumAttributes);
        this.m_GridSize = d4 - (double)((int)d4) > 0.0 ? (int)(d4 + 1.0) : (int)d4;
        this.m_GridWidth = (this.m_MaxRadius + this.m_MinRadius) / 2.0 * this.m_DistMult;
        System.out.println(LocalString.get("GridSize= ") + this.m_GridSize);
        System.out.println(LocalString.get("GridWidth= ") + this.m_GridWidth);
        GridVector gridVector = new GridVector(this.m_NumAttributes, this.m_GridSize);
        for (int i = 0; i < this.m_NumClusters; ++i) {
            int n = (int)(random.nextDouble() * d + d2);
            double d5 = random.nextDouble() * d3 + this.m_MinRadius;
            Cluster cluster = new Cluster(n, d5, gridVector.getGridVector(), this.m_GridWidth);
            fastVector.addElement(cluster);
            gridVector.addOne();
        }
        return fastVector;
    }

    private FastVector defineClustersRANDOM(Random random) throws Exception {
        FastVector fastVector = new FastVector(this.m_NumClusters);
        double d = this.m_MaxInstNum - this.m_MinInstNum;
        double d2 = this.m_MinInstNum;
        double d3 = this.m_MaxRadius - this.m_MinRadius;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            int n = (int)(random.nextDouble() * d + d2);
            double d4 = random.nextDouble() * d3 + this.m_MinRadius;
            Cluster cluster = new Cluster(n, d4, random);
            fastVector.addElement(cluster);
        }
        return fastVector;
    }

    public String generateFinished() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Instances instances = this.getDatasetFormat();
        stringBuffer.append("\n%\n%\n");
        return stringBuffer.toString();
    }

    public String generateStart() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n%\n%\n");
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.m_ClusterList.elements();
        while (enumeration.hasMoreElements()) {
            Cluster cluster = (Cluster)enumeration.nextElement();
            stringBuffer.append("%\n");
            stringBuffer.append(LocalString.get("% Cluster: c") + n2 + "\n");
            stringBuffer.append("% ----------------------------------------------\n");
            stringBuffer.append(LocalString.get("% StandardDeviation: ") + Utils.doubleToString(cluster.getStdDev(), 2) + "\n");
            stringBuffer.append(LocalString.get("% Number of instances: ") + cluster.getInstNum() + "\n");
            n += cluster.getInstNum();
            double[] dArray = cluster.getCenter();
            stringBuffer.append("% ");
            for (int i = 0; i < dArray.length - 1; ++i) {
                stringBuffer.append(Utils.doubleToString(dArray[i], 2) + ", ");
            }
            stringBuffer.append(Utils.doubleToString(dArray[dArray.length - 1], 2) + "\n");
            ++n2;
        }
        stringBuffer.append("\n% ----------------------------------------------\n");
        stringBuffer.append(LocalString.get("% Total number of instances: ") + n + "\n");
        stringBuffer.append("%                            in " + n2 + LocalString.get(" clusters\n"));
        stringBuffer.append(LocalString.get("% Pattern chosen           : "));
        if (this.getGridFlag()) {
            stringBuffer.append(LocalString.get("GRID, ") + LocalString.get("distance multiplier = ") + Utils.doubleToString(this.m_DistMult, 2) + "\n");
        } else if (this.getSineFlag()) {
            stringBuffer.append("SINE\n");
        } else {
            stringBuffer.append("RANDOM\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            ClusterGenerator.makeData(new BIRCHCluster(), stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private class GridVector
    implements Serializable {
        private int[] m_GridVector;
        private int m_Base;
        private int m_Size;

        private GridVector(int n, int n2) {
            this.m_Size = n;
            this.m_Base = n2;
            this.m_GridVector = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_GridVector[i] = 0;
            }
        }

        private int[] getGridVector() {
            return this.m_GridVector;
        }

        private boolean overflow(int n) {
            return n == 0;
        }

        private int addOne(int n) {
            int n2 = n + 1;
            if (n2 >= this.m_Base) {
                n2 = 0;
            }
            return n2;
        }

        private void addOne() {
            this.m_GridVector[0] = this.addOne(this.m_GridVector[0]);
            for (int i = 1; this.overflow(this.m_GridVector[i - 1]) && i < this.m_Size; ++i) {
                this.m_GridVector[i] = this.addOne(this.m_GridVector[i]);
            }
        }
    }

    private class Cluster
    implements Serializable {
        private int m_InstNum;
        private double m_Radius;
        private double[] m_Center;

        private Cluster(int n, double d, Random random) {
            this.m_InstNum = n;
            this.m_Radius = d;
            this.m_Center = new double[BIRCHCluster.this.m_NumAttributes];
            for (int i = 0; i < BIRCHCluster.this.m_NumAttributes; ++i) {
                this.m_Center[i] = random.nextDouble() * (double)BIRCHCluster.this.m_NumClusters;
            }
        }

        private Cluster(int n, double d, int[] nArray, double d2) {
            this.m_InstNum = n;
            this.m_Radius = d;
            this.m_Center = new double[BIRCHCluster.this.m_NumAttributes];
            for (int i = 0; i < BIRCHCluster.this.m_NumAttributes; ++i) {
                this.m_Center[i] = ((double)nArray[i] + 1.0) * d2;
            }
        }

        private int getInstNum() {
            return this.m_InstNum;
        }

        private double getRadius() {
            return this.m_Radius;
        }

        private double getVariance() {
            return Math.pow(this.m_Radius, 2.0) / 2.0;
        }

        private double getStdDev() {
            return this.m_Radius / Math.pow(2.0, 0.5);
        }

        private double[] getCenter() {
            return this.m_Center;
        }

        private double getCenterValue(int n) throws Exception {
            if (n >= this.m_Center.length) {
                throw new Exception(LocalString.get("Current system has only ") + this.m_Center.length + LocalString.get(" dimensions."));
            }
            return this.m_Center[n];
        }
    }
}

