/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.datagenerators.Generator;
import weka.datagenerators.Test;

public class RDG1
extends Generator
implements OptionHandler,
Serializable {
    private int m_MaxRuleSize = 10;
    private int m_MinRuleSize = 1;
    private int m_NumIrrelevant = 0;
    private int m_NumNumeric = 0;
    private int m_Seed = 1;
    private boolean m_VoteFlag = false;
    private Instances m_DatasetFormat = null;
    private Random m_Random = null;
    private FastVector m_DecisionList = null;
    boolean[] m_AttList_Irr;
    private int m_Debug = 0;

    public String globalInfo() {
        return LocalString.get("A data generator that produces data randomly ") + LocalString.get("with 'boolean' (nominal with values {false,true}) and") + LocalString.get("numeric attributes by producing a decisionlist.");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option(LocalString.get("\tmaximum size for rules (default 10) "), "R", 1, LocalString.get("-R <num>")));
        vector.addElement(new Option(LocalString.get("\tminimum size for rules (default 1) "), "M", 1, LocalString.get("-M <num>")));
        vector.addElement(new Option(LocalString.get("\tnumber of irrelevant attributes (default 0)"), "I", 1, LocalString.get("-I <num>")));
        vector.addElement(new Option(LocalString.get("\tnumber of numeric attributes (default 0)"), "N", 1, "-N"));
        vector.addElement(new Option(LocalString.get("\tseed for random function (default 1)"), "S", 1, "-S"));
        vector.addElement(new Option(LocalString.get("\tswitch on voting (default is no voting)"), "V", 1, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setMaxRuleSize((int)Double.valueOf(string).doubleValue());
        } else {
            this.setMaxRuleSize(10);
        }
        string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMinRuleSize((int)Double.valueOf(string).doubleValue());
        } else {
            this.setMinRuleSize(1);
        }
        String string2 = Utils.getOption('I', stringArray);
        if (string2.length() != 0) {
            this.setNumIrrelevant((int)Double.valueOf(string2).doubleValue());
        } else {
            this.setNumIrrelevant(0);
        }
        if (this.getNumAttributes() - this.getNumIrrelevant() < this.getMinRuleSize()) {
            throw new Exception(LocalString.get("Possible rule size is below minimal rule size."));
        }
        String string3 = Utils.getOption('N', stringArray);
        if (string3.length() != 0) {
            this.setNumNumeric((int)Double.valueOf(string3).doubleValue());
        } else {
            this.setNumNumeric(0);
        }
        String string4 = Utils.getOption('S', stringArray);
        if (string4.length() != 0) {
            this.setSeed(Integer.parseInt(string4));
        } else {
            this.setSeed(1);
        }
        bl = Utils.getFlag('V', stringArray);
        this.setVoteFlag(bl);
    }

    public String[] getOptions() {
        String[] stringArray = new String[12];
        int n = 0;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getNumNumeric();
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getNumIrrelevant();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMinRuleSize();
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getMaxRuleSize();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        if (this.getVoteFlag()) {
            stringArray[n++] = "-V";
            stringArray[n++] = "";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Random getRandom() {
        if (this.m_Random == null) {
            this.m_Random = new Random(this.getSeed());
        }
        return this.m_Random;
    }

    public void setRandom(Random random) {
        this.m_Random = random;
    }

    public int getMaxRuleSize() {
        return this.m_MaxRuleSize;
    }

    public void setMaxRuleSize(int n) {
        this.m_MaxRuleSize = n;
    }

    public int getMinRuleSize() {
        return this.m_MinRuleSize;
    }

    public void setMinRuleSize(int n) {
        this.m_MinRuleSize = n;
    }

    public int getNumIrrelevant() {
        return this.m_NumIrrelevant;
    }

    public void setNumIrrelevant(int n) {
        this.m_NumIrrelevant = n;
    }

    public int getNumNumeric() {
        return this.m_NumNumeric;
    }

    public void setNumNumeric(int n) {
        this.m_NumNumeric = n;
    }

    public boolean getVoteFlag() {
        return this.m_VoteFlag;
    }

    public void setVoteFlag(boolean bl) {
        this.m_VoteFlag = bl;
    }

    public boolean getSingleModeFlag() {
        return !this.getVoteFlag();
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public Instances getDatasetFormat() {
        return this.m_DatasetFormat;
    }

    public void setDatasetFormat(Instances instances) {
        this.m_DatasetFormat = instances;
    }

    public boolean[] getAttList_Irr() {
        return this.m_AttList_Irr;
    }

    public void setAttList_Irr(boolean[] blArray) {
        this.m_AttList_Irr = blArray;
    }

    public Instances defineDataFormat() throws Exception {
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        this.m_DecisionList = new FastVector();
        this.setNumExamplesAct(this.getNumExamples());
        Instances instances = this.defineDataset(random);
        return instances;
    }

    public Instance generateExample() throws Exception {
        Random random = this.getRandom();
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception(LocalString.get("Dataset format not defined."));
        }
        if (this.getVoteFlag()) {
            throw new Exception(LocalString.get("Examples cannot be generated") + LocalString.get(" one by one."));
        }
        instances = this.generateExamples(1, random, instances);
        return instances.lastInstance();
    }

    public Instances generateExamples() throws Exception {
        Random random = this.getRandom();
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception(LocalString.get("Dataset format not defined."));
        }
        instances = this.generateExamples(this.getNumExamplesAct(), random, instances);
        if (this.getVoteFlag()) {
            instances = this.voteDataset(instances);
        }
        return instances;
    }

    public Instances generateExamples(int n, Random random, Instances instances) throws Exception {
        if (instances == null) {
            throw new Exception(LocalString.get("Dataset format not defined."));
        }
        for (int i = 0; i < n; ++i) {
            Instance instance = this.generateExample(random, instances);
            boolean bl = this.classifyExample(instance);
            if (!bl) {
                instance = this.updateDecisionList(random, instance);
            }
            instance.setDataset(instances);
            instances.add(instance);
        }
        return instances;
    }

    private Instance updateDecisionList(Random random, Instance instance) throws Exception {
        Serializable serializable;
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception(LocalString.get("Dataset format not defined."));
        }
        FastVector fastVector = this.generateTestList(random, instance);
        int n = this.getMaxRuleSize() < fastVector.size() ? this.getMaxRuleSize() : fastVector.size();
        int n2 = (int)(random.nextDouble() * (double)(n - this.getMinRuleSize())) + this.getMinRuleSize();
        RuleList ruleList = new RuleList();
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)(random.nextDouble() * (double)fastVector.size());
            serializable = (Test)fastVector.elementAt(n3);
            ruleList.addTest((Test)serializable);
            fastVector.removeElementAt(n3);
        }
        double d = 0.0;
        if (this.m_DecisionList.size() > 0) {
            serializable = (RuleList)this.m_DecisionList.lastElement();
            double d2 = ((RuleList)serializable).getClassValue();
            d = (double)((int)d2 + 1) % (double)this.getNumClasses();
        }
        ruleList.setClassValue(d);
        this.m_DecisionList.addElement(ruleList);
        instance = (Instance)instance.copy();
        instance.setDataset(instances);
        instance.setClassValue(d);
        return instance;
    }

    private FastVector generateTestList(Random random, Instance instance) throws Exception {
        Instances instances = this.getDatasetFormat();
        if (instances == null) {
            throw new Exception(LocalString.get("Dataset format not defined."));
        }
        int n = this.getNumAttributes() - this.getNumIrrelevant();
        FastVector fastVector = new FastVector(n);
        boolean[] blArray = this.getAttList_Irr();
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            if (blArray[i]) continue;
            Test test = null;
            Attribute attribute = instance.attribute(i);
            if (attribute.isNumeric()) {
                double d = random.nextDouble();
                boolean bl = d < instance.value(i);
                test = new Test(i, d, instances, bl);
            } else {
                test = new Test(i, instance.value(i), instances, false);
            }
            fastVector.addElement(test);
        }
        return fastVector;
    }

    private Instance generateExample(Random random, Instances instances) throws Exception {
        double[] dArray = new double[this.getNumAttributes() + 1];
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            double d = random.nextDouble();
            if (instances.attribute(i).isNumeric()) {
                dArray[i] = d;
                continue;
            }
            if (instances.attribute(i).isNominal()) {
                dArray[i] = d > 0.5 ? 1.0 : 0.0;
                continue;
            }
            throw new Exception(LocalString.get("Attribute type is not supported."));
        }
        Instance instance = new Instance(0.0, dArray);
        instance.setDataset(instances);
        instance.setClassMissing();
        return instance;
    }

    private boolean classifyExample(Instance instance) throws Exception {
        double d = -1.0;
        Enumeration enumeration = this.m_DecisionList.elements();
        while (enumeration.hasMoreElements() && d < 0.0) {
            RuleList ruleList = (RuleList)enumeration.nextElement();
            d = ruleList.classifyInstance(instance);
        }
        if (d >= 0.0) {
            instance.setClassValue(d);
            return true;
        }
        return false;
    }

    private Instance votedReclassifyExample(Instance instance) throws Exception {
        int n;
        boolean bl = false;
        int[] nArray = new int[this.getNumClasses()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        Enumeration enumeration = this.m_DecisionList.elements();
        while (enumeration.hasMoreElements()) {
            RuleList ruleList = (RuleList)enumeration.nextElement();
            n = (int)ruleList.classifyInstance(instance);
            if (n < 0) continue;
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
        }
        int n3 = 0;
        int n4 = -1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] <= n3) continue;
            n3 = nArray[n];
            n4 = n;
        }
        if (n4 < 0) {
            throw new Exception(LocalString.get("Error in instance classification."));
        }
        instance.setClassValue(n4);
        return instance;
    }

    private Instances defineDataset(Random random) throws Exception {
        Attribute attribute;
        int n;
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector(2);
        fastVector2.addElement("false");
        fastVector2.addElement("true");
        FastVector fastVector3 = new FastVector(this.getNumClasses());
        boolean[] blArray = this.defineIrrelevant(random);
        this.setAttList_Irr(blArray);
        int[] nArray = this.defineNumeric(random);
        for (n = 0; n < this.getNumAttributes(); ++n) {
            attribute = nArray[n] == 0 ? new Attribute("a" + n) : new Attribute("a" + n, fastVector2);
            fastVector.addElement(attribute);
        }
        n = fastVector3.capacity();
        for (int i = 0; i < fastVector3.capacity(); ++i) {
            fastVector3.addElement("c" + i);
        }
        attribute = new Attribute("class", fastVector3);
        fastVector.addElement(attribute);
        Instances instances = new Instances(this.getRelationName(), fastVector, this.getNumExamplesAct());
        instances.setClassIndex(this.getNumAttributes());
        Instances instances2 = new Instances(instances, 0);
        this.setDatasetFormat(instances2);
        return instances;
    }

    private boolean[] defineIrrelevant(Random random) {
        int n;
        boolean[] blArray = new boolean[this.getNumAttributes()];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        n = 0;
        for (int i = 0; n < this.getNumIrrelevant() && i < this.getNumAttributes() * 5; ++i) {
            int n2 = (int)(random.nextDouble() * (double)blArray.length);
            if (blArray[n2]) continue;
            blArray[n2] = true;
            ++n;
        }
        return blArray;
    }

    private int[] defineNumeric(Random random) {
        int n;
        int[] nArray = new int[this.getNumAttributes()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 1;
        }
        n = 0;
        for (int i = 0; n < this.getNumNumeric() && i < this.getNumAttributes() * 5; ++i) {
            int n2 = (int)(random.nextDouble() * (double)nArray.length);
            if (nArray[n2] == 0) continue;
            nArray[n2] = 0;
            ++n;
        }
        return nArray;
    }

    public String generateFinished() throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = this.getAttList_Irr();
        Instances instances = this.getDatasetFormat();
        stringBuffer.append(LocalString.get("\n%\n% Number of attributes chosen as irrelevant = ") + this.getNumIrrelevant() + "\n");
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            stringBuffer.append("% " + instances.attribute(n).name() + "\n");
        }
        stringBuffer.append(LocalString.get("%\n% DECISIONLIST (number of rules = ") + this.m_DecisionList.size() + "):\n");
        for (n = 0; n < this.m_DecisionList.size(); ++n) {
            RuleList ruleList = (RuleList)this.m_DecisionList.elementAt(n);
            stringBuffer.append(LocalString.get("% RULE ") + n + ": " + ruleList.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    private Instances voteDataset(Instances instances) throws Exception {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.firstInstance();
            instance = this.votedReclassifyExample(instance);
            instances.add(instance);
            instances.delete(0);
        }
        return instances;
    }

    public static void main(String[] stringArray) {
        try {
            Generator.makeData(new RDG1(), stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private class RuleList
    implements Serializable {
        private FastVector m_RuleList = null;
        double m_ClassValue = 0.0;

        private RuleList() {
        }

        public double getClassValue() {
            return this.m_ClassValue;
        }

        public void setClassValue(double d) {
            this.m_ClassValue = d;
        }

        private void addTest(Test test) {
            if (this.m_RuleList == null) {
                this.m_RuleList = new FastVector();
            }
            this.m_RuleList.addElement(test);
        }

        private double classifyInstance(Instance instance) throws Exception {
            boolean bl = true;
            Enumeration enumeration = this.m_RuleList.elements();
            while (bl && enumeration.hasMoreElements()) {
                Test test = (Test)enumeration.nextElement();
                bl = test.passesTest(instance);
            }
            if (bl) {
                return this.m_ClassValue;
            }
            return -1.0;
        }

        public String toString() {
            Test test;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = stringBuffer.append("  c" + (int)this.m_ClassValue + " := ");
            Enumeration enumeration = this.m_RuleList.elements();
            if (enumeration.hasMoreElements()) {
                test = (Test)enumeration.nextElement();
                stringBuffer = stringBuffer.append(test.toPrologString());
            }
            while (enumeration.hasMoreElements()) {
                test = (Test)enumeration.nextElement();
                stringBuffer = stringBuffer.append(", " + test.toPrologString());
            }
            return stringBuffer.toString();
        }
    }
}

