/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Queue;
import weka.core.Utils;

public abstract class Filter
implements Serializable {
    private boolean m_Debug = false;
    private Instances m_OutputFormat = null;
    private Queue m_OutputQueue = null;
    private int[] m_OutputStringAtts = null;
    private int[] m_InputStringAtts = null;
    private Instances m_InputFormat = null;
    protected boolean m_NewBatch = true;

    protected void setOutputFormat(Instances instances) {
        if (instances != null) {
            this.m_OutputFormat = instances.stringFreeStructure();
            this.m_OutputStringAtts = this.getStringIndices(this.m_OutputFormat);
            String string = instances.relationName() + "-" + this.getClass().getName();
            if (this instanceof OptionHandler) {
                String[] stringArray = ((OptionHandler)((Object)this)).getOptions();
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i].trim();
                }
            }
            this.m_OutputFormat.setRelationName(string);
        } else {
            this.m_OutputFormat = null;
        }
        this.m_OutputQueue = new Queue();
    }

    protected Instances getInputFormat() {
        return this.m_InputFormat;
    }

    protected Instances inputFormatPeek() {
        return this.m_InputFormat;
    }

    protected Instances outputFormatPeek() {
        return this.m_OutputFormat;
    }

    protected void push(Instance instance) {
        if (instance != null) {
            this.copyStringValues(instance, this.m_OutputFormat, this.m_OutputStringAtts);
            instance.setDataset(this.m_OutputFormat);
            this.m_OutputQueue.push(instance);
        }
    }

    protected void resetQueue() {
        this.m_OutputQueue = new Queue();
    }

    protected void bufferInput(Instance instance) {
        if (instance != null) {
            this.copyStringValues(instance, this.m_InputFormat, this.m_InputStringAtts);
            this.m_InputFormat.add(instance);
        }
    }

    protected int[] getInputStringIndex() {
        return this.m_InputStringAtts;
    }

    protected int[] getOutputStringIndex() {
        return this.m_OutputStringAtts;
    }

    private void copyStringValues(Instance instance, Instances instances, int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        if (instance.dataset() == null) {
            throw new IllegalArgumentException(LocalString.get("Instance has no dataset assigned!!"));
        }
        if (instance.dataset().numAttributes() != instances.numAttributes()) {
            throw new IllegalArgumentException(LocalString.get("Src and Dest differ in # of attributes!!"));
        }
        this.copyStringValues(instance, true, instance.dataset(), nArray, instances, nArray);
    }

    protected void copyStringValues(Instance instance, boolean bl, Instances instances, Instances instances2) {
        this.copyStringValues(instance, bl, instances, this.m_InputStringAtts, instances2, this.m_OutputStringAtts);
    }

    protected void copyStringValues(Instance instance, boolean bl, Instances instances, int[] nArray, Instances instances2, int[] nArray2) {
        if (instances == instances2) {
            return;
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException(LocalString.get("Src and Dest string indices differ in length!!"));
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = bl ? nArray[i] : nArray2[i];
            Attribute attribute = instances.attribute(nArray[i]);
            Attribute attribute2 = instances2.attribute(nArray2[i]);
            if (instance.isMissing(n)) continue;
            int n2 = attribute2.addStringValue(attribute, (int)instance.value(n));
            instance.setValue(n, (double)n2);
        }
    }

    protected void flushInput() {
        if (this.m_InputStringAtts.length > 0) {
            this.m_InputFormat = this.m_InputFormat.stringFreeStructure();
        } else {
            this.m_InputFormat.delete();
        }
    }

    public boolean inputFormat(Instances instances) throws Exception {
        return this.setInputFormat(instances);
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        this.m_InputFormat = instances.stringFreeStructure();
        this.m_InputStringAtts = this.getStringIndices(instances);
        this.m_OutputFormat = null;
        this.m_OutputQueue = new Queue();
        this.m_NewBatch = true;
        return false;
    }

    public Instances outputFormat() {
        return this.getOutputFormat();
    }

    public Instances getOutputFormat() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException(LocalString.get("No output format defined."));
        }
        return new Instances(this.m_OutputFormat, 0);
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new NullPointerException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.m_OutputQueue = new Queue();
            this.m_NewBatch = false;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new NullPointerException(LocalString.get("No input instance format defined"));
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Instance output() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException(LocalString.get("No output instance format defined"));
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance instance = (Instance)this.m_OutputQueue.pop();
        if (this.m_OutputQueue.empty() && this.m_NewBatch && this.m_OutputStringAtts.length > 0) {
            this.m_OutputFormat = this.m_OutputFormat.stringFreeStructure();
        }
        return instance;
    }

    public Instance outputPeek() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException(LocalString.get("No output instance format defined"));
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance instance = (Instance)this.m_OutputQueue.peek();
        return instance;
    }

    public int numPendingOutput() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException(LocalString.get("No output instance format defined"));
        }
        return this.m_OutputQueue.size();
    }

    public boolean isOutputFormatDefined() {
        return this.m_OutputFormat != null;
    }

    protected int[] getStringIndices(Instances instances) {
        int[] nArray = new int[instances.numAttributes()];
        int n = 0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (instances.attribute(i).type() != 2) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static Instances useFilter(Instances instances, Filter filter) throws Exception {
        Instance instance;
        for (int i = 0; i < instances.numInstances(); ++i) {
            filter.input(instances.instance(i));
        }
        filter.batchFinished();
        Instances instances2 = filter.getOutputFormat();
        while ((instance = filter.output()) != null) {
            instances2.add(instance);
        }
        return instances2;
    }

    public static void filterFile(Filter filter, String[] stringArray) throws Exception {
        boolean bl = false;
        Instances instances = null;
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            boolean bl2 = Utils.getFlag('h', stringArray);
            if (Utils.getFlag('d', stringArray)) {
                bl = true;
            }
            String string = Utils.getOption('i', stringArray);
            String string2 = Utils.getOption('o', stringArray);
            String string3 = Utils.getOption('c', stringArray);
            if (filter instanceof OptionHandler) {
                ((OptionHandler)((Object)filter)).setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
            if (bl2) {
                throw new Exception(LocalString.get("Help requested.\n"));
            }
            bufferedReader = string.length() != 0 ? new BufferedReader(new FileReader(string)) : new BufferedReader(new InputStreamReader(System.in));
            printWriter = string2.length() != 0 ? new PrintWriter(new FileOutputStream(string2)) : new PrintWriter(System.out);
            instances = new Instances(bufferedReader, 1);
            if (string3.length() != 0) {
                if (string3.equals("first")) {
                    instances.setClassIndex(0);
                } else if (string3.equals("last")) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                } else {
                    instances.setClassIndex(Integer.parseInt(string3) - 1);
                }
            }
        }
        catch (Exception exception) {
            Object object;
            String string = "";
            if (filter instanceof OptionHandler) {
                string = string + LocalString.get("\nFilter options:\n\n");
                object = ((OptionHandler)((Object)filter)).listOptions();
                while (object.hasMoreElements()) {
                    Option option = (Option)object.nextElement();
                    string = string + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            object = LocalString.get("\nGeneral options:\n\n") + "-h\n" + LocalString.get("\tGet help on available options.\n") + LocalString.get("\t(use -b -h for help on batch mode.)\n") + LocalString.get("-i <file>\n") + LocalString.get("\tThe name of the file containing input instances.\n") + LocalString.get("\tIf not supplied then instances will be read from stdin.\n") + LocalString.get("-o <file>\n") + LocalString.get("\tThe name of the file output instances will be written to.\n") + LocalString.get("\tIf not supplied then instances will be written to stdout.\n") + LocalString.get("-c <class index>\n") + LocalString.get("\tThe number of the attribute to use as the class.\n") + LocalString.get("\t\"first\" and \"last\" are also valid entries.\n") + LocalString.get("\tIf not supplied then no class is assigned.\n");
            throw new Exception('\n' + exception.getMessage() + string + (String)object);
        }
        if (bl) {
            System.err.println(LocalString.get("Setting input format"));
        }
        boolean bl3 = false;
        if (filter.setInputFormat(instances)) {
            if (bl) {
                System.err.println(LocalString.get("Getting output format"));
            }
            printWriter.println(filter.getOutputFormat().toString());
            bl3 = true;
        }
        while (instances.readInstance(bufferedReader)) {
            if (bl) {
                System.err.println(LocalString.get("Input instance to filter"));
            }
            if (filter.input(instances.instance(0))) {
                if (bl) {
                    System.err.println(LocalString.get("Filter said collect immediately"));
                }
                if (!bl3) {
                    throw new Error(LocalString.get("Filter didn't return true from setInputFormat() ") + "earlier!");
                }
                if (bl) {
                    System.err.println(LocalString.get("Getting output instance"));
                }
                printWriter.println(filter.output().toString());
            }
            instances.delete(0);
        }
        if (bl) {
            System.err.println(LocalString.get("Setting end of batch"));
        }
        if (filter.batchFinished()) {
            if (bl) {
                System.err.println(LocalString.get("Filter said collect output"));
            }
            if (!bl3) {
                if (bl) {
                    System.err.println(LocalString.get("Getting output format"));
                }
                printWriter.println(filter.getOutputFormat().toString());
            }
            if (bl) {
                System.err.println(LocalString.get("Getting output instance"));
            }
            while (filter.numPendingOutput() > 0) {
                printWriter.println(filter.output().toString());
                if (!bl) continue;
                System.err.println(LocalString.get("Getting output instance"));
            }
        }
        if (bl) {
            System.err.println("Done");
        }
        if (printWriter != null) {
            printWriter.close();
        }
    }

    public static void batchFilterFile(Filter filter, String[] stringArray) throws Exception {
        Instances instances = null;
        Instances instances2 = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            boolean bl = Utils.getFlag('h', stringArray);
            String string = Utils.getOption('i', stringArray);
            if (string.length() == 0) {
                throw new Exception(LocalString.get("No first input file given.\n"));
            }
            bufferedReader = new BufferedReader(new FileReader(string));
            string = Utils.getOption('r', stringArray);
            if (string.length() == 0) {
                throw new Exception(LocalString.get("No second input file given.\n"));
            }
            bufferedReader2 = new BufferedReader(new FileReader(string));
            string = Utils.getOption('o', stringArray);
            printWriter = string.length() != 0 ? new PrintWriter(new FileOutputStream(string)) : new PrintWriter(System.out);
            string = Utils.getOption('s', stringArray);
            printWriter2 = string.length() != 0 ? new PrintWriter(new FileOutputStream(string)) : new PrintWriter(System.out);
            String string2 = Utils.getOption('c', stringArray);
            if (filter instanceof OptionHandler) {
                ((OptionHandler)((Object)filter)).setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
            if (bl) {
                throw new Exception(LocalString.get("Help requested.\n"));
            }
            instances2 = new Instances(bufferedReader2, 1);
            instances = new Instances(bufferedReader, 1);
            if (!instances2.equalHeaders(instances)) {
                throw new Exception(LocalString.get("Input file formats differ.\n"));
            }
            if (string2.length() != 0) {
                if (string2.equals("first")) {
                    instances.setClassIndex(0);
                    instances2.setClassIndex(0);
                } else if (string2.equals("last")) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                    instances2.setClassIndex(instances2.numAttributes() - 1);
                } else {
                    instances.setClassIndex(Integer.parseInt(string2) - 1);
                    instances2.setClassIndex(Integer.parseInt(string2) - 1);
                }
            }
        }
        catch (Exception exception) {
            Object object;
            String string = "";
            if (filter instanceof OptionHandler) {
                string = string + LocalString.get("\nFilter options:\n\n");
                object = ((OptionHandler)((Object)filter)).listOptions();
                while (object.hasMoreElements()) {
                    Option option = (Option)object.nextElement();
                    string = string + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            object = LocalString.get("\nGeneral options:\n\n") + "-h\n" + LocalString.get("\tGet help on available options.\n") + LocalString.get("-i <filename>\n") + LocalString.get("\tThe file containing first input instances.\n") + LocalString.get("-o <filename>\n") + LocalString.get("\tThe file first output instances will be written to.\n") + LocalString.get("-r <filename>\n") + LocalString.get("\tThe file containing second input instances.\n") + LocalString.get("-s <filename>\n") + LocalString.get("\tThe file second output instances will be written to.\n") + LocalString.get("-c <class index>\n") + LocalString.get("\tThe number of the attribute to use as the class.\n") + LocalString.get("\t\"first\" and \"last\" are also valid entries.\n") + LocalString.get("\tIf not supplied then no class is assigned.\n");
            throw new Exception('\n' + exception.getMessage() + string + (String)object);
        }
        boolean bl = false;
        if (filter.setInputFormat(instances)) {
            printWriter.println(filter.getOutputFormat().toString());
            bl = true;
        }
        while (instances.readInstance(bufferedReader)) {
            if (filter.input(instances.instance(0))) {
                if (!bl) {
                    throw new Error(LocalString.get("Filter didn't return true from setInputFormat() ") + "earlier!");
                }
                printWriter.println(filter.output().toString());
            }
            instances.delete(0);
        }
        if (filter.batchFinished()) {
            if (!bl) {
                printWriter.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                printWriter.println(filter.output().toString());
            }
        }
        if (printWriter != null) {
            printWriter.close();
        }
        bl = false;
        if (filter.isOutputFormatDefined()) {
            printWriter2.println(filter.getOutputFormat().toString());
            bl = true;
        }
        while (instances2.readInstance(bufferedReader2)) {
            if (filter.input(instances2.instance(0))) {
                if (!bl) {
                    throw new Error(LocalString.get("Filter didn't return true from") + LocalString.get(" isOutputFormatDefined() earlier!"));
                }
                printWriter2.println(filter.output().toString());
            }
            instances2.delete(0);
        }
        if (filter.batchFinished()) {
            if (!bl) {
                printWriter2.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                printWriter2.println(filter.output().toString());
            }
        }
        if (printWriter2 != null) {
            printWriter2.close();
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception(LocalString.get("First argument must be the class name of a Filter"));
            }
            String string = stringArray[0];
            Filter filter = (Filter)Class.forName(string).newInstance();
            stringArray[0] = "";
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(filter, stringArray);
            } else {
                Filter.filterFile(filter, stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

