/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class NominalToBinary
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    protected Range m_Columns = new Range();
    private int[][] m_Indices = null;
    private boolean m_Numeric = true;

    public NominalToBinary() {
        this.setAttributeIndices("first-last");
    }

    public String globalInfo() {
        return LocalString.get("Converts all nominal attributes into binary numeric attributes. An ") + LocalString.get("attribute with k values is transformed into k binary attributes if ") + LocalString.get("the class is nominal (using the one-attribute-per-value approach). ") + LocalString.get("Binary attributes are left binary.") + LocalString.get("If the class is numeric, you might want to use the supervised version of ") + LocalString.get("this filter.");
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_Columns.setUpper(instances.numAttributes() - 1);
        this.setOutputFormat();
        this.m_Indices = null;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tSets if binary attributes are to be coded as nominal ones."), "N", 0, "-N"));
        vector.addElement(new Option(LocalString.get("\tSpecifies list of columns to act on. First") + LocalString.get(" and last are valid indexes.\n") + LocalString.get("\t(default: first-last)"), "R", 1, LocalString.get("-R <col1,col2-col4,...>")));
        vector.addElement(new Option(LocalString.get("\tInvert matching sense of column indexes."), "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setBinaryAttributesNominal(Utils.getFlag('N', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        if (this.getBinaryAttributesNominal()) {
            stringArray[n++] = "-N";
        }
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String binaryAttributesNominalTipText() {
        return LocalString.get("Whether resulting binary attributes will be nominal.");
    }

    public boolean getBinaryAttributesNominal() {
        return !this.m_Numeric;
    }

    public void setBinaryAttributesNominal(boolean bl) {
        this.m_Numeric = !bl;
    }

    public String invertSelectionTipText() {
        return LocalString.get("Set attribute selection mode. If false, only selected") + LocalString.get(" (numeric) attributes in the range will be discretized; if") + LocalString.get(" true, only non-selected attributes will be discretized.");
    }

    public boolean getInvertSelection() {
        return this.m_Columns.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Columns.setInvert(bl);
    }

    public String attributeIndicesTipText() {
        return LocalString.get("Specify range of attributes to act on.") + LocalString.get(" This is a comma separated list of attribute indices, with") + LocalString.get(" \"first\" and \"last\" valid values. Specify an inclusive") + LocalString.get(" range with \"-\". E.g: \"first-3,5,6-10,last\".");
    }

    public String getAttributeIndices() {
        return this.m_Columns.getRanges();
    }

    public void setAttributeIndices(String string) {
        this.m_Columns.setRanges(string);
    }

    private void setOutputFormat() {
        int n = this.getInputFormat().classIndex();
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!attribute.isNominal() || i == this.getInputFormat().classIndex() || !this.m_Columns.isInRange(i)) {
                fastVector.addElement(attribute.copy());
                continue;
            }
            if (attribute.numValues() <= 2) {
                if (this.m_Numeric) {
                    fastVector.addElement(new Attribute(attribute.name()));
                    continue;
                }
                fastVector.addElement(attribute.copy());
                continue;
            }
            if (n >= 0 && i < this.getInputFormat().classIndex()) {
                n += attribute.numValues() - 1;
            }
            for (int j = 0; j < attribute.numValues(); ++j) {
                StringBuffer stringBuffer = new StringBuffer(attribute.name() + "=");
                stringBuffer.append(attribute.value(j));
                if (this.m_Numeric) {
                    fastVector.addElement(new Attribute(stringBuffer.toString()));
                    continue;
                }
                FastVector fastVector2 = new FastVector(2);
                fastVector2.addElement("f");
                fastVector2.addElement("t");
                fastVector.addElement(new Attribute(stringBuffer.toString(), fastVector2));
            }
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(n);
        this.setOutputFormat(instances);
    }

    private void convertInstance(Instance instance) {
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        int n = 0;
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            int n2;
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!attribute.isNominal() || i == this.getInputFormat().classIndex() || !this.m_Columns.isInRange(i)) {
                dArray[n] = instance.value(i);
                ++n;
                continue;
            }
            if (attribute.numValues() <= 2) {
                dArray[n] = instance.value(i);
                ++n;
                continue;
            }
            if (instance.isMissing(i)) {
                for (n2 = 0; n2 < attribute.numValues(); ++n2) {
                    dArray[n + n2] = instance.value(i);
                }
            } else {
                for (n2 = 0; n2 < attribute.numValues(); ++n2) {
                    dArray[n + n2] = n2 == (int)instance.value(i) ? 1.0 : 0.0;
                }
            }
            n += attribute.numValues();
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.getInputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new NominalToBinary(), stringArray);
            } else {
                Filter.filterFile(new NominalToBinary(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

