/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.LocalString;
import weka.core.Instances;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffSaver;
import weka.core.converters.CSVSaver;
import weka.gui.ComponentHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.JTableHelper;
import weka.gui.ListSelectorDialog;
import weka.gui.arffviewer.ArffPanel;
import weka.gui.arffviewer.ArffTable;
import weka.gui.arffviewer.ArffTableSorter;
import weka.gui.arffviewer.FileChooser;

public class ArffViewerMainPanel
extends JPanel
implements ActionListener,
ChangeListener {
    public static final int DEFAULT_WIDTH = -1;
    public static final int DEFAULT_HEIGHT = -1;
    public static final int DEFAULT_LEFT = -1;
    public static final int DEFAULT_TOP = -1;
    public static final int WIDTH = 800;
    public static final int HEIGHT = 600;
    protected JFrame parent;
    protected JTabbedPane tabbedPane;
    protected JMenuBar menuBar;
    protected JMenu menuFile;
    protected JMenuItem menuFileOpen;
    protected JMenuItem menuFileSave;
    protected JMenuItem menuFileSaveAs;
    protected JMenuItem menuFileClose;
    protected JMenuItem menuFileCloseAll;
    protected JMenuItem menuFileProperties;
    protected JMenuItem menuFileExit;
    protected JMenu menuEdit;
    protected JMenuItem menuEditUndo;
    protected JMenuItem menuEditCopy;
    protected JMenuItem menuEditSearch;
    protected JMenuItem menuEditClearSearch;
    protected JMenuItem menuEditDeleteAttribute;
    protected JMenuItem menuEditDeleteAttributes;
    protected JMenuItem menuEditRenameAttribute;
    protected JMenuItem menuEditDeleteInstance;
    protected JMenuItem menuEditDeleteInstances;
    protected JMenuItem menuEditSortInstances;
    protected JMenu menuView;
    protected JMenuItem menuViewAttributes;
    protected JMenuItem menuViewValues;
    protected FileChooser fileChooser;
    protected ExtensionFileFilter arffFilter;
    protected ExtensionFileFilter csvFilter;
    protected String frameTitle;
    protected boolean confirmExit;
    protected int width;
    protected int height;
    protected int top;
    protected int left;
    protected boolean exitOnClose;

    public ArffViewerMainPanel(JFrame jFrame) {
        this.parent = jFrame;
        this.frameTitle = "ARFF-Viewer";
        this.createPanel();
    }

    protected void createPanel() {
        this.setSize(800, 600);
        this.setConfirmExit(false);
        this.setLayout(new BorderLayout());
        this.arffFilter = new ExtensionFileFilter("arff", "ARFF-Files");
        this.csvFilter = new ExtensionFileFilter("csv", "CSV-File");
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.addChoosableFileFilter(this.arffFilter);
        this.fileChooser.addChoosableFileFilter(this.csvFilter);
        this.fileChooser.setFileFilter(this.arffFilter);
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuFileOpen = new JMenuItem("Open...", ComponentHelper.getImageIcon("open.gif"));
        this.menuFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.menuFileOpen.addActionListener(this);
        this.menuFileSave = new JMenuItem("Save", ComponentHelper.getImageIcon("save.gif"));
        this.menuFileSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuFileSave.addActionListener(this);
        this.menuFileSaveAs = new JMenuItem(LocalString.get("Save as..."), ComponentHelper.getImageIcon("empty.gif"));
        this.menuFileSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.menuFileSaveAs.addActionListener(this);
        this.menuFileClose = new JMenuItem("Close", ComponentHelper.getImageIcon("empty.gif"));
        this.menuFileClose.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.menuFileClose.addActionListener(this);
        this.menuFileCloseAll = new JMenuItem(LocalString.get("Close all"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuFileCloseAll.addActionListener(this);
        this.menuFileProperties = new JMenuItem("Properties", ComponentHelper.getImageIcon("empty.gif"));
        this.menuFileProperties.setAccelerator(KeyStroke.getKeyStroke(10, 2));
        this.menuFileProperties.addActionListener(this);
        this.menuFileExit = new JMenuItem("Exit", ComponentHelper.getImageIcon("forward.gif"));
        this.menuFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.menuFileExit.addActionListener(this);
        this.menuFile.add(this.menuFileOpen);
        this.menuFile.add(this.menuFileSave);
        this.menuFile.add(this.menuFileSaveAs);
        this.menuFile.add(this.menuFileClose);
        this.menuFile.add(this.menuFileCloseAll);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileProperties);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuBar.add(this.menuFile);
        this.menuEdit = new JMenu("Edit");
        this.menuEditUndo = new JMenuItem("Undo", ComponentHelper.getImageIcon("undo.gif"));
        this.menuEditUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.menuEditUndo.addActionListener(this);
        this.menuEditCopy = new JMenuItem("Copy", ComponentHelper.getImageIcon("copy.gif"));
        this.menuEditCopy.setAccelerator(KeyStroke.getKeyStroke(155, 2));
        this.menuEditCopy.addActionListener(this);
        this.menuEditSearch = new JMenuItem("Search...", ComponentHelper.getImageIcon("find.gif"));
        this.menuEditSearch.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.menuEditSearch.addActionListener(this);
        this.menuEditClearSearch = new JMenuItem(LocalString.get("Clear search"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditClearSearch.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.menuEditClearSearch.addActionListener(this);
        this.menuEditRenameAttribute = new JMenuItem(LocalString.get("Rename attribute"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditRenameAttribute.addActionListener(this);
        this.menuEditDeleteAttribute = new JMenuItem(LocalString.get("Delete attribute"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditDeleteAttribute.addActionListener(this);
        this.menuEditDeleteAttributes = new JMenuItem(LocalString.get("Delete attributes"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditDeleteAttributes.addActionListener(this);
        this.menuEditDeleteInstance = new JMenuItem(LocalString.get("Delete instance"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditDeleteInstance.addActionListener(this);
        this.menuEditDeleteInstances = new JMenuItem(LocalString.get("Delete instances"), ComponentHelper.getImageIcon("empty.gif"));
        this.menuEditDeleteInstances.addActionListener(this);
        this.menuEditSortInstances = new JMenuItem(LocalString.get("Sort data (ascending)"), ComponentHelper.getImageIcon("sort.gif"));
        this.menuEditSortInstances.addActionListener(this);
        this.menuEdit.add(this.menuEditUndo);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditCopy);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditSearch);
        this.menuEdit.add(this.menuEditClearSearch);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditRenameAttribute);
        this.menuEdit.add(this.menuEditDeleteAttribute);
        this.menuEdit.add(this.menuEditDeleteAttributes);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuEditDeleteInstance);
        this.menuEdit.add(this.menuEditDeleteInstances);
        this.menuEdit.add(this.menuEditSortInstances);
        this.menuBar.add(this.menuEdit);
        this.menuView = new JMenu("View");
        this.menuViewAttributes = new JMenuItem("Attributes...", ComponentHelper.getImageIcon("objects.gif"));
        this.menuViewAttributes.setAccelerator(KeyStroke.getKeyStroke(65, 3));
        this.menuViewAttributes.addActionListener(this);
        this.menuViewValues = new JMenuItem("Values...", ComponentHelper.getImageIcon("properties.gif"));
        this.menuViewValues.setAccelerator(KeyStroke.getKeyStroke(86, 3));
        this.menuViewValues.addActionListener(this);
        this.menuView.add(this.menuViewAttributes);
        this.menuView.add(this.menuViewValues);
        this.menuBar.add(this.menuView);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.add((Component)this.tabbedPane, "Center");
        this.updateMenu();
        this.updateFrameTitle();
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setConfirmExit(boolean bl) {
        this.confirmExit = bl;
    }

    public boolean getConfirmExit() {
        return this.confirmExit;
    }

    public void setExitOnClose(boolean bl) {
        this.exitOnClose = bl;
    }

    public boolean getExitOnClose() {
        return this.exitOnClose;
    }

    public void refresh() {
        this.validate();
        this.repaint();
    }

    public String getFrameTitle() {
        if (this.getCurrentFilename().equals("")) {
            return this.frameTitle;
        }
        return this.frameTitle + " - " + this.getCurrentFilename();
    }

    public void updateFrameTitle() {
        if (this.parent != null) {
            this.parent.setTitle(this.getFrameTitle());
        }
    }

    protected void updateMenu() {
        boolean bl = this.getCurrentPanel() != null;
        boolean bl2 = bl && this.getCurrentPanel().isChanged();
        boolean bl3 = bl && this.getCurrentPanel().canUndo();
        this.menuFileOpen.setEnabled(true);
        this.menuFileSave.setEnabled(bl2);
        this.menuFileSaveAs.setEnabled(bl);
        this.menuFileClose.setEnabled(bl);
        this.menuFileCloseAll.setEnabled(bl);
        this.menuFileProperties.setEnabled(bl);
        this.menuFileExit.setEnabled(true);
        this.menuEditUndo.setEnabled(bl3);
        this.menuEditCopy.setEnabled(bl);
        this.menuEditSearch.setEnabled(bl);
        this.menuEditClearSearch.setEnabled(bl);
        this.menuEditRenameAttribute.setEnabled(bl);
        this.menuEditDeleteAttribute.setEnabled(bl);
        this.menuEditDeleteAttributes.setEnabled(bl);
        this.menuEditDeleteInstance.setEnabled(bl);
        this.menuEditDeleteInstances.setEnabled(bl);
        this.menuEditSortInstances.setEnabled(bl);
        this.menuViewAttributes.setEnabled(bl);
        this.menuViewValues.setEnabled(bl);
    }

    protected void setTabTitle(JComponent jComponent) {
        if (!(jComponent instanceof ArffPanel)) {
            return;
        }
        int n = this.tabbedPane.indexOfComponent(jComponent);
        if (n == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(n, ((ArffPanel)jComponent).getTitle());
        this.updateFrameTitle();
    }

    public int getPanelCount() {
        return this.tabbedPane.getTabCount();
    }

    public ArffPanel getPanel(int n) {
        if (n >= 0 && n < this.getPanelCount()) {
            return (ArffPanel)this.tabbedPane.getComponentAt(n);
        }
        return null;
    }

    public int getCurrentIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public ArffPanel getCurrentPanel() {
        return this.getPanel(this.getCurrentIndex());
    }

    public boolean isPanelSelected() {
        return this.getCurrentPanel() != null;
    }

    public String getFilename(int n) {
        String string = "";
        ArffPanel arffPanel = this.getPanel(n);
        if (arffPanel != null) {
            string = arffPanel.getFilename();
        }
        return string;
    }

    public String getCurrentFilename() {
        return this.getFilename(this.getCurrentIndex());
    }

    public void setFilename(int n, String string) {
        ArffPanel arffPanel = this.getPanel(n);
        if (arffPanel != null) {
            arffPanel.setFilename(string);
            this.setTabTitle(arffPanel);
        }
    }

    public void setCurrentFilename(String string) {
        this.setFilename(this.getCurrentIndex(), string);
    }

    protected boolean saveChanges() {
        return this.saveChanges(true);
    }

    protected boolean saveChanges(boolean bl) {
        boolean bl2;
        if (!this.isPanelSelected()) {
            return true;
        }
        boolean bl3 = bl2 = !this.getCurrentPanel().isChanged();
        if (this.getCurrentPanel().isChanged()) {
            int n;
            try {
                n = bl ? ComponentHelper.showMessageBox(this, "Changed", LocalString.get("The file is not saved - Do you want to save it?"), 1, 3) : ComponentHelper.showMessageBox(this, "Changed", LocalString.get("The file is not saved - Do you want to save it?"), 0, 3);
            }
            catch (Exception exception) {
                n = 2;
            }
            switch (n) {
                case 0: {
                    this.saveFile();
                    bl2 = !this.getCurrentPanel().isChanged();
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    public void loadFile(String string) {
        ArffPanel arffPanel = new ArffPanel(string);
        arffPanel.addChangeListener(this);
        this.tabbedPane.addTab(arffPanel.getTitle(), arffPanel);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    public void loadFile() {
        int n = this.fileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < this.fileChooser.getSelectedFiles().length; ++i) {
            String string = this.fileChooser.getSelectedFiles()[i].getAbsolutePath();
            this.loadFile(string);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void saveFile() {
        ArffPanel arffPanel = this.getCurrentPanel();
        if (arffPanel == null) {
            return;
        }
        String string = arffPanel.getFilename();
        if (string.equals("Instances")) {
            this.saveFileAs();
        } else {
            AbstractFileSaver abstractFileSaver = this.fileChooser.getFileFilter() == this.arffFilter ? new ArffSaver() : (this.fileChooser.getFileFilter() == this.csvFilter ? new CSVSaver() : null);
            if (abstractFileSaver != null) {
                try {
                    abstractFileSaver.setRetrieval(1);
                    abstractFileSaver.setInstances(arffPanel.getInstances());
                    ((AbstractSaver)abstractFileSaver).setFile(this.fileChooser.getSelectedFile());
                    ((AbstractSaver)abstractFileSaver).setDestination(this.fileChooser.getSelectedFile());
                    abstractFileSaver.writeBatch();
                    arffPanel.setChanged(false);
                    this.setCurrentFilename(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void saveFileAs() {
        int n;
        ArffPanel arffPanel = this.getCurrentPanel();
        if (arffPanel == null) {
            System.out.println(LocalString.get("nothing selected!"));
            return;
        }
        if (!this.getCurrentFilename().equals("")) {
            try {
                this.fileChooser.setSelectedFile(new File(this.getCurrentFilename()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = this.fileChooser.showSaveDialog(this)) != 0) {
            return;
        }
        arffPanel.setChanged(false);
        this.setCurrentFilename(this.fileChooser.getSelectedFile().getAbsolutePath());
        this.saveFile();
    }

    public void closeFile() {
        this.closeFile(true);
    }

    public void closeFile(boolean bl) {
        if (this.getCurrentIndex() == -1) {
            return;
        }
        if (!this.saveChanges(bl)) {
            return;
        }
        this.tabbedPane.removeTabAt(this.getCurrentIndex());
        this.updateFrameTitle();
        System.gc();
    }

    public void closeAllFiles() {
        while (this.tabbedPane.getTabCount() > 0) {
            if (!this.saveChanges(true)) {
                return;
            }
            this.tabbedPane.removeTabAt(this.getCurrentIndex());
            this.updateFrameTitle();
            System.gc();
        }
    }

    public void showProperties() {
        ArffPanel arffPanel = this.getCurrentPanel();
        if (arffPanel == null) {
            return;
        }
        Instances instances = arffPanel.getInstances();
        if (instances == null) {
            return;
        }
        if (instances.classIndex() < 0) {
            instances.setClassIndex(instances.numAttributes() - 1);
        }
        Vector<String> vector = new Vector<String>();
        vector.add(LocalString.get("Filename: ") + arffPanel.getFilename());
        vector.add(LocalString.get("Relation name: ") + instances.relationName());
        vector.add(LocalString.get("# of instances: ") + instances.numInstances());
        vector.add(LocalString.get("# of attributes: ") + instances.numAttributes());
        vector.add(LocalString.get("Class attribute: ") + instances.classAttribute().name());
        vector.add(LocalString.get("# of class labels: ") + instances.numClasses());
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog((Frame)this.parent, new JList(vector));
        listSelectorDialog.showDialog();
    }

    public void close() {
        if (this.parent != null && this.parent instanceof WindowListener) {
            ((WindowListener)((Object)this.parent)).windowClosing(null);
        }
    }

    public void undo() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().undo();
    }

    public void copyContent() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().copyContent();
    }

    public void search() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().search();
    }

    public void clearSearch() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().clearSearch();
    }

    public void renameAttribute() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().renameAttribute();
    }

    public void deleteAttribute(boolean bl) {
        if (!this.isPanelSelected()) {
            return;
        }
        if (bl) {
            this.getCurrentPanel().deleteAttributes();
        } else {
            this.getCurrentPanel().deleteAttribute();
        }
    }

    public void deleteInstance(boolean bl) {
        if (!this.isPanelSelected()) {
            return;
        }
        if (bl) {
            this.getCurrentPanel().deleteInstances();
        } else {
            this.getCurrentPanel().deleteInstance();
        }
    }

    public void sortInstances() {
        if (!this.isPanelSelected()) {
            return;
        }
        this.getCurrentPanel().sortInstances();
    }

    public String showAttributes() {
        if (!this.isPanelSelected()) {
            return null;
        }
        JList jList = new JList(this.getCurrentPanel().getAttributes());
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog((Frame)this.parent, jList);
        int n = listSelectorDialog.showDialog();
        if (n == 0) {
            ArffTableSorter arffTableSorter = (ArffTableSorter)this.getCurrentPanel().getTable().getModel();
            String string = jList.getSelectedValue().toString();
            int n2 = arffTableSorter.getAttributeColumn(string);
            JTableHelper.scrollToVisible(this.getCurrentPanel().getTable(), 0, n2);
            this.getCurrentPanel().getTable().setSelectedColumn(n2);
            return string;
        }
        return null;
    }

    public void showValues() {
        int n;
        String string = this.showAttributes();
        if (string == null) {
            return;
        }
        ArffTable arffTable = this.getCurrentPanel().getTable();
        ArffTableSorter arffTableSorter = (ArffTableSorter)arffTable.getModel();
        int n2 = -1;
        for (n = 0; n < arffTable.getColumnCount(); ++n) {
            if (!arffTable.getPlainColumnName(n).equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Vector vector = new Vector();
        for (n = 0; n < arffTableSorter.getRowCount(); ++n) {
            hashSet.add(arffTableSorter.getValueAt(n, n2).toString());
        }
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        Collections.sort(vector);
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog((Frame)this.parent, new JList(vector));
        listSelectorDialog.showDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.menuFileOpen) {
            this.loadFile();
        } else if (object == this.menuFileSave) {
            this.saveFile();
        } else if (object == this.menuFileSaveAs) {
            this.saveFileAs();
        } else if (object == this.menuFileClose) {
            this.closeFile();
        } else if (object == this.menuFileCloseAll) {
            this.closeAllFiles();
        } else if (object == this.menuFileProperties) {
            this.showProperties();
        } else if (object == this.menuFileExit) {
            this.close();
        } else if (object == this.menuEditUndo) {
            this.undo();
        } else if (object == this.menuEditCopy) {
            this.copyContent();
        } else if (object == this.menuEditSearch) {
            this.search();
        } else if (object == this.menuEditClearSearch) {
            this.clearSearch();
        } else if (object == this.menuEditDeleteAttribute) {
            this.deleteAttribute(false);
        } else if (object == this.menuEditDeleteAttributes) {
            this.deleteAttribute(true);
        } else if (object == this.menuEditRenameAttribute) {
            this.renameAttribute();
        } else if (object == this.menuEditDeleteInstance) {
            this.deleteInstance(false);
        } else if (object == this.menuEditDeleteInstances) {
            this.deleteInstance(true);
        } else if (object == this.menuEditSortInstances) {
            this.sortInstances();
        } else if (object == this.menuViewAttributes) {
            this.showAttributes();
        } else if (object == this.menuViewValues) {
            this.showValues();
        }
        this.updateMenu();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateFrameTitle();
        this.updateMenu();
        if (changeEvent.getSource() instanceof JComponent) {
            this.setTabTitle((JComponent)changeEvent.getSource());
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

