/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.LocalString;
import weka.clusterers.EM;
import weka.core.Drawable;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.Logger;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Clusterer
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
EventConstraints,
Serializable,
UserRequestAcceptor,
TrainingSetListener,
TestSetListener {
    protected BeanVisual m_visual = new BeanVisual("Clusterer", "weka/gui/beans/icons/EM.gif", "weka/gui/beans/icons/EM_animated.gif");
    private static int IDLE = 0;
    private static int BUILDING_MODEL = 1;
    private static int CLUSTERING = 2;
    private int m_state = IDLE;
    private Thread m_buildThread = null;
    protected String m_globalInfo;
    private Hashtable m_listenees = new Hashtable();
    private Vector m_batchClustererListeners = new Vector();
    private Vector m_graphListeners = new Vector();
    private Vector m_textListeners = new Vector();
    private Instances m_trainingSet;
    private transient Instances m_testingSet;
    private weka.clusterers.Clusterer m_Clusterer = new EM();
    private transient Logger m_log = null;
    private Double m_dummy = new Double(0.0);

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Clusterer() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setClusterer(this.m_Clusterer);
    }

    public void setClusterer(weka.clusterers.Clusterer clusterer) {
        boolean bl = true;
        if (clusterer.getClass().getName().compareTo(this.m_Clusterer.getClass().getName()) == 0) {
            bl = false;
        } else {
            this.m_trainingSet = null;
        }
        this.m_Clusterer = clusterer;
        String string = clusterer.getClass().toString();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (bl && !this.m_visual.loadIcons("weka/gui/beans/icons/" + string + ".gif", "weka/gui/beans/icons/" + string + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(string);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Clusterer);
    }

    public boolean hasIncomingBatchInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("trainingSet") || this.m_listenees.containsKey("testSet") || this.m_listenees.containsKey("dataSet");
    }

    public weka.clusterers.Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    public void setWrappedAlgorithm(Object object) {
        if (!(object instanceof weka.clusterers.Clusterer)) {
            throw new IllegalArgumentException(object.getClass() + LocalString.get(" : incorrect ") + LocalString.get("type of algorithm (Clusterer)"));
        }
        this.setClusterer((weka.clusterers.Clusterer)object);
    }

    public Object getWrappedAlgorithm() {
        return this.getClusterer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptTrainingSet(final TrainingSetEvent trainingSetEvent) {
        block7: {
            if (trainingSetEvent.isStructureOnly()) {
                BatchClustererEvent batchClustererEvent = new BatchClustererEvent(this, this.m_Clusterer, new DataSetEvent(this, trainingSetEvent.getTrainingSet()), trainingSetEvent.getSetNumber(), trainingSetEvent.getMaxSetNumber(), 1);
                this.notifyBatchClustererListeners(batchClustererEvent);
                return;
            }
            if (this.m_buildThread == null) {
                try {
                    if (this.m_state != IDLE) break block7;
                    Object object = this;
                    synchronized (object) {
                        this.m_state = BUILDING_MODEL;
                    }
                    this.m_trainingSet = trainingSetEvent.getTrainingSet();
                    object = this.m_visual.getText();
                    this.m_buildThread = new Thread((String)object){
                        final /* synthetic */ String val$oldText;
                        {
                            this.val$oldText = string;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                block19: {
                                    try {
                                        Object object;
                                        Object object2;
                                        if (Clusterer.this.m_trainingSet == null) break block19;
                                        Clusterer.this.m_visual.setAnimated();
                                        Clusterer.this.m_visual.setText(LocalString.get("Building clusters..."));
                                        if (Clusterer.this.m_log != null) {
                                            Clusterer.this.m_log.statusMessage(LocalString.get("Clusterer : building clusters..."));
                                        }
                                        Clusterer.this.buildClusterer();
                                        if (Clusterer.this.m_batchClustererListeners.size() > 0) {
                                            object2 = new BatchClustererEvent(this, Clusterer.this.m_Clusterer, new DataSetEvent(this, trainingSetEvent.getTrainingSet()), trainingSetEvent.getSetNumber(), trainingSetEvent.getMaxSetNumber(), 1);
                                            Clusterer.this.notifyBatchClustererListeners((BatchClustererEvent)object2);
                                        }
                                        if (Clusterer.this.m_Clusterer instanceof Drawable && Clusterer.this.m_graphListeners.size() > 0) {
                                            object2 = ((Drawable)((Object)Clusterer.this.m_Clusterer)).graph();
                                            int n = ((Drawable)((Object)Clusterer.this.m_Clusterer)).graphType();
                                            object = Clusterer.this.m_Clusterer.getClass().getName();
                                            object = ((String)object).substring(((String)object).lastIndexOf(46) + 1, ((String)object).length());
                                            object = LocalString.get("Set ") + trainingSetEvent.getSetNumber() + " (" + trainingSetEvent.getTrainingSet().relationName() + ") " + (String)object;
                                            GraphEvent graphEvent = new GraphEvent(Clusterer.this, (String)object2, (String)object, n);
                                            Clusterer.this.notifyGraphListeners(graphEvent);
                                        }
                                        if (Clusterer.this.m_textListeners.size() <= 0) break block19;
                                        object2 = Clusterer.this.m_Clusterer.toString();
                                        String string = Clusterer.this.m_Clusterer.getClass().getName();
                                        string = string.substring(string.lastIndexOf(46) + 1, string.length());
                                        object2 = LocalString.get("=== Clusterer model ===\n\n") + LocalString.get("Scheme:   ") + string + "\n" + LocalString.get("Relation: ") + Clusterer.this.m_trainingSet.relationName() + (trainingSetEvent.getMaxSetNumber() > 1 ? LocalString.get("\nTraining Fold: ") + trainingSetEvent.getSetNumber() : "") + "\n\n" + (String)object2;
                                        string = LocalString.get("Model: ") + string;
                                        object = new TextEvent(Clusterer.this, (String)object2, string);
                                        Clusterer.this.notifyTextListeners((TextEvent)object);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        Object var6_8 = null;
                                        Clusterer.this.m_visual.setText(this.val$oldText);
                                        Clusterer.this.m_visual.setStatic();
                                        Clusterer.this.m_state = IDLE;
                                        if (this.isInterrupted()) {
                                            Clusterer.this.m_trainingSet = null;
                                            if (Clusterer.this.m_log != null) {
                                                Clusterer.this.m_log.logMessage(LocalString.get("Build clusterer interrupted!"));
                                                Clusterer.this.m_log.statusMessage("OK");
                                            }
                                        } else {
                                            Clusterer.this.m_trainingSet = new Instances(Clusterer.this.m_trainingSet, 0);
                                        }
                                        if (Clusterer.this.m_log != null) {
                                            Clusterer.this.m_log.statusMessage("OK");
                                        }
                                        Clusterer.this.block(false);
                                        return;
                                    }
                                }
                                Object var6_7 = null;
                                Clusterer.this.m_visual.setText(this.val$oldText);
                                Clusterer.this.m_visual.setStatic();
                                Clusterer.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Clusterer.this.m_trainingSet = null;
                                    if (Clusterer.this.m_log != null) {
                                        Clusterer.this.m_log.logMessage(LocalString.get("Build clusterer interrupted!"));
                                        Clusterer.this.m_log.statusMessage("OK");
                                    }
                                } else {
                                    Clusterer.this.m_trainingSet = new Instances(Clusterer.this.m_trainingSet, 0);
                                }
                                if (Clusterer.this.m_log != null) {
                                    Clusterer.this.m_log.statusMessage("OK");
                                }
                                Clusterer.this.block(false);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var6_9 = null;
                                Clusterer.this.m_visual.setText(this.val$oldText);
                                Clusterer.this.m_visual.setStatic();
                                Clusterer.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    Clusterer.this.m_trainingSet = null;
                                    if (Clusterer.this.m_log != null) {
                                        Clusterer.this.m_log.logMessage(LocalString.get("Build clusterer interrupted!"));
                                        Clusterer.this.m_log.statusMessage("OK");
                                    }
                                } else {
                                    Clusterer.this.m_trainingSet = new Instances(Clusterer.this.m_trainingSet, 0);
                                }
                                if (Clusterer.this.m_log != null) {
                                    Clusterer.this.m_log.statusMessage("OK");
                                }
                                Clusterer.this.block(false);
                                throw throwable;
                            }
                        }
                    };
                    this.m_buildThread.setPriority(1);
                    this.m_buildThread.start();
                    this.block(true);
                    this.m_buildThread = null;
                    this.m_state = IDLE;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptTestSet(TestSetEvent testSetEvent) {
        block7: {
            if (this.m_trainingSet != null) {
                try {
                    if (this.m_state != IDLE) break block7;
                    Serializable serializable = this;
                    synchronized (serializable) {
                        this.m_state = CLUSTERING;
                    }
                    this.m_testingSet = testSetEvent.getTestSet();
                    if (this.m_trainingSet.equalHeaders(this.m_testingSet)) {
                        serializable = new BatchClustererEvent(this, this.m_Clusterer, new DataSetEvent(this, testSetEvent.getTestSet()), testSetEvent.getSetNumber(), testSetEvent.getMaxSetNumber(), 0);
                        this.notifyBatchClustererListeners((BatchClustererEvent)serializable);
                    }
                    this.m_state = IDLE;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void buildClusterer() throws Exception {
        if (this.m_trainingSet.classIndex() < 0) {
            this.m_Clusterer.buildClusterer(this.m_trainingSet);
        } else {
            Remove remove = new Remove();
            remove.setAttributeIndices("" + (this.m_trainingSet.classIndex() + 1));
            remove.setInvertSelection(false);
            remove.setInputFormat(this.m_trainingSet);
            Instances instances = Filter.useFilter(this.m_trainingSet, remove);
            this.m_Clusterer.buildClusterer(instances);
        }
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultClusterer.gif", "weka/gui/beans/icons/DefaultClusterer_animated.gif");
    }

    public synchronized void addBatchClustererListener(BatchClustererListener batchClustererListener) {
        this.m_batchClustererListeners.addElement(batchClustererListener);
    }

    public synchronized void removeBatchClustererListener(BatchClustererListener batchClustererListener) {
        this.m_batchClustererListeners.remove(batchClustererListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatchClustererListeners(BatchClustererEvent batchClustererEvent) {
        Vector vector;
        Clusterer clusterer = this;
        synchronized (clusterer) {
            vector = (Vector)this.m_batchClustererListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((BatchClustererListener)vector.elementAt(i)).acceptClusterer(batchClustererEvent);
            }
        }
    }

    public synchronized void addGraphListener(GraphListener graphListener) {
        this.m_graphListeners.addElement(graphListener);
    }

    public synchronized void removeGraphListener(GraphListener graphListener) {
        this.m_graphListeners.remove(graphListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphListeners(GraphEvent graphEvent) {
        Vector vector;
        Clusterer clusterer = this;
        synchronized (clusterer) {
            vector = (Vector)this.m_graphListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((GraphListener)vector.elementAt(i)).acceptGraph(graphEvent);
            }
        }
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.m_textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.m_textListeners.remove(textListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent textEvent) {
        Vector vector;
        Clusterer clusterer = this;
        synchronized (clusterer) {
            vector = (Vector)this.m_textListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TextListener)vector.elementAt(i)).acceptText(textEvent);
            }
        }
    }

    public boolean connectionAllowed(String string) {
        return !this.m_listenees.containsKey(string);
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string)) {
            this.m_listenees.put(string, object);
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        this.m_listenees.remove(string);
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_buildThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public void stop() {
        Enumeration enumeration = this.m_listenees.keys();
        while (enumeration.hasMoreElements()) {
            Object v = this.m_listenees.get(enumeration.nextElement());
            if (!(v instanceof BeanCommon)) continue;
            System.err.println(LocalString.get("Listener is BeanCommon"));
            ((BeanCommon)v).stop();
        }
        if (this.m_buildThread != null) {
            this.m_buildThread.interrupt();
            this.m_buildThread.stop();
            this.m_buildThread = null;
            this.m_visual.setStatic();
        }
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_buildThread != null) {
            vector.addElement("Stop");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(string + LocalString.get(" not supported (Classifier)"));
        }
        this.stop();
    }

    public boolean eventGeneratable(EventSetDescriptor eventSetDescriptor) {
        String string = eventSetDescriptor.getName();
        return this.eventGeneratable(string);
    }

    public boolean eventGeneratable(String string) {
        Object v;
        if (string.compareTo("graph") == 0) {
            if (!(this.m_Clusterer instanceof Drawable)) {
                return false;
            }
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("trainingSet");
            if (v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (string.compareTo("batchClusterer") == 0) {
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("trainingSet");
            if (v != null && v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (string.compareTo("text") == 0) {
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("trainingSet");
            if (v != null && v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (string.compareTo("batchClassifier") == 0) {
            return false;
        }
        return string.compareTo("incrementalClassifier") != 0;
    }
}

