/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans.xml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.beancontext.BeanContextSupport;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weka.LocalString;
import weka.core.converters.AbstractLoader;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.core.converters.C45Loader;
import weka.core.converters.C45Saver;
import weka.core.converters.CSVLoader;
import weka.core.converters.CSVSaver;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.DatabaseSaver;
import weka.core.converters.SerializedInstancesLoader;
import weka.core.converters.SerializedInstancesSaver;
import weka.core.xml.XMLBasicSerialization;
import weka.core.xml.XMLDocument;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;
import weka.gui.beans.BeanConnection;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.Classifier;
import weka.gui.beans.Clusterer;
import weka.gui.beans.Filter;
import weka.gui.beans.Loader;
import weka.gui.beans.MetaBean;
import weka.gui.beans.Saver;
import weka.gui.beans.Visible;

public class XMLBeans
extends XMLBasicSerialization {
    public static final String VAL_ID = "id";
    public static final String VAL_X = "x";
    public static final String VAL_Y = "y";
    public static final String VAL_BEAN = "bean";
    public static final String VAL_SOURCEID = "source_id";
    public static final String VAL_TARGETID = "target_id";
    public static final String VAL_EVENTNAME = "eventname";
    public static final String VAL_HIDDEN = "hidden";
    public static final String VAL_FILE = "file";
    public static final String VAL_OPTIONS = "options";
    public static final String VAL_SAVER = "saver";
    public static final String VAL_LOADER = "loader";
    public static final String VAL_TEXT = "text";
    public static final String VAL_BEANCONTEXT = "beanContext";
    public static final String VAL_WIDTH = "width";
    public static final String VAL_HEIGHT = "height";
    public static final String VAL_RED = "red";
    public static final String VAL_GREEN = "green";
    public static final String VAL_BLUE = "blue";
    public static final String VAL_NAME = "name";
    public static final String VAL_STYLE = "style";
    public static final String VAL_LOCATION = "location";
    public static final String VAL_SIZE = "size";
    public static final String VAL_COLOR = "color";
    public static final String VAL_FONT = "font";
    public static final String VAL_ICONPATH = "iconPath";
    public static final String VAL_ANIMATEDICONPATH = "animatedIconPath";
    public static final String VAL_ASSOCIATEDCONNECTIONS = "associatedConnections";
    public static final String VAL_INPUTS = "inputs";
    public static final String VAL_INPUTSID = "inputs_id";
    public static final String VAL_OUTPUTS = "outputs";
    public static final String VAL_OUTPUTSID = "outputs_id";
    public static final String VAL_SUBFLOW = "subFlow";
    public static final String VAL_ORIGINALCOORDS = "originalCoords";
    public static final int INDEX_BEANINSTANCES = 0;
    public static final int INDEX_BEANCONNECTIONS = 1;
    protected JComponent m_BeanLayout;
    protected Vector m_BeanInstances;
    protected Vector m_BeanInstancesID;
    protected boolean m_IgnoreBeanConnections;
    protected MetaBean m_CurrentMetaBean;
    protected static final String REGULAR_CONNECTION = "regular_connection";
    protected Hashtable m_BeanConnectionRelation;
    public static final int DATATYPE_LAYOUT = 0;
    public static final int DATATYPE_USERCOMPONENTS = 1;
    protected int m_DataType = 0;
    protected BeanContextSupport m_BeanContextSupport = null;

    public XMLBeans(JComponent jComponent, BeanContextSupport beanContextSupport) throws Exception {
        this(jComponent, beanContextSupport, 0);
    }

    public XMLBeans(JComponent jComponent, BeanContextSupport beanContextSupport, int n) throws Exception {
        this.m_BeanLayout = jComponent;
        this.m_BeanContextSupport = beanContextSupport;
        this.setDataType(n);
    }

    public void setDataType(int n) {
        if (n == 0) {
            this.m_DataType = n;
        } else if (n == 1) {
            this.m_DataType = n;
        } else {
            System.out.println(LocalString.get("DataType '") + n + LocalString.get("' is unknown!"));
        }
    }

    public int getDataType() {
        return this.m_DataType;
    }

    public void clear() throws Exception {
        super.clear();
        this.m_Properties.addIgnored("UI");
        this.m_Properties.addIgnored("actionMap");
        this.m_Properties.addIgnored("alignmentX");
        this.m_Properties.addIgnored("alignmentY");
        this.m_Properties.addIgnored("autoscrolls");
        this.m_Properties.addIgnored("background");
        this.m_Properties.addIgnored("border");
        this.m_Properties.addIgnored("componentPopupMenu");
        this.m_Properties.addIgnored("debugGraphicsOptions");
        this.m_Properties.addIgnored("doubleBuffered");
        this.m_Properties.addIgnored("enabled");
        this.m_Properties.addIgnored("focusCycleRoot");
        this.m_Properties.addIgnored("focusTraversalPolicy");
        this.m_Properties.addIgnored("focusTraversalPolicyProvider");
        this.m_Properties.addIgnored("focusable");
        this.m_Properties.addIgnored(VAL_FONT);
        this.m_Properties.addIgnored("foreground");
        this.m_Properties.addIgnored("inheritsPopupMenu");
        this.m_Properties.addIgnored("inputVerifier");
        this.m_Properties.addIgnored("layout");
        this.m_Properties.addIgnored("locale");
        this.m_Properties.addIgnored("maximumSize");
        this.m_Properties.addIgnored("minimumSize");
        this.m_Properties.addIgnored("nextFocusableComponent");
        this.m_Properties.addIgnored("opaque");
        this.m_Properties.addIgnored("preferredSize");
        this.m_Properties.addIgnored("requestFocusEnabled");
        this.m_Properties.addIgnored("toolTipText");
        this.m_Properties.addIgnored("transferHandler");
        this.m_Properties.addIgnored("verifyInputWhenFocusTarget");
        this.m_Properties.addIgnored("visible");
        this.m_Properties.addIgnored(VAL_SIZE);
        this.m_Properties.addIgnored(VAL_LOCATION);
        this.m_Properties.addAllowed(BeanInstance.class, VAL_X);
        this.m_Properties.addAllowed(BeanInstance.class, VAL_Y);
        this.m_Properties.addAllowed(BeanInstance.class, VAL_BEAN);
        this.m_Properties.addAllowed(Saver.class, VAL_SAVER);
        this.m_Properties.addAllowed(Loader.class, VAL_LOADER);
        if (this.getDataType() == 0) {
            this.m_Properties.addAllowed(Loader.class, VAL_BEANCONTEXT);
        } else {
            this.m_Properties.addIgnored(Loader.class, VAL_BEANCONTEXT);
        }
        this.m_Properties.addAllowed(Filter.class, "filter");
        this.m_Properties.addAllowed(Classifier.class, "wrappedAlgorithm");
        this.m_Properties.addAllowed(Clusterer.class, "wrappedAlgorithm");
        this.m_Properties.addAllowed(weka.classifiers.Classifier.class, "debug");
        this.m_Properties.addAllowed(weka.classifiers.Classifier.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(weka.filters.Filter.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(DatabaseSaver.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(DatabaseLoader.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(SplitEvaluator.class, VAL_OPTIONS);
        this.m_Properties.addAllowed(ResultProducer.class, VAL_OPTIONS);
        this.m_CustomMethods.register(this, Color.class, "Color");
        this.m_CustomMethods.register(this, Dimension.class, "Dimension");
        this.m_CustomMethods.register(this, Font.class, "Font");
        this.m_CustomMethods.register(this, Point.class, "Point");
        this.m_CustomMethods.register(this, ColorUIResource.class, "ColorUIResource");
        this.m_CustomMethods.register(this, FontUIResource.class, "FontUIResource");
        this.m_CustomMethods.register(this, BeanInstance.class, "BeanInstance");
        this.m_CustomMethods.register(this, BeanConnection.class, "BeanConnection");
        this.m_CustomMethods.register(this, BeanVisual.class, "BeanVisual");
        this.m_CustomMethods.register(this, Saver.class, "BeanSaver");
        this.m_CustomMethods.register(this, MetaBean.class, "MetaBean");
        this.m_CustomMethods.register(this, ArffLoader.class, "Loader");
        this.m_CustomMethods.register(this, ArffSaver.class, "Saver");
        this.m_CustomMethods.register(this, C45Loader.class, "Loader");
        this.m_CustomMethods.register(this, C45Saver.class, "Saver");
        this.m_CustomMethods.register(this, CSVLoader.class, "Loader");
        this.m_CustomMethods.register(this, CSVSaver.class, "Saver");
        this.m_CustomMethods.register(this, SerializedInstancesLoader.class, "Loader");
        this.m_CustomMethods.register(this, SerializedInstancesSaver.class, "Saver");
        this.m_BeanInstances = null;
        this.m_BeanInstancesID = null;
        this.m_CurrentMetaBean = null;
        this.m_IgnoreBeanConnections = true;
        this.m_BeanConnectionRelation = null;
    }

    protected void addBeanInstances(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) instanceof BeanInstance) {
                BeanInstance beanInstance = (BeanInstance)vector.get(i);
                this.m_BeanInstancesID.add(new Integer(this.m_BeanInstances.size()));
                this.m_BeanInstances.add(beanInstance);
                if (!(beanInstance.getBean() instanceof MetaBean)) continue;
                this.addBeanInstances(((MetaBean)beanInstance.getBean()).getBeansInSubFlow());
                continue;
            }
            if (vector.get(i) instanceof MetaBean) {
                this.addBeanInstances(((MetaBean)vector.get(i)).getBeansInSubFlow());
                continue;
            }
            System.out.println(LocalString.get("addBeanInstances does not support Vectors of class '") + vector.get(i) + "'!");
        }
    }

    protected Object writePreProcess(Object object) throws Exception {
        object = super.writePreProcess(object);
        this.m_BeanInstances = new Vector();
        this.m_BeanInstancesID = new Vector();
        switch (this.getDataType()) {
            case 0: {
                this.addBeanInstances(BeanInstance.getBeanInstances());
                break;
            }
            case 1: {
                this.addBeanInstances((Vector)object);
                break;
            }
            default: {
                System.out.println(LocalString.get("writePreProcess: data type '") + this.getDataType() + LocalString.get("' is not recognized!"));
            }
        }
        return object;
    }

    protected void writePostProcess(Object object) throws Exception {
        if (this.getDataType() == 0) {
            Element element = this.m_Document.getDocument().getDocumentElement();
            Element element2 = (Element)element.getChildNodes().item(1);
            NodeList nodeList = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                element3.setAttribute(VAL_NAME, "" + i);
            }
        }
    }

    protected Document readPreProcess(Document document) throws Exception {
        this.m_BeanInstances = new Vector();
        this.m_BeanInstancesID = new Vector();
        NodeList nodeList = document.getElementsByTagName("*");
        String string = BeanInstance.class.getName();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!element.getAttribute("class").equals(string)) continue;
            Vector vector = XMLDocument.getChildTags(element);
            int n = this.m_BeanInstancesID.size();
            for (int j = 0; j < vector.size(); ++j) {
                Element element2 = (Element)vector.get(j);
                if (!element2.getAttribute(VAL_NAME).equals(VAL_ID)) continue;
                n = this.readIntFromXML(element2);
            }
            this.m_BeanInstancesID.add(new Integer(n));
        }
        this.m_BeanInstances.setSize(this.m_BeanInstancesID.size());
        this.m_CurrentMetaBean = null;
        this.m_IgnoreBeanConnections = true;
        this.m_BeanConnectionRelation = new Hashtable();
        return document;
    }

    protected void setBeanConnection(BeanConnection beanConnection, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) != null) continue;
            vector.set(i, beanConnection);
            bl = true;
            break;
        }
        if (!bl) {
            vector.add(beanConnection);
        }
    }

    protected BeanConnection createBeanConnection(int n, int n2, String string, boolean bl) throws Exception {
        BeanConnection beanConnection = null;
        if (n == -1 || n2 == -1) {
            return beanConnection;
        }
        BeanInstance beanInstance = (BeanInstance)this.m_BeanInstances.get(n);
        BeanInstance beanInstance2 = (BeanInstance)this.m_BeanInstances.get(n2);
        BeanInfo beanInfo = Introspector.getBeanInfo(((BeanInstance)this.m_BeanInstances.get(n)).getBean().getClass());
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
            if (!eventSetDescriptorArray[i].getName().equals(string)) continue;
            beanConnection = new BeanConnection(beanInstance, beanInstance2, eventSetDescriptorArray[i]);
            beanConnection.setHidden(bl);
            break;
        }
        return beanConnection;
    }

    protected void rebuildBeanConnections(Vector vector, Object object) throws Exception {
        Vector vector2 = (Vector)this.m_BeanConnectionRelation.get(object);
        if (vector2 == null) {
            return;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(vector2.get(i).toString(), ",");
            BeanConnection beanConnection = null;
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string = stringTokenizer.nextToken();
            boolean bl = this.stringToBoolean(stringTokenizer.nextToken());
            if (!(object instanceof MetaBean) || this.getDataType() == 1) {
                beanConnection = this.createBeanConnection(n, n2, string, bl);
            } else {
                Vector vector3 = BeanConnection.getConnections();
                for (int j = 0; !(j >= vector3.size() || (beanConnection = (BeanConnection)vector3.get(j)).getSource() == (BeanInstance)this.m_BeanInstances.get(n) && beanConnection.getTarget() == (BeanInstance)this.m_BeanInstances.get(n2) && beanConnection.getEventName().equals(string)); ++j) {
                    beanConnection = null;
                }
            }
            if (object instanceof MetaBean) {
                this.setBeanConnection(beanConnection, ((MetaBean)object).getAssociatedConnections());
                continue;
            }
            this.setBeanConnection(beanConnection, (Vector)vector.get(1));
        }
    }

    protected void removeUserToolBarBeans(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            MetaBean metaBean = (MetaBean)vector.get(i);
            Vector vector2 = metaBean.getSubFlow();
            for (int j = 0; j < vector2.size(); ++j) {
                BeanInstance beanInstance = (BeanInstance)vector2.get(j);
                beanInstance.removeBean(this.m_BeanLayout);
            }
        }
    }

    protected Object readPostProcess(Object object) throws Exception {
        Vector vector = (Vector)super.readPostProcess(object);
        this.rebuildBeanConnections(vector, REGULAR_CONNECTION);
        Enumeration enumeration = this.m_BeanConnectionRelation.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof MetaBean)) continue;
            this.rebuildBeanConnections(vector, k);
        }
        if (this.getDataType() == 1) {
            this.removeUserToolBarBeans(vector);
        }
        return vector;
    }

    protected Vector getBeanConnectionRelation(MetaBean metaBean) {
        Object object = metaBean == null ? REGULAR_CONNECTION : metaBean;
        if (!this.m_BeanConnectionRelation.containsKey(object)) {
            this.m_BeanConnectionRelation.put(object, new Vector());
        }
        Vector vector = (Vector)this.m_BeanConnectionRelation.get(object);
        return vector;
    }

    protected void addBeanConnectionRelation(MetaBean metaBean, String string) {
        Vector vector = this.getBeanConnectionRelation(metaBean);
        vector.add(string);
        Object object = metaBean == null ? REGULAR_CONNECTION : metaBean;
        this.m_BeanConnectionRelation.put(object, vector);
    }

    public Element writeColor(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Color color = (Color)object;
        Element element2 = this.addElement(element, string, color.getClass().getName(), false);
        this.writeIntToXML(element2, color.getRed(), VAL_RED);
        this.writeIntToXML(element2, color.getGreen(), VAL_GREEN);
        this.writeIntToXML(element2, color.getBlue(), VAL_BLUE);
        return element2;
    }

    public Object readColor(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        Color color = null;
        Vector vector = XMLDocument.getChildTags(element);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string = element2.getAttribute(VAL_NAME);
            if (string.equals(VAL_RED)) {
                n = this.readIntFromXML(element2);
                continue;
            }
            if (string.equals(VAL_GREEN)) {
                n2 = this.readIntFromXML(element2);
                continue;
            }
            if (string.equals(VAL_BLUE)) {
                n3 = this.readIntFromXML(element2);
                continue;
            }
            System.out.println(LocalString.get("WARNING: '") + string + LocalString.get("' is not a recognized name for ") + element.getAttribute(VAL_NAME) + "!");
        }
        color = new Color(n, n2, n3);
        return color;
    }

    public Element writeDimension(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Dimension dimension = (Dimension)object;
        Element element2 = this.addElement(element, string, dimension.getClass().getName(), false);
        this.writeDoubleToXML(element2, dimension.getWidth(), VAL_WIDTH);
        this.writeDoubleToXML(element2, dimension.getHeight(), VAL_HEIGHT);
        return element2;
    }

    public Object readDimension(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        Dimension dimension = null;
        Vector vector = XMLDocument.getChildTags(element);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string = element2.getAttribute(VAL_NAME);
            if (string.equals(VAL_WIDTH)) {
                d = this.readDoubleFromXML(element2);
                continue;
            }
            if (string.equals(VAL_HEIGHT)) {
                d2 = this.readDoubleFromXML(element2);
                continue;
            }
            System.out.println(LocalString.get("WARNING: '") + string + LocalString.get("' is not a recognized name for ") + element.getAttribute(VAL_NAME) + "!");
        }
        dimension = new Dimension();
        dimension.setSize(d, d2);
        return dimension;
    }

    public Element writeFont(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Font font = (Font)object;
        Element element2 = this.addElement(element, string, font.getClass().getName(), false);
        this.invokeWriteToXML(element2, font.getName(), VAL_NAME);
        this.writeIntToXML(element2, font.getStyle(), VAL_STYLE);
        this.writeIntToXML(element2, font.getSize(), VAL_SIZE);
        return element2;
    }

    public Object readFont(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        Font font = null;
        Vector vector = XMLDocument.getChildTags(element);
        String string = "";
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string2 = element2.getAttribute(VAL_NAME);
            if (string2.equals(VAL_NAME)) {
                string2 = (String)this.invokeReadFromXML(element2);
                continue;
            }
            if (string2.equals(VAL_STYLE)) {
                n = this.readIntFromXML(element2);
                continue;
            }
            if (string2.equals(VAL_SIZE)) {
                n2 = this.readIntFromXML(element2);
                continue;
            }
            System.out.println(LocalString.get("WARNING: '") + string2 + LocalString.get("' is not a recognized name for ") + element.getAttribute(VAL_NAME) + "!");
        }
        font = new Font(string, n, n2);
        return font;
    }

    public Element writePoint(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Point point = (Point)object;
        Element element2 = this.addElement(element, string, point.getClass().getName(), false);
        this.writeDoubleToXML(element2, point.getX(), VAL_X);
        this.writeDoubleToXML(element2, point.getY(), VAL_Y);
        return element2;
    }

    public Object readPoint(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        Point point = null;
        Vector vector = XMLDocument.getChildTags(element);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string = element2.getAttribute(VAL_NAME);
            if (string.equals(VAL_X)) {
                d = this.readDoubleFromXML(element2);
                continue;
            }
            if (string.equals(VAL_Y)) {
                d2 = this.readDoubleFromXML(element2);
                continue;
            }
            System.out.println(LocalString.get("WARNING: '") + string + LocalString.get("' is not a recognized name for ") + element.getAttribute(VAL_NAME) + "!");
        }
        point = new Point();
        point.setLocation(d, d2);
        return point;
    }

    public Element writeColorUIResource(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        ColorUIResource colorUIResource = (ColorUIResource)object;
        Element element2 = this.addElement(element, string, colorUIResource.getClass().getName(), false);
        this.invokeWriteToXML(element2, new Color(colorUIResource.getRGB()), VAL_COLOR);
        return element2;
    }

    public Object readColorUIResource(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        ColorUIResource colorUIResource = null;
        Vector vector = XMLDocument.getChildTags(element);
        Color color = null;
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string = element2.getAttribute(VAL_NAME);
            if (string.equals(VAL_COLOR)) {
                color = (Color)this.invokeReadFromXML(element2);
                continue;
            }
            System.out.println(LocalString.get("WARNING: '") + string + LocalString.get("' is not a recognized name for ") + element.getAttribute(VAL_NAME) + "!");
        }
        colorUIResource = new ColorUIResource(color);
        return colorUIResource;
    }

    public Element writeFontUIResource(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        FontUIResource fontUIResource = (FontUIResource)object;
        Element element2 = this.addElement(element, string, fontUIResource.getClass().getName(), false);
        this.invokeWriteToXML(element2, new Font(fontUIResource.getName(), fontUIResource.getStyle(), fontUIResource.getSize()), VAL_COLOR);
        return element2;
    }

    public Object readFontUIResource(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        FontUIResource fontUIResource = null;
        Vector vector = XMLDocument.getChildTags(element);
        Font font = null;
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string = element2.getAttribute(VAL_NAME);
            if (string.equals(VAL_FONT)) {
                font = (Font)this.invokeReadFromXML(element2);
                continue;
            }
            System.out.println(LocalString.get("WARNING: '") + string + LocalString.get("' is not a recognized name for ") + element.getAttribute(VAL_NAME) + "!");
        }
        fontUIResource = new FontUIResource(font);
        return fontUIResource;
    }

    public Element writeBeanInstance(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        BeanInstance beanInstance = (BeanInstance)object;
        Element element2 = this.addElement(element, string, beanInstance.getClass().getName(), false);
        this.writeIntToXML(element2, this.m_BeanInstances.indexOf(beanInstance), VAL_ID);
        this.writeIntToXML(element2, beanInstance.getX() + beanInstance.getWidth() / 2, VAL_X);
        this.writeIntToXML(element2, beanInstance.getY() + beanInstance.getHeight() / 2, VAL_Y);
        this.invokeWriteToXML(element2, beanInstance.getBean(), VAL_BEAN);
        return element2;
    }

    public Object readBeanInstance(Element element) throws Exception {
        int n;
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        BeanInstance beanInstance = null;
        Vector vector = XMLDocument.getChildTags(element);
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        Object object = null;
        for (n = 0; n < vector.size(); ++n) {
            Element element2 = (Element)vector.get(n);
            String string = element2.getAttribute(VAL_NAME);
            if (string.equals(VAL_ID)) {
                n2 = this.readIntFromXML(element2);
                continue;
            }
            if (string.equals(VAL_X)) {
                n3 = this.readIntFromXML(element2);
                continue;
            }
            if (string.equals(VAL_Y)) {
                n4 = this.readIntFromXML(element2);
                continue;
            }
            if (string.equals(VAL_BEAN)) {
                object = this.invokeReadFromXML(element2);
                continue;
            }
            System.out.println(LocalString.get("WARNING: '") + string + LocalString.get("' is not a recognized name for ") + element.getAttribute(VAL_NAME) + "!");
        }
        beanInstance = new BeanInstance(this.m_BeanLayout, object, n3, n4);
        BeanInstance beanInstance2 = beanInstance;
        if (beanInstance2.getBean() instanceof Visible) {
            BeanVisual beanVisual = ((Visible)beanInstance2.getBean()).getVisual();
            beanVisual.setSize(beanVisual.getPreferredSize());
            if (beanVisual.getParent() == null) {
                ((JPanel)beanInstance2.getBean()).add(beanVisual);
            }
        }
        if (n2 == -1) {
            for (n = 0; n < this.m_BeanInstances.size(); ++n) {
                if (this.m_BeanInstances.get(n) != null) continue;
                n2 = (Integer)this.m_BeanInstancesID.get(n);
                break;
            }
        }
        n = this.m_BeanInstancesID.indexOf(new Integer(n2));
        this.m_BeanInstances.set(n, beanInstance);
        this.m_CurrentMetaBean = null;
        return beanInstance;
    }

    public Element writeBeanConnection(Element element, Object object, String string) throws Exception {
        int n;
        int n2;
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        BeanConnection beanConnection = (BeanConnection)object;
        Element element2 = null;
        int n3 = this.m_BeanInstances.indexOf(beanConnection.getSource());
        int n4 = this.m_BeanInstances.indexOf(beanConnection.getTarget());
        if (n3 > -1 && n4 > -1) {
            n2 = (Integer)this.m_BeanInstancesID.get(n3);
            n = (Integer)this.m_BeanInstancesID.get(n4);
        } else {
            n2 = -1;
            n = -1;
        }
        if (n2 > -1 && n > -1) {
            element2 = this.addElement(element, string, beanConnection.getClass().getName(), false);
            this.writeIntToXML(element2, n2, VAL_SOURCEID);
            this.writeIntToXML(element2, n, VAL_TARGETID);
            this.invokeWriteToXML(element2, beanConnection.getEventName(), VAL_EVENTNAME);
            this.writeBooleanToXML(element2, beanConnection.isHidden(), VAL_HIDDEN);
        }
        return element2;
    }

    public Object readBeanConnection(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        BeanConnection beanConnection = null;
        Vector vector = XMLDocument.getChildTags(element);
        int n = 0;
        int n2 = 0;
        String string = "";
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string2 = element2.getAttribute(VAL_NAME);
            if (string2.equals(VAL_SOURCEID)) {
                n = this.readIntFromXML(element2);
                continue;
            }
            if (string2.equals(VAL_TARGETID)) {
                n2 = this.readIntFromXML(element2);
                continue;
            }
            if (string2.equals(VAL_EVENTNAME)) {
                string = (String)this.invokeReadFromXML(element2);
                continue;
            }
            if (string2.equals(VAL_HIDDEN)) {
                bl = this.readBooleanFromXML(element2);
                continue;
            }
            System.out.println(LocalString.get("WARNING: '") + string2 + LocalString.get("' is not a recognized name for ") + element.getAttribute(VAL_NAME) + "!");
        }
        int n3 = this.m_BeanInstancesID.indexOf(new Integer(n));
        int n4 = this.m_BeanInstancesID.indexOf(new Integer(n2));
        if (this.m_IgnoreBeanConnections) {
            this.addBeanConnectionRelation(this.m_CurrentMetaBean, n3 + "," + n4 + "," + string + "," + bl);
            return beanConnection;
        }
        beanConnection = this.createBeanConnection(n3, n4, string, bl);
        return beanConnection;
    }

    public Element writeBeanLoader(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Loader loader = (Loader)object;
        Element element2 = this.addElement(element, string, loader.getClass().getName(), false);
        this.invokeWriteToXML(element2, loader.getLoader(), VAL_LOADER);
        this.invokeWriteToXML(element2, loader.getBeanContext(), VAL_BEANCONTEXT);
        return element2;
    }

    public Element writeBeanSaver(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Saver saver = (Saver)object;
        Element element2 = this.addElement(element, string, saver.getClass().getName(), false);
        this.invokeWriteToXML(element2, saver.getSaver(), VAL_SAVER);
        return element2;
    }

    public Element writeLoader(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        weka.core.converters.Loader loader = (weka.core.converters.Loader)object;
        Element element2 = this.addElement(element, string, loader.getClass().getName(), false);
        boolean bl = true;
        File file = null;
        if (loader instanceof ArffLoader) {
            file = ((ArffLoader)loader).retrieveFile();
        } else if (loader instanceof C45Loader) {
            file = ((C45Loader)loader).retrieveFile();
        } else if (loader instanceof CSVLoader) {
            file = ((CSVLoader)loader).retrieveFile();
        } else if (loader instanceof SerializedInstancesLoader) {
            file = ((SerializedInstancesLoader)loader).retrieveFile();
        } else {
            bl = false;
        }
        if (!bl) {
            System.out.println(LocalString.get("WARNING: unknown loader class '") + loader.getClass().getName() + LocalString.get("' - cannot retrieve file!"));
        }
        if (file == null || file.isDirectory()) {
            this.invokeWriteToXML(element2, "", VAL_FILE);
        } else {
            this.invokeWriteToXML(element2, file.getAbsolutePath(), VAL_FILE);
        }
        return element2;
    }

    public Object readLoader(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        Object obj = Class.forName(element.getAttribute("class")).newInstance();
        Vector vector = XMLDocument.getChildTags(element);
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string2 = element2.getAttribute(VAL_NAME);
            if (string2.equals(VAL_FILE)) {
                string = (String)this.invokeReadFromXML(element2);
                continue;
            }
            this.readFromXML(obj, string2, element2);
        }
        if (string.equals("")) {
            string = null;
        }
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                ((AbstractLoader)obj).setSource(file);
            } else {
                System.out.println(LocalString.get("WARNING: The file '") + string + LocalString.get("' does not exist!"));
            }
        }
        return obj;
    }

    public Element writeSaver(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        weka.core.converters.Saver saver = (weka.core.converters.Saver)object;
        Element element2 = this.addElement(element, string, saver.getClass().getName(), false);
        boolean bl = true;
        File file = null;
        if (saver instanceof ArffSaver) {
            file = ((ArffSaver)saver).retrieveFile();
        } else if (saver instanceof C45Saver) {
            file = ((C45Saver)saver).retrieveFile();
        } else if (saver instanceof CSVSaver) {
            file = ((CSVSaver)saver).retrieveFile();
        } else if (saver instanceof SerializedInstancesSaver) {
            file = ((SerializedInstancesSaver)saver).retrieveFile();
        } else {
            bl = false;
        }
        if (!bl) {
            System.out.println(LocalString.get("WARNING: unknown saver class '") + saver.getClass().getName() + LocalString.get("' - cannot retrieve file!"));
        }
        if (file == null || file.isDirectory()) {
            this.invokeWriteToXML(element2, "", VAL_FILE);
        } else {
            this.invokeWriteToXML(element2, file.getAbsolutePath(), VAL_FILE);
        }
        return element2;
    }

    public Object readSaver(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        Object obj = Class.forName(element.getAttribute("class")).newInstance();
        Vector vector = XMLDocument.getChildTags(element);
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string2 = element2.getAttribute(VAL_NAME);
            if (string2.equals(VAL_FILE)) {
                string = (String)this.invokeReadFromXML(element2);
                continue;
            }
            this.readFromXML(obj, string2, element2);
        }
        if (string.equals("")) {
            string = null;
        }
        if (string != null) {
            ((AbstractSaver)obj).setFile(new File(string));
            ((AbstractSaver)obj).setDestination(new File(string));
        }
        return obj;
    }

    public Element writeBeanVisual(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        BeanVisual beanVisual = (BeanVisual)object;
        Element element2 = this.writeToXML(element, object, string);
        this.invokeWriteToXML(element2, beanVisual.getIconPath(), VAL_ICONPATH);
        this.invokeWriteToXML(element2, beanVisual.getAnimatedIconPath(), VAL_ANIMATEDICONPATH);
        return element2;
    }

    public Object readBeanVisual(Element element) throws Exception {
        int n;
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        BeanVisual beanVisual = null;
        Vector vector = XMLDocument.getChildTags(element);
        String string = "";
        String string2 = "";
        String string3 = "";
        for (n = 0; n < vector.size(); ++n) {
            Element element2 = (Element)vector.get(n);
            String string4 = element2.getAttribute(VAL_NAME);
            if (string4.equals(VAL_TEXT)) {
                string = (String)this.invokeReadFromXML(element2);
                continue;
            }
            if (string4.equals(VAL_ICONPATH)) {
                string2 = (String)this.invokeReadFromXML(element2);
                continue;
            }
            if (!string4.equals(VAL_ANIMATEDICONPATH)) continue;
            string3 = (String)this.invokeReadFromXML(element2);
        }
        beanVisual = new BeanVisual(string, string2, string3);
        for (n = 0; n < vector.size(); ++n) {
            this.readFromXML(beanVisual, element.getAttribute(VAL_NAME), (Element)vector.get(n));
        }
        return beanVisual;
    }

    protected Vector getIDsForBeanInstances(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            int n = this.m_BeanInstances.indexOf(vector.get(i));
            vector2.add(this.m_BeanInstancesID.get(n));
        }
        return vector2;
    }

    public Element writeMetaBean(Element element, Object object, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        MetaBean metaBean = (MetaBean)object;
        Element element2 = this.writeToXML(element, object, string);
        this.invokeWriteToXML(element2, this.getIDsForBeanInstances(metaBean.getBeansInInputs()), VAL_INPUTSID);
        this.invokeWriteToXML(element2, this.getIDsForBeanInstances(metaBean.getBeansInOutputs()), VAL_OUTPUTSID);
        return element2;
    }

    protected Vector getBeanInstancesForIDs(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            int n = this.m_BeanInstancesID.indexOf(vector.get(i));
            vector2.add(this.m_BeanInstances.get(n));
        }
        return vector2;
    }

    public Object readMetaBean(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(VAL_NAME));
        }
        this.m_CurrentNode = element;
        MetaBean metaBean = new MetaBean();
        Vector vector = XMLDocument.getChildTags(element);
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.m_CurrentMetaBean = metaBean;
        for (int i = 0; i < vector.size(); ++i) {
            Element element2 = (Element)vector.get(i);
            String string = element2.getAttribute(VAL_NAME);
            if (string.equals(VAL_ASSOCIATEDCONNECTIONS)) {
                metaBean.setAssociatedConnections((Vector)this.invokeReadFromXML(element2));
                continue;
            }
            if (string.equals(VAL_INPUTSID)) {
                vector2 = (Vector)this.invokeReadFromXML(element2);
                continue;
            }
            if (string.equals(VAL_OUTPUTSID)) {
                vector3 = (Vector)this.invokeReadFromXML(element2);
                continue;
            }
            if (string.equals(VAL_SUBFLOW)) {
                metaBean.setSubFlow((Vector)this.invokeReadFromXML(element2));
                continue;
            }
            if (string.equals(VAL_ORIGINALCOORDS)) {
                vector4 = (Vector)this.invokeReadFromXML(element2);
                continue;
            }
            if (string.equals(VAL_INPUTS)) {
                System.out.println(LocalString.get("INFO: '") + string + LocalString.get("' will be restored later."));
                continue;
            }
            if (string.equals(VAL_OUTPUTS)) {
                System.out.println(LocalString.get("INFO: '") + string + LocalString.get("' will be restored later."));
                continue;
            }
            this.readFromXML(metaBean, string, element2);
        }
        MetaBean metaBean2 = metaBean;
        metaBean2.setInputs(this.getBeanInstancesForIDs(vector2));
        metaBean2.setOutputs(this.getBeanInstancesForIDs(vector3));
        metaBean2.setOriginalCoords(vector4);
        return metaBean;
    }
}

