/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.boundaryvisualizer.BoundaryPanel;
import weka.gui.boundaryvisualizer.KDDataGenerator;
import weka.gui.visualize.ClassPanel;

public class BoundaryVisualizer
extends JPanel {
    private Instances m_trainingInstances;
    private Classifier m_classifier;
    protected int m_plotAreaWidth = 512;
    protected int m_plotAreaHeight = 384;
    protected BoundaryPanel m_boundaryPanel;
    protected JComboBox m_classAttBox = new JComboBox();
    protected JComboBox m_xAttBox = new JComboBox();
    protected JComboBox m_yAttBox = new JComboBox();
    protected Dimension COMBO_SIZE;
    protected JButton m_startBut;
    protected JCheckBox m_plotTrainingData;
    protected JPanel m_controlPanel;
    protected ClassPanel m_classPanel;
    private AxisPanel m_xAxisPanel;
    private AxisPanel m_yAxisPanel;
    private double m_maxX;
    private double m_maxY;
    private double m_minX;
    private double m_minY;
    private int m_xIndex;
    private int m_yIndex;
    private KDDataGenerator m_dataGenerator;
    private int m_numberOfSamplesFromEachRegion;
    private int m_generatorSamplesBase;
    private int m_kernelBandwidth;
    private JTextField m_regionSamplesText;
    private JTextField m_generatorSamplesText;
    private JTextField m_kernelBandwidthText;

    public BoundaryVisualizer() {
        this.COMBO_SIZE = new Dimension(this.m_plotAreaWidth / 2, this.m_classAttBox.getPreferredSize().height);
        this.m_startBut = new JButton("Start");
        this.m_plotTrainingData = new JCheckBox(LocalString.get("Plot training data"));
        this.m_classPanel = new ClassPanel();
        this.m_regionSamplesText = new JTextField("0");
        this.m_generatorSamplesText = new JTextField("0");
        this.m_kernelBandwidthText = new JTextField("3  ");
        this.setLayout(new BorderLayout());
        this.m_classAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_classAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_classAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_classAttBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryVisualizer.this.m_classPanel.setCindex(BoundaryVisualizer.this.m_classAttBox.getSelectedIndex());
            }
        });
        this.m_xAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_xAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_xAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_yAttBox.setMinimumSize(this.COMBO_SIZE);
        this.m_yAttBox.setPreferredSize(this.COMBO_SIZE);
        this.m_yAttBox.setMaximumSize(this.COMBO_SIZE);
        this.m_classPanel.setMinimumSize(new Dimension((int)this.COMBO_SIZE.getWidth() * 2, (int)this.COMBO_SIZE.getHeight() * 2));
        this.m_classPanel.setPreferredSize(new Dimension((int)this.COMBO_SIZE.getWidth() * 2, (int)this.COMBO_SIZE.getHeight() * 2));
        this.m_controlPanel = new JPanel();
        this.m_controlPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(LocalString.get("Class Attribute")));
        jPanel.add(this.m_classAttBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(LocalString.get("Visualization Attributes")));
        jPanel2.add(this.m_xAttBox);
        jPanel2.add(this.m_yAttBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(LocalString.get("Sampling control")));
        jPanel4.setLayout(new GridLayout(3, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)new JLabel(LocalString.get(" Base for sampling (r)")), "Center");
        jPanel6.add((Component)this.m_generatorSamplesText, "West");
        jPanel4.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)new JLabel(LocalString.get(" Num. locations per pixel")), "Center");
        jPanel7.add((Component)this.m_regionSamplesText, "West");
        jPanel4.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add((Component)new JLabel(LocalString.get(" Kernel bandwidth (k)")), "Center");
        jPanel8.add((Component)this.m_kernelBandwidthText, "West");
        jPanel4.add(jPanel8);
        jPanel5.add((Component)jPanel4, "North");
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createTitledBorder("Plotting"));
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)this.m_startBut, "Center");
        jPanel9.add((Component)this.m_plotTrainingData, "West");
        jPanel5.add((Component)jPanel9, "South");
        this.m_controlPanel.add((Component)jPanel3, "West");
        this.m_controlPanel.add((Component)jPanel5, "Center");
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createTitledBorder(LocalString.get("Class color")));
        jPanel10.add(this.m_classPanel);
        this.m_controlPanel.add((Component)jPanel10, "South");
        this.add((Component)this.m_controlPanel, "North");
        this.m_boundaryPanel = new BoundaryPanel(this.m_plotAreaWidth, this.m_plotAreaHeight);
        this.m_numberOfSamplesFromEachRegion = this.m_boundaryPanel.getNumSamplesPerRegion();
        this.m_regionSamplesText.setText("" + this.m_numberOfSamplesFromEachRegion + "  ");
        this.m_generatorSamplesBase = (int)this.m_boundaryPanel.getGeneratorSamplesBase();
        this.m_generatorSamplesText.setText("" + this.m_generatorSamplesBase + "  ");
        this.m_dataGenerator = new KDDataGenerator();
        this.m_kernelBandwidth = this.m_dataGenerator.getKernelBandwidth();
        this.m_kernelBandwidthText.setText("" + this.m_kernelBandwidth + "  ");
        this.m_boundaryPanel.setDataGenerator(this.m_dataGenerator);
        this.add((Component)this.m_boundaryPanel, "Center");
        this.m_xAxisPanel = new AxisPanel(false);
        this.add((Component)this.m_xAxisPanel, "South");
        this.m_yAxisPanel = new AxisPanel(true);
        this.add((Component)this.m_yAxisPanel, "West");
        this.m_startBut.setEnabled(false);
        this.m_startBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BoundaryVisualizer.this.m_startBut.getText().equals("Start")) {
                    if (BoundaryVisualizer.this.m_trainingInstances != null && BoundaryVisualizer.this.m_classifier != null) {
                        try {
                            int n = BoundaryVisualizer.this.m_numberOfSamplesFromEachRegion;
                            try {
                                n = Integer.parseInt(BoundaryVisualizer.this.m_regionSamplesText.getText().trim());
                            }
                            catch (Exception exception) {
                                BoundaryVisualizer.this.m_regionSamplesText.setText("" + n);
                            }
                            BoundaryVisualizer.this.m_numberOfSamplesFromEachRegion = n;
                            BoundaryVisualizer.this.m_boundaryPanel.setNumSamplesPerRegion(n);
                            n = BoundaryVisualizer.this.m_generatorSamplesBase;
                            try {
                                n = Integer.parseInt(BoundaryVisualizer.this.m_generatorSamplesText.getText().trim());
                            }
                            catch (Exception exception) {
                                BoundaryVisualizer.this.m_generatorSamplesText.setText("" + n);
                            }
                            BoundaryVisualizer.this.m_generatorSamplesBase = n;
                            BoundaryVisualizer.this.m_boundaryPanel.setGeneratorSamplesBase(n);
                            n = BoundaryVisualizer.this.m_kernelBandwidth;
                            try {
                                n = Integer.parseInt(BoundaryVisualizer.this.m_kernelBandwidthText.getText().trim());
                            }
                            catch (Exception exception) {
                                BoundaryVisualizer.this.m_kernelBandwidthText.setText("" + n);
                            }
                            BoundaryVisualizer.this.m_kernelBandwidth = n;
                            BoundaryVisualizer.this.m_dataGenerator.setKernelBandwidth(n);
                            BoundaryVisualizer.this.m_trainingInstances.setClassIndex(BoundaryVisualizer.this.m_classAttBox.getSelectedIndex());
                            BoundaryVisualizer.this.m_boundaryPanel.setClassifier(BoundaryVisualizer.this.m_classifier);
                            BoundaryVisualizer.this.m_boundaryPanel.setTrainingData(BoundaryVisualizer.this.m_trainingInstances);
                            BoundaryVisualizer.this.m_boundaryPanel.setXAttribute(BoundaryVisualizer.this.m_xIndex);
                            BoundaryVisualizer.this.m_boundaryPanel.setYAttribute(BoundaryVisualizer.this.m_yIndex);
                            BoundaryVisualizer.this.m_boundaryPanel.setPlotTrainingData(BoundaryVisualizer.this.m_plotTrainingData.isSelected());
                            BoundaryVisualizer.this.m_boundaryPanel.start();
                            BoundaryVisualizer.this.m_startBut.setText("Stop");
                            BoundaryVisualizer.this.setControlEnabledStatus(false);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else {
                    BoundaryVisualizer.this.m_boundaryPanel.stopPlotting();
                    BoundaryVisualizer.this.m_startBut.setText("Start");
                    BoundaryVisualizer.this.setControlEnabledStatus(true);
                }
            }
        });
        this.m_boundaryPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryVisualizer.this.m_startBut.setText("Start");
                BoundaryVisualizer.this.setControlEnabledStatus(true);
            }
        });
        this.m_classPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FastVector fastVector = BoundaryVisualizer.this.m_boundaryPanel.getColors();
                    FileOutputStream fileOutputStream = new FileOutputStream("colors.ser");
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(fastVector);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BoundaryVisualizer.this.m_boundaryPanel.replot();
            }
        });
    }

    private void setControlEnabledStatus(boolean bl) {
        this.m_classAttBox.setEnabled(bl);
        this.m_xAttBox.setEnabled(bl);
        this.m_yAttBox.setEnabled(bl);
        this.m_regionSamplesText.setEnabled(bl);
        this.m_generatorSamplesText.setEnabled(bl);
        this.m_kernelBandwidthText.setEnabled(bl);
        this.m_plotTrainingData.setEnabled(bl);
    }

    public void setClassifier(Classifier classifier) throws Exception {
        this.m_classifier = classifier;
    }

    private void computeBounds() {
        int n;
        String string = (String)this.m_xAttBox.getSelectedItem();
        if (string == null) {
            return;
        }
        string = Utils.removeSubstring(string, "X: ");
        string = Utils.removeSubstring(string, LocalString.get(" (Num)"));
        String string2 = (String)this.m_yAttBox.getSelectedItem();
        string2 = Utils.removeSubstring(string2, "Y: ");
        string2 = Utils.removeSubstring(string2, LocalString.get(" (Num)"));
        this.m_xIndex = -1;
        this.m_yIndex = -1;
        for (n = 0; n < this.m_trainingInstances.numAttributes(); ++n) {
            if (this.m_trainingInstances.attribute(n).name().equals(string)) {
                this.m_xIndex = n;
            }
            if (!this.m_trainingInstances.attribute(n).name().equals(string2)) continue;
            this.m_yIndex = n;
        }
        if (this.m_xIndex != -1 && this.m_yIndex != -1) {
            this.m_minX = Double.MAX_VALUE;
            this.m_minY = Double.MAX_VALUE;
            this.m_maxX = Double.MIN_VALUE;
            this.m_maxY = Double.MIN_VALUE;
            for (n = 0; n < this.m_trainingInstances.numInstances(); ++n) {
                double d;
                Instance instance = this.m_trainingInstances.instance(n);
                if (!instance.isMissing(this.m_xIndex)) {
                    d = instance.value(this.m_xIndex);
                    if (d < this.m_minX) {
                        this.m_minX = d;
                    }
                    if (d > this.m_maxX) {
                        this.m_maxX = d;
                    }
                }
                if (instance.isMissing(this.m_yIndex)) continue;
                d = instance.value(this.m_yIndex);
                if (d < this.m_minY) {
                    this.m_minY = d;
                }
                if (!(d > this.m_maxY)) continue;
                this.m_maxY = d;
            }
        }
    }

    public Instances getInstances() {
        return this.m_trainingInstances;
    }

    public void setInstances(Instances instances) throws Exception {
        if (instances.numAttributes() < 3) {
            throw new Exception(LocalString.get("Not enough attributes in the data to visualize!"));
        }
        this.m_trainingInstances = instances;
        this.m_classPanel.setInstances(this.m_trainingInstances);
        String[] stringArray = new String[this.m_trainingInstances.numAttributes()];
        final Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < this.m_trainingInstances.numAttributes(); ++i) {
            stringArray[i] = this.m_trainingInstances.attribute(i).name();
            if (this.m_trainingInstances.attribute(i).isNominal()) {
                int n = i;
                stringArray[n] = stringArray[n] + LocalString.get(" (Nom)");
            } else {
                int n = i;
                stringArray[n] = stringArray[n] + LocalString.get(" (Num)");
            }
            if (!this.m_trainingInstances.attribute(i).isNumeric()) continue;
            vector.addElement("X: " + stringArray[i]);
            vector2.addElement("Y: " + stringArray[i]);
        }
        this.m_classAttBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.m_xAttBox.setModel(new DefaultComboBoxModel(vector));
        this.m_yAttBox.setModel(new DefaultComboBoxModel(vector2));
        if (vector.size() > 1) {
            this.m_yAttBox.setSelectedIndex(1);
        }
        this.m_classAttBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoundaryVisualizer.this.configureForClassAttribute();
            }
        });
        this.m_xAttBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (vector.size() > 1 && BoundaryVisualizer.this.m_xAttBox.getSelectedIndex() == BoundaryVisualizer.this.m_yAttBox.getSelectedIndex()) {
                        BoundaryVisualizer.this.m_xAttBox.setSelectedIndex((BoundaryVisualizer.this.m_xAttBox.getSelectedIndex() + 1) % vector.size());
                    }
                    BoundaryVisualizer.this.computeBounds();
                    BoundaryVisualizer.this.repaint();
                }
            }
        });
        this.m_yAttBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (vector.size() > 1 && BoundaryVisualizer.this.m_yAttBox.getSelectedIndex() == BoundaryVisualizer.this.m_xAttBox.getSelectedIndex()) {
                        BoundaryVisualizer.this.m_yAttBox.setSelectedIndex((BoundaryVisualizer.this.m_yAttBox.getSelectedIndex() + 1) % vector.size());
                    }
                    BoundaryVisualizer.this.computeBounds();
                    BoundaryVisualizer.this.repaint();
                }
            }
        });
        this.computeBounds();
        this.revalidate();
        this.repaint();
    }

    private void configureForClassAttribute() {
        int n = this.m_classAttBox.getSelectedIndex();
        if (n >= 0) {
            if (!this.m_trainingInstances.attribute(n).isNominal()) {
                this.m_startBut.setEnabled(false);
            } else {
                this.m_startBut.setEnabled(true);
                FastVector fastVector = new FastVector();
                for (int i = 0; i < this.m_trainingInstances.attribute(n).numValues(); ++i) {
                    fastVector.addElement(BoundaryPanel.DEFAULT_COLORS[i % BoundaryPanel.DEFAULT_COLORS.length]);
                    this.m_classPanel.setColours(fastVector);
                    this.m_boundaryPanel.setColors(fastVector);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 2) {
                System.err.println(LocalString.get("Usage : BoundaryPanel <dataset> <classifier ") + LocalString.get("[classifier options]>"));
                System.exit(1);
            }
            final JFrame jFrame = new JFrame(LocalString.get("Weka classification boundary visualizer"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            BoundaryVisualizer boundaryVisualizer = new BoundaryVisualizer();
            jFrame.getContentPane().add((Component)boundaryVisualizer, "Center");
            jFrame.setSize(boundaryVisualizer.getMinimumSize());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            jFrame.setResizable(false);
            Dimension dimension = jFrame.getSize();
            System.err.println(LocalString.get("Loading instances from : ") + stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            Instances instances = new Instances(bufferedReader);
            boundaryVisualizer.setInstances(instances);
            String[] stringArray2 = null;
            if (stringArray.length > 2) {
                stringArray2 = new String[stringArray.length - 2];
                for (int i = 2; i < stringArray.length; ++i) {
                    stringArray2[i - 2] = stringArray[i];
                }
            }
            Classifier classifier = Classifier.forName(stringArray[1], stringArray2);
            boundaryVisualizer.setClassifier(classifier);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class AxisPanel
    extends JPanel {
        private static final int MAX_PRECISION = 10;
        private boolean m_vertical = false;
        private final int PAD = 5;
        private FontMetrics m_fontMetrics;
        private int m_fontHeight;

        public AxisPanel(boolean bl) {
            this.m_vertical = bl;
            this.setBackground(Color.black);
            String string = this.getFont().getFamily();
            Font font = new Font(string, 0, 10);
            this.setFont(font);
        }

        public Dimension getPreferredSize() {
            if (this.m_fontMetrics == null) {
                Graphics graphics = this.getGraphics();
                this.m_fontMetrics = graphics.getFontMetrics();
                this.m_fontHeight = this.m_fontMetrics.getHeight();
            }
            if (!this.m_vertical) {
                return new Dimension(this.getSize().width, 7 + this.m_fontHeight);
            }
            return new Dimension(50, this.getSize().height);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.setBackground(Color.black);
            if (this.m_fontMetrics == null) {
                this.m_fontMetrics = graphics.getFontMetrics();
                this.m_fontHeight = this.m_fontMetrics.getHeight();
            }
            Dimension dimension = this.getSize();
            Dimension dimension2 = BoundaryVisualizer.this.m_boundaryPanel.getSize();
            graphics.setColor(Color.gray);
            int n = this.m_fontMetrics.getAscent();
            if (!this.m_vertical) {
                graphics.drawLine(dimension.width, 5, dimension.width - dimension2.width, 5);
                if (BoundaryVisualizer.this.getInstances() != null) {
                    int n2 = 1;
                    int n3 = 1;
                    int n4 = (int)Math.abs(BoundaryVisualizer.this.m_maxX);
                    double d = Math.abs(BoundaryVisualizer.this.m_maxX) - (double)n4;
                    int n5 = n4 > 0 ? (int)(Math.log(n4) / Math.log(10.0)) : 1;
                    int n6 = n2 = d > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_maxX)) / Math.log(10.0)) + 2 : 1;
                    if (n2 > 10) {
                        n2 = 1;
                    }
                    String string = Utils.doubleToString(BoundaryVisualizer.this.m_maxX, n5 + 1 + n2, n2);
                    n4 = (int)Math.abs(BoundaryVisualizer.this.m_minX);
                    d = Math.abs(BoundaryVisualizer.this.m_minX) - (double)n4;
                    n5 = n4 > 0 ? (int)(Math.log(n4) / Math.log(10.0)) : 1;
                    int n7 = n3 = d > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_minX)) / Math.log(10.0)) + 2 : 1;
                    if (n3 > 10) {
                        n3 = 1;
                    }
                    String string2 = Utils.doubleToString(BoundaryVisualizer.this.m_minX, n5 + 1 + n3, n3);
                    graphics.drawString(string2, dimension.width - dimension2.width, 5 + n + 2);
                    int n8 = this.m_fontMetrics.stringWidth(string);
                    graphics.drawString(string, dimension.width - n8, 5 + n + 2);
                }
            } else {
                graphics.drawLine(dimension.width - 5, 0, dimension.width - 5, dimension2.height);
                if (BoundaryVisualizer.this.getInstances() != null) {
                    int n9 = 1;
                    int n10 = 1;
                    int n11 = (int)Math.abs(BoundaryVisualizer.this.m_maxY);
                    double d = Math.abs(BoundaryVisualizer.this.m_maxY) - (double)n11;
                    int n12 = n11 > 0 ? (int)(Math.log(n11) / Math.log(10.0)) : 1;
                    int n13 = n9 = d > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_maxY)) / Math.log(10.0)) + 2 : 1;
                    if (n9 > 10) {
                        n9 = 1;
                    }
                    String string = Utils.doubleToString(BoundaryVisualizer.this.m_maxY, n12 + 1 + n9, n9);
                    n11 = (int)Math.abs(BoundaryVisualizer.this.m_minY);
                    d = Math.abs(BoundaryVisualizer.this.m_minY) - (double)n11;
                    n12 = n11 > 0 ? (int)(Math.log(n11) / Math.log(10.0)) : 1;
                    int n14 = n10 = d > 0.0 ? (int)Math.abs(Math.log(Math.abs(BoundaryVisualizer.this.m_minY)) / Math.log(10.0)) + 2 : 1;
                    if (n10 > 10) {
                        n10 = 1;
                    }
                    String string3 = Utils.doubleToString(BoundaryVisualizer.this.m_minY, n12 + 1 + n10, n10);
                    int n15 = this.m_fontMetrics.stringWidth(string3);
                    graphics.drawString(string3, dimension.width - 5 - n15 - 2, dimension2.height);
                    n15 = this.m_fontMetrics.stringWidth(string);
                    graphics.drawString(string, dimension.width - 5 - n15 - 2, n);
                }
            }
        }
    }
}

