/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.LocalString;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.experiment.Experiment;
import weka.experiment.RemoteExperiment;
import weka.experiment.RemoteExperimentEvent;
import weka.experiment.RemoteExperimentListener;
import weka.gui.LogPanel;
import weka.gui.experiment.ResultsPanel;

public class RunPanel
extends JPanel
implements ActionListener {
    protected static final String NOT_RUNNING = LocalString.get("Not running");
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    protected LogPanel m_Log = new LogPanel();
    protected Experiment m_Exp;
    protected Thread m_RunThread = null;
    protected ResultsPanel m_ResultsPanel = null;

    public void setResultsPanel(ResultsPanel resultsPanel) {
        this.m_ResultsPanel = resultsPanel;
    }

    public RunPanel() {
        this.m_StartBut.addActionListener(this);
        this.m_StopBut.addActionListener(this);
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_Log.statusMessage(NOT_RUNNING);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_StartBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_StopBut, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)this.m_Log, "Center");
    }

    public RunPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public void setExperiment(Experiment experiment) {
        this.m_Exp = experiment;
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_StartBut) {
            if (this.m_RunThread == null) {
                try {
                    this.m_RunThread = new ExperimentRunner(this.m_Exp);
                    this.m_RunThread.setPriority(1);
                    this.m_RunThread.start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logMessage(LocalString.get("Problem creating experiment copy to run: ") + exception.getMessage());
                }
            }
        } else if (actionEvent.getSource() == this.m_StopBut) {
            this.m_StopBut.setEnabled(false);
            this.logMessage(LocalString.get("User aborting experiment. "));
            if (this.m_Exp instanceof RemoteExperiment) {
                this.logMessage(LocalString.get("Waiting for remote tasks to ") + "complete...");
            }
            ((ExperimentRunner)this.m_RunThread).abortExperiment();
            this.m_RunThread = null;
        }
    }

    protected void logMessage(String string) {
        this.m_Log.logMessage(string);
    }

    protected void statusMessage(String string) {
        this.m_Log.statusMessage(string);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            boolean bl = Utils.getFlag('l', stringArray);
            String string = Utils.getOption('f', stringArray);
            if (bl && string.length() == 0) {
                throw new Exception(LocalString.get("A filename must be given with the -f option"));
            }
            Experiment experiment = null;
            if (bl) {
                object2 = new FileInputStream(string);
                object = new ObjectInputStream(new BufferedInputStream((InputStream)object2));
                Object object3 = ((ObjectInputStream)object).readObject();
                experiment = object3 instanceof RemoteExperiment ? (RemoteExperiment)object3 : (Experiment)object3;
                ((ObjectInputStream)object).close();
            } else {
                experiment = new Experiment();
            }
            System.err.println(LocalString.get("Initial Experiment:\n") + experiment.toString());
            object2 = new JFrame(LocalString.get("Run Weka Experiment"));
            ((JFrame)object2).getContentPane().setLayout(new BorderLayout());
            object = new RunPanel(experiment);
            ((JFrame)object2).getContentPane().add((Component)object, "Center");
            ((Window)object2).addWindowListener(new WindowAdapter((RunPanel)object, (JFrame)object2){
                final /* synthetic */ RunPanel val$sp;
                final /* synthetic */ JFrame val$jf;
                {
                    this.val$sp = runPanel;
                    this.val$jf = jFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    System.err.println(LocalString.get("\nExperiment Configuration\n") + this.val$sp.m_Exp.toString());
                    this.val$jf.dispose();
                    System.exit(0);
                }
            });
            ((Window)object2).pack();
            ((Window)object2).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    class ExperimentRunner
    extends Thread
    implements Serializable {
        Experiment m_ExpCopy;

        public ExperimentRunner(Experiment experiment) throws Exception {
            if (experiment == null) {
                System.err.println(LocalString.get("Null experiment!!!"));
            } else {
                System.err.println(LocalString.get("Running experiment: ") + experiment.toString());
            }
            System.err.println(LocalString.get("Writing experiment copy"));
            SerializedObject serializedObject = new SerializedObject(experiment);
            System.err.println(LocalString.get("Reading experiment copy"));
            this.m_ExpCopy = (Experiment)serializedObject.getObject();
            System.err.println(LocalString.get("Made experiment copy"));
        }

        public void abortExperiment() {
            if (this.m_ExpCopy instanceof RemoteExperiment) {
                ((RemoteExperiment)this.m_ExpCopy).abortExperiment();
                RunPanel.this.m_StopBut.setEnabled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunPanel.this.m_StartBut.setEnabled(false);
            RunPanel.this.m_StopBut.setEnabled(true);
            if (RunPanel.this.m_ResultsPanel != null) {
                RunPanel.this.m_ResultsPanel.setExperiment(null);
            }
            try {
                if (this.m_ExpCopy instanceof RemoteExperiment) {
                    System.err.println(LocalString.get("Adding a listener"));
                    ((RemoteExperiment)this.m_ExpCopy).addRemoteExperimentListener(new RemoteExperimentListener(){

                        public void remoteExperimentStatus(RemoteExperimentEvent remoteExperimentEvent) {
                            if (remoteExperimentEvent.m_statusMessage) {
                                RunPanel.this.statusMessage(remoteExperimentEvent.m_messageString);
                            }
                            if (remoteExperimentEvent.m_logMessage) {
                                RunPanel.this.logMessage(remoteExperimentEvent.m_messageString);
                            }
                            if (remoteExperimentEvent.m_experimentFinished) {
                                RunPanel.this.m_RunThread = null;
                                RunPanel.this.m_StartBut.setEnabled(true);
                                RunPanel.this.m_StopBut.setEnabled(false);
                                RunPanel.this.statusMessage(NOT_RUNNING);
                            }
                        }
                    });
                }
                RunPanel.this.logMessage("Started");
                RunPanel.this.statusMessage("Initializing...");
                this.m_ExpCopy.initialize();
                int n = 0;
                if (!(this.m_ExpCopy instanceof RemoteExperiment)) {
                    RunPanel.this.statusMessage("Iterating...");
                    while (RunPanel.this.m_RunThread != null && this.m_ExpCopy.hasMoreIterations()) {
                        try {
                            String string = "Iteration:";
                            if (this.m_ExpCopy.getUsePropertyIterator()) {
                                int n2 = this.m_ExpCopy.getCurrentPropertyNumber();
                                String string2 = this.m_ExpCopy.getPropertyArray().getClass().getComponentType().getName();
                                int n3 = string2.lastIndexOf(46);
                                if (n3 != -1) {
                                    string2 = string2.substring(n3 + 1);
                                }
                                String string3 = " " + string2 + "=" + (n2 + 1) + ":" + this.m_ExpCopy.getPropertyArrayValue(n2).getClass().getName();
                                string = string + string3;
                            }
                            String string4 = ((File)this.m_ExpCopy.getDatasets().elementAt(this.m_ExpCopy.getCurrentDatasetNumber())).getName();
                            string = string + LocalString.get(" Dataset=") + string4 + LocalString.get(" Run=") + this.m_ExpCopy.getCurrentRunNumber();
                            RunPanel.this.statusMessage(string);
                            this.m_ExpCopy.nextIteration();
                        }
                        catch (Exception exception) {
                            ++n;
                            RunPanel.this.logMessage(exception.getMessage());
                            exception.printStackTrace();
                            boolean bl = false;
                            if (bl) {
                                this.m_ExpCopy.advanceCounters();
                                continue;
                            }
                            RunPanel.this.m_RunThread = null;
                        }
                    }
                    RunPanel.this.statusMessage("Postprocessing...");
                    this.m_ExpCopy.postProcess();
                    if (RunPanel.this.m_RunThread == null) {
                        RunPanel.this.logMessage("Interrupted");
                    } else {
                        RunPanel.this.logMessage("Finished");
                    }
                    if (n == 1) {
                        RunPanel.this.logMessage(LocalString.get("There was ") + n + LocalString.get(" error"));
                    } else {
                        RunPanel.this.logMessage(LocalString.get("There were ") + n + LocalString.get(" errors"));
                    }
                    RunPanel.this.statusMessage(NOT_RUNNING);
                } else {
                    RunPanel.this.statusMessage(LocalString.get("Remote experiment running..."));
                    ((RemoteExperiment)this.m_ExpCopy).runExperiment();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
                RunPanel.this.statusMessage(exception.getMessage());
            }
            finally {
                if (RunPanel.this.m_ResultsPanel != null) {
                    RunPanel.this.m_ResultsPanel.setExperiment(this.m_ExpCopy);
                }
                if (!(this.m_ExpCopy instanceof RemoteExperiment)) {
                    RunPanel.this.m_RunThread = null;
                    RunPanel.this.m_StartBut.setEnabled(true);
                    RunPanel.this.m_StopBut.setEnabled(false);
                    System.err.println("Done...");
                }
            }
        }
    }
}

