/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.GainRatioAttributeEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class RankSearch
extends ASSearch
implements OptionHandler {
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private BitSet m_best_group;
    private ASEvaluation m_ASEval;
    private ASEvaluation m_SubsetEval;
    private Instances m_Instances;
    private double m_bestMerit;
    private int[] m_Ranking;

    public String globalInfo() {
        return LocalString.get("RankSearch : \n\n") + LocalString.get("Uses an attribute/subset evaluator to rank all attributes. ") + LocalString.get("If a subset evaluator is specified, then a forward selection ") + LocalString.get("search is used to generate a ranked list. From the ranked ") + LocalString.get("list of attributes, subsets of increasing size are evaluated, ie. ") + LocalString.get("The best attribute, the best attribute plus the next best attribute, ") + LocalString.get("etc.... The best attribute set is reported. RankSearch is linear in ") + LocalString.get("the number of attributes if a simple attribute evaluator is used ") + LocalString.get("such as GainRatioAttributeEval.\n");
    }

    public RankSearch() {
        this.resetOptions();
    }

    public String attributeEvaluatorTipText() {
        return LocalString.get("Attribute evaluator to use for generating a ranking.");
    }

    public void setAttributeEvaluator(ASEvaluation aSEvaluation) {
        this.m_ASEval = aSEvaluation;
    }

    public ASEvaluation getAttributeEvaluator() {
        return this.m_ASEval;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option(LocalString.get("\tclass name of attribute evaluator to") + LocalString.get("\n\tuse for ranking. Place any") + LocalString.get("\n\tevaluator options LAST on the") + LocalString.get("\n\tcommand line following a \"--\".") + LocalString.get("\n\teg. -A weka.attributeSelection.") + LocalString.get("GainRatioAttributeEval ... ") + "-- -M", "A", 1, LocalString.get("-A <attribute evaluator>")));
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, LocalString.get("\nOptions specific to") + LocalString.get("evaluator ") + this.m_ASEval.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_ASEval)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('A', stringArray);
        if (string.length() == 0) {
            throw new Exception(LocalString.get("An attribute evaluator  must be specified with") + LocalString.get("-A option"));
        }
        this.setAttributeEvaluator(ASEvaluation.forName(string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_ASEval)).getOptions();
        }
        String[] stringArray2 = new String[4 + stringArray.length];
        int n = 0;
        if (this.getAttributeEvaluator() != null) {
            stringArray2[n++] = "-A";
            stringArray2[n++] = this.getAttributeEvaluator().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    protected void resetOptions() {
        this.m_ASEval = new GainRatioAttributeEval();
        this.m_Ranking = null;
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        ASSearch aSSearch;
        double d = -1.7976931348623157E308;
        BitSet bitSet = null;
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + LocalString.get(" is not a ") + LocalString.get("Subset evaluator!"));
        }
        this.m_SubsetEval = aSEvaluation;
        this.m_Instances = instances;
        this.m_numAttribs = this.m_Instances.numAttributes();
        if (this.m_ASEval instanceof UnsupervisedAttributeEvaluator || this.m_ASEval instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = this.m_Instances.classIndex();
        }
        if (this.m_ASEval instanceof AttributeEvaluator) {
            aSSearch = new Ranker();
            ((AttributeEvaluator)this.m_ASEval).buildEvaluator(this.m_Instances);
            if (this.m_ASEval instanceof AttributeTransformer) {
                this.m_Instances = ((AttributeTransformer)((Object)this.m_ASEval)).transformedData();
                ((SubsetEvaluator)this.m_SubsetEval).buildEvaluator(this.m_Instances);
            }
            this.m_Ranking = ((Ranker)aSSearch).search((AttributeEvaluator)this.m_ASEval, this.m_Instances);
        } else {
            aSSearch = new GreedyStepwise();
            ((GreedyStepwise)aSSearch).setGenerateRanking(true);
            ((SubsetEvaluator)this.m_ASEval).buildEvaluator(this.m_Instances);
            ((GreedyStepwise)aSSearch).search(this.m_ASEval, this.m_Instances);
            double[][] dArray = ((GreedyStepwise)aSSearch).rankedAttributes();
            this.m_Ranking = new int[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.m_Ranking[i] = (int)dArray[i][0];
            }
        }
        for (int i = 0; i < this.m_Ranking.length; ++i) {
            BitSet bitSet2 = new BitSet(this.m_numAttribs);
            for (int j = 0; j <= i; ++j) {
                bitSet2.set(this.m_Ranking[j]);
            }
            double d2 = ((SubsetEvaluator)this.m_SubsetEval).evaluateSubset(bitSet2);
            if (!(d2 > d)) continue;
            d = d2;
            bitSet = bitSet2;
        }
        this.m_bestMerit = d;
        return this.attributeList(bitSet);
    }

    private int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("\tRankSearch :\n"));
        stringBuffer.append(LocalString.get("\tAttribute evaluator : ") + this.getAttributeEvaluator().getClass().getName() + " ");
        if (this.m_ASEval instanceof OptionHandler) {
            String[] stringArray = new String[]{};
            stringArray = ((OptionHandler)((Object)this.m_ASEval)).getOptions();
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append(stringArray[n] + ' ');
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(LocalString.get("\tAttribute ranking : \n"));
        int n2 = (int)(Math.log(this.m_Ranking.length) / Math.log(10.0) + 1.0);
        for (n = 0; n < this.m_Ranking.length; ++n) {
            stringBuffer.append("\t " + Utils.doubleToString(this.m_Ranking[n] + 1, n2, 0) + " " + this.m_Instances.attribute(this.m_Ranking[n]).name() + '\n');
        }
        stringBuffer.append(LocalString.get("\tMerit of best subset found : "));
        n = 3;
        double d = this.m_bestMerit - (double)((int)this.m_bestMerit);
        if (Math.abs(this.m_bestMerit) > 0.0) {
            n = (int)Math.abs(Math.log(Math.abs(this.m_bestMerit)) / Math.log(10.0)) + 2;
        }
        d = Math.abs(d) > 0.0 ? Math.abs(Math.log(Math.abs(d)) / Math.log(10.0)) + 3.0 : 2.0;
        stringBuffer.append(Utils.doubleToString(Math.abs(this.m_bestMerit), n + (int)d, (int)d) + "\n");
        return stringBuffer.toString();
    }
}

