/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.DecisionStump;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RacedIncrementalLogitBoost
extends RandomizableSingleClassifierEnhancer
implements UpdateableClassifier {
    public static final int PRUNETYPE_NONE = 0;
    public static final int PRUNETYPE_LOGLIKELIHOOD = 1;
    public static final Tag[] TAGS_PRUNETYPE = new Tag[]{new Tag(0, LocalString.get("No pruning")), new Tag(1, LocalString.get("Log likelihood pruning"))};
    protected FastVector m_committees;
    protected int m_PruningType = 1;
    protected boolean m_UseResampling = false;
    protected int m_NumClasses;
    protected static final double Z_MAX = 4.0;
    protected Instances m_NumericClassData;
    protected Attribute m_ClassAttribute;
    protected int m_minChunkSize = 500;
    protected int m_maxChunkSize = 2000;
    protected int m_validationChunkSize = 1000;
    protected int m_numInstancesConsumed;
    protected Instances m_validationSet;
    protected Instances m_currentSet;
    protected Committee m_bestCommittee;
    protected ZeroR m_zeroR = null;
    protected boolean m_validationSetChanged;
    protected int m_maxBatchSizeRequired;
    protected Random m_RandomInstance = null;

    public RacedIncrementalLogitBoost() {
        this.m_Classifier = new DecisionStump();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.DecisionStump";
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.m_RandomInstance = new Random(this.m_Seed);
        int n = instances.classIndex();
        if (instances.classAttribute().isNumeric()) {
            throw new Exception(LocalString.get("RacedIncrementalLogitBoost can't handle a numeric class!"));
        }
        if (this.m_Classifier == null) {
            throw new Exception(LocalString.get("A base classifier has not been specified!"));
        }
        if (!(this.m_Classifier instanceof WeightedInstancesHandler) && !this.m_UseResampling) {
            this.m_UseResampling = true;
        }
        if (instances.checkForStringAttributes()) {
            throw new Exception(LocalString.get("Can't handle string attributes!"));
        }
        this.m_NumClasses = instances.numClasses();
        this.m_ClassAttribute = instances.classAttribute();
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        instances2.setClassIndex(-1);
        instances2.deleteAttributeAt(n);
        instances2.insertAttributeAt(new Attribute(LocalString.get("'pseudo class'")), n);
        instances2.setClassIndex(n);
        this.m_NumericClassData = new Instances(instances2, 0);
        instances = new Instances(instances);
        instances.randomize(this.m_RandomInstance);
        this.m_committees = new FastVector();
        for (int i = this.m_minChunkSize; i <= this.m_maxChunkSize; i *= 2) {
            this.m_committees.addElement(new Committee(i));
            this.m_maxBatchSizeRequired = i;
        }
        this.m_validationSet = new Instances(instances, this.m_validationChunkSize);
        this.m_currentSet = new Instances(instances, this.m_maxBatchSizeRequired);
        this.m_bestCommittee = null;
        this.m_numInstancesConsumed = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.updateClassifier(instances.instance(i));
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        ++this.m_numInstancesConsumed;
        if (this.m_validationSet.numInstances() < this.m_validationChunkSize) {
            this.m_validationSet.add(instance);
            this.m_validationSetChanged = true;
        } else {
            double d;
            Committee committee;
            int n;
            this.m_currentSet.add(instance);
            boolean bl = false;
            for (n = 0; n < this.m_committees.size(); ++n) {
                committee = (Committee)this.m_committees.elementAt(n);
                if (!committee.update()) continue;
                bl = true;
                if (this.m_PruningType == 1) {
                    double d2 = committee.logLikelihood();
                    d = committee.logLikelihoodAfter();
                    if (d >= d2 && committee.committeeSize() > 1) {
                        committee.pruneLastModel();
                        if (!this.m_Debug) continue;
                        System.out.println(LocalString.get("Pruning ") + committee.chunkSize() + LocalString.get(" committee (") + d2 + " < " + d + ")");
                        continue;
                    }
                    committee.keepLastModel();
                    continue;
                }
                committee.keepLastModel();
            }
            if (bl) {
                if (this.m_Debug) {
                    System.out.println(LocalString.get("After consuming ") + this.m_numInstancesConsumed + LocalString.get(" instances... (") + this.m_validationSet.numInstances() + " + " + this.m_currentSet.numInstances() + LocalString.get(" instances currently in memory)"));
                }
                double d3 = 1.0;
                for (int i = 0; i < this.m_committees.size(); ++i) {
                    Committee committee2 = (Committee)this.m_committees.elementAt(i);
                    if (committee2.committeeSize() <= 0) continue;
                    d = committee2.validationError();
                    double d4 = committee2.logLikelihood();
                    if (this.m_Debug) {
                        System.out.println(LocalString.get("Chunk size ") + committee2.chunkSize() + LocalString.get(" with ") + committee2.committeeSize() + LocalString.get(" models, has validation error of ") + d + LocalString.get(", log likelihood of ") + d4);
                    }
                    if (!(d < d3)) continue;
                    d3 = d;
                    this.m_bestCommittee = committee2;
                }
            }
            if (this.m_currentSet.numInstances() >= this.m_maxBatchSizeRequired) {
                this.m_currentSet = new Instances(this.m_currentSet, this.m_maxBatchSizeRequired);
                for (n = 0; n < this.m_committees.size(); ++n) {
                    committee = (Committee)this.m_committees.elementAt(n);
                    committee.resetConsumed();
                }
            }
        }
    }

    protected static double RtoP(double[] dArray, int n) throws Exception {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        double d2 = 0.0;
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.exp(dArray[i] - d);
            d2 += dArray2[i];
        }
        if (d2 == 0.0) {
            throw new Exception(LocalString.get("Can't normalize"));
        }
        return dArray2[n] / d2;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_bestCommittee != null) {
            return this.m_bestCommittee.distributionForInstance(instance);
        }
        if (this.m_validationSetChanged || this.m_zeroR == null) {
            this.m_zeroR = new ZeroR();
            this.m_zeroR.buildClassifier(this.m_validationSet);
            this.m_validationSetChanged = false;
        }
        return this.m_zeroR.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(9);
        vector.addElement(new Option(LocalString.get("\tMinimum size of chunks.\n") + LocalString.get("\t(default 500)"), "C", 1, LocalString.get("-C <num>")));
        vector.addElement(new Option(LocalString.get("\tMaximum size of chunks.\n") + LocalString.get("\t(default 2000)"), "M", 1, LocalString.get("-M <num>")));
        vector.addElement(new Option(LocalString.get("\tSize of validation set.\n") + LocalString.get("\t(default 1000)"), "V", 1, LocalString.get("-V <num>")));
        vector.addElement(new Option(LocalString.get("\tCommittee pruning to perform.\n") + LocalString.get("\t0=none, 1=log likelihood (default)"), "P", 1, LocalString.get("-P <pruning type>")));
        vector.addElement(new Option(LocalString.get("\tUse resampling for boosting."), "Q", 0, "-Q"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setMinChunkSize(Integer.parseInt(string));
        } else {
            this.setMinChunkSize(500);
        }
        String string2 = Utils.getOption('M', stringArray);
        if (string2.length() != 0) {
            this.setMaxChunkSize(Integer.parseInt(string2));
        } else {
            this.setMaxChunkSize(2000);
        }
        String string3 = Utils.getOption('V', stringArray);
        if (string3.length() != 0) {
            this.setValidationChunkSize(Integer.parseInt(string3));
        } else {
            this.setValidationChunkSize(1000);
        }
        String string4 = Utils.getOption('P', stringArray);
        if (string4.length() != 0) {
            this.setPruningType(new SelectedTag(Integer.parseInt(string4), TAGS_PRUNETYPE));
        } else {
            this.setPruningType(new SelectedTag(1, TAGS_PRUNETYPE));
        }
        this.setUseResampling(Utils.getFlag('Q', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 9];
        int n = 0;
        if (this.getUseResampling()) {
            stringArray2[n++] = "-Q";
        }
        stringArray2[n++] = "-C";
        stringArray2[n++] = "" + this.getMinChunkSize();
        stringArray2[n++] = "-M";
        stringArray2[n++] = "" + this.getMaxChunkSize();
        stringArray2[n++] = "-V";
        stringArray2[n++] = "" + this.getValidationChunkSize();
        stringArray2[n++] = "-P";
        stringArray2[n++] = "" + this.m_PruningType;
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return LocalString.get("Classifier for incremental learning of large datasets by way of racing logit-boosted committees.");
    }

    public String minChunkSizeTipText() {
        return LocalString.get("The minimum number of instances to train the base learner with.");
    }

    public void setMinChunkSize(int n) {
        this.m_minChunkSize = n;
    }

    public int getMinChunkSize() {
        return this.m_minChunkSize;
    }

    public String maxChunkSizeTipText() {
        return LocalString.get("The maximum number of instances to train the base learner with. The chunk sizes used will start at minChunkSize and grow twice as large for as many times as they are less than or equal to the maximum size.");
    }

    public void setMaxChunkSize(int n) {
        this.m_maxChunkSize = n;
    }

    public int getMaxChunkSize() {
        return this.m_maxChunkSize;
    }

    public String validationChunkSizeTipText() {
        return LocalString.get("The number of instances to hold out for validation. These instances will be taken from the beginning of the stream, so learning will not start until these instances have been consumed first.");
    }

    public void setValidationChunkSize(int n) {
        this.m_validationChunkSize = n;
    }

    public int getValidationChunkSize() {
        return this.m_validationChunkSize;
    }

    public String pruningTypeTipText() {
        return LocalString.get("The pruning method to use within each committee. Log likelihood pruning will discard new models if they have a negative effect on the log likelihood of the validation data.");
    }

    public void setPruningType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_PRUNETYPE) {
            this.m_PruningType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getPruningType() {
        return new SelectedTag(this.m_PruningType, TAGS_PRUNETYPE);
    }

    public String useResamplingTipText() {
        return LocalString.get("Force the use of resampling data rather than using the weight-handling capabilities of the base classifier. Resampling is always used if the base classifier cannot handle weighted instances.");
    }

    public void setUseResampling(boolean bl) {
        this.m_UseResampling = bl;
    }

    public boolean getUseResampling() {
        return this.m_UseResampling;
    }

    public int getBestCommitteeChunkSize() {
        if (this.m_bestCommittee != null) {
            return this.m_bestCommittee.chunkSize();
        }
        return 0;
    }

    public int getBestCommitteeSize() {
        if (this.m_bestCommittee != null) {
            return this.m_bestCommittee.committeeSize();
        }
        return 0;
    }

    public double getBestCommitteeErrorEstimate() {
        if (this.m_bestCommittee != null) {
            try {
                return this.m_bestCommittee.validationError() * 100.0;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                return 100.0;
            }
        }
        return 100.0;
    }

    public double getBestCommitteeLLEstimate() {
        if (this.m_bestCommittee != null) {
            try {
                return this.m_bestCommittee.logLikelihood();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                return Double.MAX_VALUE;
            }
        }
        return Double.MAX_VALUE;
    }

    public String toString() {
        if (this.m_bestCommittee != null) {
            return this.m_bestCommittee.toString();
        }
        if ((this.m_validationSetChanged || this.m_zeroR == null) && this.m_validationSet != null && this.m_validationSet.numInstances() > 0) {
            this.m_zeroR = new ZeroR();
            try {
                this.m_zeroR.buildClassifier(this.m_validationSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_validationSetChanged = false;
        }
        if (this.m_zeroR != null) {
            return LocalString.get("RacedIncrementalLogitBoost: insufficient data to build model, resorting to ZeroR:\n\n") + this.m_zeroR.toString();
        }
        return LocalString.get("RacedIncrementalLogitBoost: no model built yet.");
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new RacedIncrementalLogitBoost(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    protected class Committee
    implements Serializable {
        protected int m_chunkSize;
        protected int m_instancesConsumed;
        protected FastVector m_models;
        protected double m_lastValidationError;
        protected double m_lastLogLikelihood;
        protected boolean m_modelHasChanged;
        protected boolean m_modelHasChangedLL;
        protected double[][] m_validationFs;
        protected double[][] m_newValidationFs;

        public Committee(int n) {
            this.m_chunkSize = n;
            this.m_instancesConsumed = 0;
            this.m_models = new FastVector();
            this.m_lastValidationError = 1.0;
            this.m_lastLogLikelihood = Double.MAX_VALUE;
            this.m_modelHasChanged = true;
            this.m_modelHasChangedLL = true;
            this.m_validationFs = new double[RacedIncrementalLogitBoost.this.m_validationChunkSize][RacedIncrementalLogitBoost.this.m_NumClasses];
            this.m_newValidationFs = new double[RacedIncrementalLogitBoost.this.m_validationChunkSize][RacedIncrementalLogitBoost.this.m_NumClasses];
        }

        public boolean update() throws Exception {
            boolean bl = false;
            while (RacedIncrementalLogitBoost.this.m_currentSet.numInstances() - this.m_instancesConsumed >= this.m_chunkSize) {
                Classifier[] classifierArray = this.boost(new Instances(RacedIncrementalLogitBoost.this.m_currentSet, this.m_instancesConsumed, this.m_chunkSize));
                for (int i = 0; i < RacedIncrementalLogitBoost.this.m_validationSet.numInstances(); ++i) {
                    this.m_newValidationFs[i] = this.updateFS(RacedIncrementalLogitBoost.this.m_validationSet.instance(i), classifierArray, this.m_validationFs[i]);
                }
                this.m_models.addElement(classifierArray);
                this.m_instancesConsumed += this.m_chunkSize;
                bl = true;
            }
            if (bl) {
                this.m_modelHasChanged = true;
                this.m_modelHasChangedLL = true;
            }
            return bl;
        }

        public void resetConsumed() {
            this.m_instancesConsumed = 0;
        }

        public void pruneLastModel() {
            if (this.m_models.size() > 0) {
                this.m_models.removeElementAt(this.m_models.size() - 1);
                this.m_modelHasChanged = true;
                this.m_modelHasChangedLL = true;
            }
        }

        public void keepLastModel() throws Exception {
            this.m_validationFs = this.m_newValidationFs;
            this.m_newValidationFs = new double[RacedIncrementalLogitBoost.this.m_validationChunkSize][RacedIncrementalLogitBoost.this.m_NumClasses];
            this.m_modelHasChanged = true;
            this.m_modelHasChangedLL = true;
        }

        public double logLikelihood() throws Exception {
            if (this.m_modelHasChangedLL) {
                double d = 0.0;
                for (int i = 0; i < RacedIncrementalLogitBoost.this.m_validationSet.numInstances(); ++i) {
                    Instance instance = RacedIncrementalLogitBoost.this.m_validationSet.instance(i);
                    d += this.logLikelihood(this.m_validationFs[i], (int)instance.classValue());
                }
                this.m_lastLogLikelihood = d / (double)RacedIncrementalLogitBoost.this.m_validationSet.numInstances();
                this.m_modelHasChangedLL = false;
            }
            return this.m_lastLogLikelihood;
        }

        public double logLikelihoodAfter() throws Exception {
            double d = 0.0;
            for (int i = 0; i < RacedIncrementalLogitBoost.this.m_validationSet.numInstances(); ++i) {
                Instance instance = RacedIncrementalLogitBoost.this.m_validationSet.instance(i);
                d += this.logLikelihood(this.m_newValidationFs[i], (int)instance.classValue());
            }
            return d / (double)RacedIncrementalLogitBoost.this.m_validationSet.numInstances();
        }

        private double logLikelihood(double[] dArray, int n) throws Exception {
            return -Math.log(this.distributionForInstance(dArray)[n]);
        }

        public double validationError() throws Exception {
            if (this.m_modelHasChanged) {
                int n = 0;
                for (int i = 0; i < RacedIncrementalLogitBoost.this.m_validationSet.numInstances(); ++i) {
                    Instance instance = RacedIncrementalLogitBoost.this.m_validationSet.instance(i);
                    if (this.classifyInstance(this.m_validationFs[i]) == instance.classValue()) continue;
                    ++n;
                }
                this.m_lastValidationError = (double)n / (double)RacedIncrementalLogitBoost.this.m_validationSet.numInstances();
                this.m_modelHasChanged = false;
            }
            return this.m_lastValidationError;
        }

        public int chunkSize() {
            return this.m_chunkSize;
        }

        public int committeeSize() {
            return this.m_models.size();
        }

        public double classifyInstance(double[] dArray) throws Exception {
            double[] dArray2 = this.distributionForInstance(dArray);
            double d = 0.0;
            int n = 0;
            for (int i = 0; i < dArray2.length; ++i) {
                if (!(dArray2[i] > d)) continue;
                n = i;
                d = dArray2[i];
            }
            if (d > 0.0) {
                return n;
            }
            return Instance.missingValue();
        }

        public double classifyInstance(Instance instance) throws Exception {
            double[] dArray = this.distributionForInstance(instance);
            switch (instance.classAttribute().type()) {
                case 1: {
                    double d = 0.0;
                    int n = 0;
                    for (int i = 0; i < dArray.length; ++i) {
                        if (!(dArray[i] > d)) continue;
                        n = i;
                        d = dArray[i];
                    }
                    if (d > 0.0) {
                        return n;
                    }
                    return Instance.missingValue();
                }
                case 0: {
                    return dArray[0];
                }
            }
            return Instance.missingValue();
        }

        public double[] distributionForInstance(double[] dArray) throws Exception {
            double[] dArray2 = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
            for (int i = 0; i < RacedIncrementalLogitBoost.this.m_NumClasses; ++i) {
                dArray2[i] = RacedIncrementalLogitBoost.RtoP(dArray, i);
            }
            return dArray2;
        }

        public double[] updateFS(Instance instance, Classifier[] classifierArray, double[] dArray) throws Exception {
            instance = (Instance)instance.copy();
            instance.setDataset(RacedIncrementalLogitBoost.this.m_NumericClassData);
            double[] dArray2 = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
            double d = 0.0;
            for (int i = 0; i < RacedIncrementalLogitBoost.this.m_NumClasses; ++i) {
                dArray2[i] = classifierArray[i].classifyInstance(instance);
                d += dArray2[i];
            }
            d /= (double)RacedIncrementalLogitBoost.this.m_NumClasses;
            double[] dArray3 = new double[dArray.length];
            for (int i = 0; i < RacedIncrementalLogitBoost.this.m_NumClasses; ++i) {
                dArray3[i] = dArray[i] + (dArray2[i] - d) * (double)(RacedIncrementalLogitBoost.this.m_NumClasses - 1) / (double)RacedIncrementalLogitBoost.this.m_NumClasses;
            }
            return dArray3;
        }

        public double[] distributionForInstance(Instance instance) throws Exception {
            instance = (Instance)instance.copy();
            instance.setDataset(RacedIncrementalLogitBoost.this.m_NumericClassData);
            double[] dArray = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
            for (int i = 0; i < this.m_models.size(); ++i) {
                int n;
                double[] dArray2 = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
                double d = 0.0;
                Classifier[] classifierArray = (Classifier[])this.m_models.elementAt(i);
                for (n = 0; n < RacedIncrementalLogitBoost.this.m_NumClasses; ++n) {
                    dArray2[n] = classifierArray[n].classifyInstance(instance);
                    d += dArray2[n];
                }
                d /= (double)RacedIncrementalLogitBoost.this.m_NumClasses;
                for (n = 0; n < RacedIncrementalLogitBoost.this.m_NumClasses; ++n) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] + (dArray2[n] - d) * (double)(RacedIncrementalLogitBoost.this.m_NumClasses - 1) / (double)RacedIncrementalLogitBoost.this.m_NumClasses;
                }
            }
            double[] dArray3 = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
            for (int i = 0; i < RacedIncrementalLogitBoost.this.m_NumClasses; ++i) {
                dArray3[i] = RacedIncrementalLogitBoost.RtoP(dArray, i);
            }
            return dArray3;
        }

        protected Classifier[] boost(Instances instances) throws Exception {
            int n;
            int n2;
            Classifier[] classifierArray = Classifier.makeCopies(RacedIncrementalLogitBoost.this.m_Classifier, RacedIncrementalLogitBoost.this.m_NumClasses);
            Instances instances2 = new Instances(instances);
            instances2.deleteWithMissingClass();
            int n3 = instances2.numInstances();
            int n4 = instances.classIndex();
            instances2.setClassIndex(-1);
            instances2.deleteAttributeAt(n4);
            instances2.insertAttributeAt(new Attribute(LocalString.get("'pseudo class'")), n4);
            instances2.setClassIndex(n4);
            double[][] dArray = new double[n3][RacedIncrementalLogitBoost.this.m_NumClasses];
            double[][] dArray2 = new double[n3][RacedIncrementalLogitBoost.this.m_NumClasses];
            for (n2 = 0; n2 < RacedIncrementalLogitBoost.this.m_NumClasses; ++n2) {
                n = 0;
                int n5 = 0;
                while (n < n3) {
                    while (instances.instance(n5).classIsMissing()) {
                        ++n5;
                    }
                    dArray2[n][n2] = instances.instance(n5).classValue() == (double)n2 ? 1.0 : 0.0;
                    ++n;
                    ++n5;
                }
            }
            for (n2 = 0; n2 < this.m_models.size(); ++n2) {
                for (n = 0; n < n3; ++n) {
                    int n6;
                    double[] dArray3 = new double[RacedIncrementalLogitBoost.this.m_NumClasses];
                    double d = 0.0;
                    Classifier[] classifierArray2 = (Classifier[])this.m_models.elementAt(n2);
                    for (n6 = 0; n6 < RacedIncrementalLogitBoost.this.m_NumClasses; ++n6) {
                        dArray3[n6] = classifierArray2[n6].classifyInstance(instances2.instance(n));
                        d += dArray3[n6];
                    }
                    d /= (double)RacedIncrementalLogitBoost.this.m_NumClasses;
                    for (n6 = 0; n6 < RacedIncrementalLogitBoost.this.m_NumClasses; ++n6) {
                        double[] dArray4 = dArray[n];
                        int n7 = n6;
                        dArray4[n7] = dArray4[n7] + (dArray3[n6] - d) * (double)(RacedIncrementalLogitBoost.this.m_NumClasses - 1) / (double)RacedIncrementalLogitBoost.this.m_NumClasses;
                    }
                }
            }
            for (n2 = 0; n2 < RacedIncrementalLogitBoost.this.m_NumClasses; ++n2) {
                for (int i = 0; i < n3; ++i) {
                    double d;
                    double d2 = RacedIncrementalLogitBoost.RtoP(dArray[i], n2);
                    Instance instance = instances2.instance(i);
                    double d3 = dArray2[i][n2];
                    if (d3 == 1.0) {
                        d = 1.0 / d2;
                        if (d > 4.0) {
                            d = 4.0;
                        }
                    } else if (d3 == 0.0) {
                        d = -1.0 / (1.0 - d2);
                        if (d < -4.0) {
                            d = -4.0;
                        }
                    } else {
                        d = (d3 - d2) / (d2 * (1.0 - d2));
                    }
                    double d4 = (d3 - d2) / d;
                    instance.setValue(n4, d);
                    instance.setWeight((double)n3 * d4);
                }
                Instances instances3 = instances2;
                if (RacedIncrementalLogitBoost.this.m_UseResampling) {
                    double[] dArray5 = new double[instances2.numInstances()];
                    for (int i = 0; i < dArray5.length; ++i) {
                        dArray5[i] = instances2.instance(i).weight();
                    }
                    instances3 = instances2.resampleWithWeights(RacedIncrementalLogitBoost.this.m_RandomInstance, dArray5);
                }
                classifierArray[n2].buildClassifier(instances3);
            }
            return classifierArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LocalString.get("RacedIncrementalLogitBoost: Best committee on validation data\n"));
            stringBuffer.append(LocalString.get("Base classifiers: \n"));
            for (int i = 0; i < this.m_models.size(); ++i) {
                stringBuffer.append(LocalString.get("\nModel ") + (i + 1));
                Classifier[] classifierArray = (Classifier[])this.m_models.elementAt(i);
                for (int j = 0; j < RacedIncrementalLogitBoost.this.m_NumClasses; ++j) {
                    stringBuffer.append(LocalString.get("\n\tClass ") + (j + 1) + " (" + RacedIncrementalLogitBoost.this.m_ClassAttribute.name() + "=" + RacedIncrementalLogitBoost.this.m_ClassAttribute.value(j) + ")\n\n" + classifierArray[j].toString() + "\n");
                }
            }
            stringBuffer.append(LocalString.get("Number of models: ") + this.m_models.size() + "\n");
            stringBuffer.append(LocalString.get("Chunk size per model: ") + this.m_chunkSize + "\n");
            return stringBuffer.toString();
        }
    }
}

