/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import weka.LocalString;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.OutputZipper;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;

public class CrossValidationResultProducer
implements ResultProducer,
OptionHandler,
AdditionalMeasureProducer {
    protected Instances m_Instances;
    protected ResultListener m_ResultListener = new CSVResultListener();
    protected int m_NumFolds = 10;
    protected boolean m_debugOutput = false;
    protected OutputZipper m_ZipDest = null;
    protected File m_OutputFile = new File(new File(System.getProperty("user.dir")), "splitEvalutorOut.zip");
    protected SplitEvaluator m_SplitEvaluator = new ClassifierSplitEvaluator();
    protected String[] m_AdditionalMeasures = null;
    public static String DATASET_FIELD_NAME = LocalString.get("Dataset");
    public static String RUN_FIELD_NAME = LocalString.get("Run");
    public static String FOLD_FIELD_NAME = LocalString.get("Fold");
    public static String TIMESTAMP_FIELD_NAME = LocalString.get("Date_time");
    static /* synthetic */ Class class$weka$experiment$SplitEvaluator;

    public String globalInfo() {
        return LocalString.get("Performs a cross validation run using a supplied ") + LocalString.get("evaluator.");
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public void setResultListener(ResultListener resultListener) {
        this.m_ResultListener = resultListener;
    }

    public void setAdditionalMeasures(String[] stringArray) {
        this.m_AdditionalMeasures = stringArray;
        if (this.m_SplitEvaluator != null) {
            System.err.println(LocalString.get("CrossValidationResultProducer: setting additional ") + LocalString.get("measures for ") + LocalString.get("split evaluator"));
            this.m_SplitEvaluator.setAdditionalMeasures(this.m_AdditionalMeasures);
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        if (this.m_SplitEvaluator instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_SplitEvaluator)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (this.m_SplitEvaluator instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_SplitEvaluator)).getMeasure(string);
        }
        throw new IllegalArgumentException(LocalString.get("CrossValidationResultProducer: ") + LocalString.get("Can't return value for : ") + string + ". " + this.m_SplitEvaluator.getClass().getName() + " " + LocalString.get("is not an AdditionalMeasureProducer"));
    }

    public static Double getTimestamp() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(LocalString.get("UTC")));
        double d = (double)(calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5)) + (double)calendar.get(11) / 100.0 + (double)calendar.get(12) / 10000.0;
        return new Double(d);
    }

    public void preProcess() throws Exception {
        if (this.m_SplitEvaluator == null) {
            throw new Exception(LocalString.get("No SplitEvalutor set"));
        }
        if (this.m_ResultListener == null) {
            throw new Exception(LocalString.get("No ResultListener set"));
        }
        this.m_ResultListener.preProcess(this);
    }

    public void postProcess() throws Exception {
        this.m_ResultListener.postProcess(this);
        if (this.m_debugOutput && this.m_ZipDest != null) {
            this.m_ZipDest.finished();
            this.m_ZipDest = null;
        }
    }

    public void doRunKeys(int n) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception(LocalString.get("No Instances set"));
        }
        for (int i = 0; i < this.m_NumFolds; ++i) {
            Object[] objectArray = this.m_SplitEvaluator.getKey();
            Object[] objectArray2 = new Object[objectArray.length + 3];
            objectArray2[0] = Utils.backQuoteChars(this.m_Instances.relationName());
            objectArray2[1] = "" + n;
            objectArray2[2] = "" + (i + 1);
            System.arraycopy(objectArray, 0, objectArray2, 3, objectArray.length);
            if (!this.m_ResultListener.isResultRequired(this, objectArray2)) continue;
            this.m_ResultListener.acceptResult(this, objectArray2, null);
            continue;
        }
    }

    public void doRun(int n) throws Exception {
        if (this.getRawOutput() && this.m_ZipDest == null) {
            this.m_ZipDest = new OutputZipper(this.m_OutputFile);
        }
        if (this.m_Instances == null) {
            throw new Exception(LocalString.get("No Instances set"));
        }
        Instances instances = new Instances(this.m_Instances);
        Random random = new Random(n);
        instances.randomize(random);
        if (instances.classAttribute().isNominal()) {
            instances.stratify(this.m_NumFolds);
        }
        for (int i = 0; i < this.m_NumFolds; ++i) {
            Object[] objectArray = this.m_SplitEvaluator.getKey();
            Object[] objectArray2 = new Object[objectArray.length + 3];
            objectArray2[0] = Utils.backQuoteChars(this.m_Instances.relationName());
            objectArray2[1] = "" + n;
            objectArray2[2] = "" + (i + 1);
            System.arraycopy(objectArray, 0, objectArray2, 3, objectArray.length);
            if (!this.m_ResultListener.isResultRequired(this, objectArray2)) continue;
            Instances instances2 = instances.trainCV(this.m_NumFolds, i, random);
            Instances instances3 = instances.testCV(this.m_NumFolds, i);
            Object[] objectArray3 = this.m_SplitEvaluator.getResult(instances2, instances3);
            Object[] objectArray4 = new Object[objectArray3.length + 1];
            objectArray4[0] = CrossValidationResultProducer.getTimestamp();
            System.arraycopy(objectArray3, 0, objectArray4, 1, objectArray3.length);
            if (this.m_debugOutput) {
                String string = ("" + n + "." + (i + 1) + "." + Utils.backQuoteChars(instances.relationName()) + "." + this.m_SplitEvaluator.toString()).replace(' ', '_');
                string = Utils.removeSubstring(string, "weka.classifiers.");
                string = Utils.removeSubstring(string, "weka.filters.");
                string = Utils.removeSubstring(string, "weka.attributeSelection.");
                this.m_ZipDest.zipit(this.m_SplitEvaluator.getRawResultOutput(), string);
            }
            this.m_ResultListener.acceptResult(this, objectArray2, objectArray4);
            continue;
        }
    }

    public String[] getKeyNames() {
        String[] stringArray = this.m_SplitEvaluator.getKeyNames();
        String[] stringArray2 = new String[stringArray.length + 3];
        stringArray2[0] = DATASET_FIELD_NAME;
        stringArray2[1] = RUN_FIELD_NAME;
        stringArray2[2] = FOLD_FIELD_NAME;
        System.arraycopy(stringArray, 0, stringArray2, 3, stringArray.length);
        return stringArray2;
    }

    public Object[] getKeyTypes() {
        Object[] objectArray = this.m_SplitEvaluator.getKeyTypes();
        Object[] objectArray2 = new String[objectArray.length + 3];
        objectArray2[0] = new String();
        objectArray2[1] = new String();
        objectArray2[2] = new String();
        System.arraycopy(objectArray, 0, objectArray2, 3, objectArray.length);
        return objectArray2;
    }

    public String[] getResultNames() {
        String[] stringArray = this.m_SplitEvaluator.getResultNames();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = TIMESTAMP_FIELD_NAME;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public Object[] getResultTypes() {
        Object[] objectArray = this.m_SplitEvaluator.getResultTypes();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = new Double(0.0);
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        return objectArray2;
    }

    public String getCompatibilityState() {
        String string = "-X " + this.m_NumFolds + " ";
        string = this.m_SplitEvaluator == null ? string + LocalString.get("<null SplitEvaluator>") : string + "-W " + this.m_SplitEvaluator.getClass().getName();
        return string + " --";
    }

    public String outputFileTipText() {
        return LocalString.get("Set the destination for saving raw output. If the rawOutput ") + LocalString.get("option is selected, then output from the splitEvaluator for ") + LocalString.get("individual folds is saved. If the destination is a directory, ") + LocalString.get("then each output is saved to an individual gzip file; if the ") + LocalString.get("destination is a file, then each output is saved as an entry ") + LocalString.get("in a zip file.");
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public void setOutputFile(File file) {
        this.m_OutputFile = file;
    }

    public String numFoldsTipText() {
        return LocalString.get("Number of folds to use in cross validation.");
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int n) {
        this.m_NumFolds = n;
    }

    public String rawOutputTipText() {
        return LocalString.get("Save raw output (useful for debugging). If set, then output is ") + LocalString.get("sent to the destination specified by outputFile");
    }

    public boolean getRawOutput() {
        return this.m_debugOutput;
    }

    public void setRawOutput(boolean bl) {
        this.m_debugOutput = bl;
    }

    public String splitEvaluatorTipText() {
        return LocalString.get("The evaluator to apply to the cross validation folds. ") + LocalString.get("This may be a classifier, regression scheme etc.");
    }

    public SplitEvaluator getSplitEvaluator() {
        return this.m_SplitEvaluator;
    }

    public void setSplitEvaluator(SplitEvaluator splitEvaluator) {
        this.m_SplitEvaluator = splitEvaluator;
        this.m_SplitEvaluator.setAdditionalMeasures(this.m_AdditionalMeasures);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option(LocalString.get("\tThe number of folds to use for the cross-validation.\n") + LocalString.get("\t(default 10)"), "X", 1, LocalString.get("-X <number of folds>")));
        vector.addElement(new Option(LocalString.get("Save raw split evaluator output."), "D", 0, "-D"));
        vector.addElement(new Option(LocalString.get("\tThe filename where raw output will be stored.\n") + LocalString.get("\tIf a directory name is specified then then individual\n") + LocalString.get("\toutputs will be gzipped, otherwise all output will be\n") + LocalString.get("\tzipped to the named file. Use in conjuction with -D.") + LocalString.get("\t(default splitEvalutorOut.zip)"), "O", 1, LocalString.get("-O <file/directory name/path>")));
        vector.addElement(new Option(LocalString.get("\tThe full class name of a SplitEvaluator.\n") + LocalString.get("\teg: weka.experiment.ClassifierSplitEvaluator"), "W", 1, LocalString.get("-W <class name>")));
        if (this.m_SplitEvaluator != null && this.m_SplitEvaluator instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, LocalString.get("\nOptions specific to split evaluator ") + this.m_SplitEvaluator.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_SplitEvaluator)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        this.setRawOutput(Utils.getFlag('D', stringArray));
        String string2 = Utils.getOption('O', stringArray);
        if (string2.length() != 0) {
            this.setOutputFile(new File(string2));
        }
        if ((string = Utils.getOption('X', stringArray)).length() != 0) {
            this.setNumFolds(Integer.parseInt(string));
        } else {
            this.setNumFolds(10);
        }
        String string3 = Utils.getOption('W', stringArray);
        if (string3.length() == 0) {
            throw new Exception(LocalString.get("A SplitEvaluator must be specified with") + LocalString.get(" the -W option."));
        }
        this.setSplitEvaluator((SplitEvaluator)Utils.forName(class$weka$experiment$SplitEvaluator == null ? (class$weka$experiment$SplitEvaluator = CrossValidationResultProducer.class$("weka.experiment.SplitEvaluator")) : class$weka$experiment$SplitEvaluator, string3, null));
        if (this.getSplitEvaluator() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getSplitEvaluator())).setOptions(Utils.partitionOptions(stringArray));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_SplitEvaluator != null && this.m_SplitEvaluator instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_SplitEvaluator)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 8];
        int n = 0;
        stringArray2[n++] = "-X";
        stringArray2[n++] = "" + this.getNumFolds();
        if (this.getRawOutput()) {
            stringArray2[n++] = "-D";
        }
        stringArray2[n++] = "-O";
        stringArray2[n++] = this.getOutputFile().getName();
        if (this.getSplitEvaluator() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getSplitEvaluator().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String toString() {
        String string = LocalString.get("CrossValidationResultProducer: ");
        string = string + this.getCompatibilityState();
        string = this.m_Instances == null ? string + LocalString.get(": <null Instances>") : string + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return string;
    }

    public static void main(String[] stringArray) {
        System.err.println(Utils.doubleToString(CrossValidationResultProducer.getTimestamp(), 4));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

