/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import weka.LocalString;
import weka.core.FastVector;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;

public class DotParser
implements GraphConstants {
    protected FastVector m_nodes;
    protected FastVector m_edges;
    protected Reader m_input;
    protected String m_graphName;

    public DotParser(Reader reader, FastVector fastVector, FastVector fastVector2) {
        this.m_nodes = fastVector;
        this.m_edges = fastVector2;
        this.m_input = reader;
    }

    public String parse() {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(this.m_input));
        this.setSyntax(streamTokenizer);
        this.graph(streamTokenizer);
        return this.m_graphName;
    }

    protected void setSyntax(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.ordinaryChar(91);
        streamTokenizer.ordinaryChar(93);
        streamTokenizer.ordinaryChar(123);
        streamTokenizer.ordinaryChar(125);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(62);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(42);
        streamTokenizer.quoteChar(34);
        streamTokenizer.whitespaceChars(59, 59);
        streamTokenizer.ordinaryChar(61);
    }

    protected void graph(StreamTokenizer streamTokenizer) {
        GraphEdge graphEdge;
        int n;
        try {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -3) {
                if (streamTokenizer.sval.equalsIgnoreCase(LocalString.get("digraph"))) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3) {
                        this.m_graphName = streamTokenizer.sval;
                        streamTokenizer.nextToken();
                    }
                    while (streamTokenizer.ttype != 123) {
                        System.err.println(LocalString.get("Error at line ") + streamTokenizer.lineno() + LocalString.get(" ignoring token ") + streamTokenizer.sval);
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != -1) continue;
                        return;
                    }
                    this.stmtList(streamTokenizer);
                } else if (streamTokenizer.sval.equalsIgnoreCase(LocalString.get("graph"))) {
                    System.err.println(LocalString.get("Error. Undirected graphs cannot be used"));
                } else {
                    System.err.println(LocalString.get("Error. Expected graph or digraph at line ") + streamTokenizer.lineno());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int[] nArray = new int[this.m_nodes.size()];
        int[] nArray2 = new int[this.m_nodes.size()];
        for (n = 0; n < this.m_edges.size(); ++n) {
            graphEdge = (GraphEdge)this.m_edges.elementAt(n);
            int n2 = graphEdge.src;
            nArray[n2] = nArray[n2] + 1;
            int n3 = graphEdge.dest;
            nArray2[n3] = nArray2[n3] + 1;
        }
        for (n = 0; n < this.m_edges.size(); ++n) {
            int n4;
            graphEdge = (GraphEdge)this.m_edges.elementAt(n);
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(graphEdge.src);
            GraphNode graphNode2 = (GraphNode)this.m_nodes.elementAt(graphEdge.dest);
            if (graphNode.edges == null) {
                graphNode.edges = new int[nArray[graphEdge.src]][2];
                for (n4 = 0; n4 < graphNode.edges.length; ++n4) {
                    graphNode.edges[n4][1] = 0;
                }
            }
            if (graphNode2.prnts == null) {
                graphNode2.prnts = new int[nArray2[graphEdge.dest]];
                for (n4 = 0; n4 < graphNode2.prnts.length; ++n4) {
                    graphNode2.prnts[n4] = -1;
                }
            }
            n4 = 0;
            while (graphNode.edges[n4][1] != 0) {
                ++n4;
            }
            graphNode.edges[n4][0] = graphEdge.dest;
            graphNode.edges[n4][1] = graphEdge.type;
            n4 = 0;
            while (graphNode2.prnts[n4] != -1) {
                ++n4;
            }
            graphNode2.prnts[n4] = graphEdge.src;
        }
    }

    protected void stmtList(StreamTokenizer streamTokenizer) throws Exception {
        block3: {
            block2: {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 125) break block2;
                if (streamTokenizer.ttype != -1) break block3;
            }
            return;
        }
        this.stmt(streamTokenizer);
        this.stmtList(streamTokenizer);
    }

    protected void stmt(StreamTokenizer streamTokenizer) {
        if (!(streamTokenizer.sval.equalsIgnoreCase(LocalString.get("graph")) || streamTokenizer.sval.equalsIgnoreCase(LocalString.get("node")) || streamTokenizer.sval.equalsIgnoreCase(LocalString.get("edge")))) {
            try {
                this.nodeID(streamTokenizer);
                int n = this.m_nodes.indexOf(new GraphNode(streamTokenizer.sval, null));
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 91) {
                    this.nodeStmt(streamTokenizer, n);
                } else if (streamTokenizer.ttype == 45) {
                    this.edgeStmt(streamTokenizer, n);
                } else {
                    System.err.println(LocalString.get("error at lineno ") + streamTokenizer.lineno() + LocalString.get(" in stmt"));
                }
            }
            catch (Exception exception) {
                System.err.println(LocalString.get("error at lineno ") + streamTokenizer.lineno() + LocalString.get(" in stmtException"));
                exception.printStackTrace();
            }
        }
    }

    protected void nodeID(StreamTokenizer streamTokenizer) throws Exception {
        if (streamTokenizer.ttype != 34) {
            if (!(streamTokenizer.ttype == -3 || streamTokenizer.ttype >= 97 && streamTokenizer.ttype <= 122 || streamTokenizer.ttype >= 65 && streamTokenizer.ttype <= 90)) {
                throw new Exception();
            }
        }
        if (this.m_nodes != null && !this.m_nodes.contains(new GraphNode(streamTokenizer.sval, null))) {
            this.m_nodes.addElement(new GraphNode(streamTokenizer.sval, streamTokenizer.sval));
        }
    }

    protected void nodeStmt(StreamTokenizer streamTokenizer, int n) throws Exception {
        block21: {
            block20: {
                streamTokenizer.nextToken();
                GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(n);
                if (streamTokenizer.ttype == 93) break block20;
                if (streamTokenizer.ttype != -1) break block21;
            }
            return;
        }
        if (streamTokenizer.ttype == -3) {
            if (streamTokenizer.sval.equalsIgnoreCase(LocalString.get("label"))) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        graphNode.lbl = streamTokenizer.sval;
                    } else {
                        System.err.println(LocalString.get("couldn't find label at line ") + streamTokenizer.lineno());
                        streamTokenizer.pushBack();
                    }
                } else {
                    System.err.println(LocalString.get("couldn't find label at line ") + streamTokenizer.lineno());
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase(LocalString.get("color"))) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                        System.err.println(LocalString.get("couldn't find color at line ") + streamTokenizer.lineno());
                        streamTokenizer.pushBack();
                    }
                } else {
                    System.err.println(LocalString.get("couldn't find color at line ") + streamTokenizer.lineno());
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase(LocalString.get("style"))) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                        System.err.println(LocalString.get("couldn't find style at line ") + streamTokenizer.lineno());
                        streamTokenizer.pushBack();
                    }
                } else {
                    System.err.println(LocalString.get("couldn't find style at line ") + streamTokenizer.lineno());
                    streamTokenizer.pushBack();
                }
            }
        }
        this.nodeStmt(streamTokenizer, n);
    }

    protected void edgeStmt(StreamTokenizer streamTokenizer, int n) throws Exception {
        streamTokenizer.nextToken();
        GraphEdge graphEdge = null;
        if (streamTokenizer.ttype == 62) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 123) {
                while (true) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 125) {
                        this.nodeID(streamTokenizer);
                        graphEdge = new GraphEdge(n, this.m_nodes.indexOf(new GraphNode(streamTokenizer.sval, null)), 1);
                        if (this.m_edges == null || this.m_edges.contains(graphEdge)) continue;
                        this.m_edges.addElement(graphEdge);
                        continue;
                    }
                    break;
                }
            } else {
                this.nodeID(streamTokenizer);
                graphEdge = new GraphEdge(n, this.m_nodes.indexOf(new GraphNode(streamTokenizer.sval, null)), 1);
                if (this.m_edges != null && !this.m_edges.contains(graphEdge)) {
                    this.m_edges.addElement(graphEdge);
                }
            }
        } else {
            if (streamTokenizer.ttype == 45) {
                System.err.println(LocalString.get("Error at line ") + streamTokenizer.lineno() + LocalString.get(". Cannot deal with undirected edges"));
                if (streamTokenizer.ttype == -3) {
                    streamTokenizer.pushBack();
                }
                return;
            }
            System.err.println(LocalString.get("Error at line ") + streamTokenizer.lineno() + LocalString.get(" in edgeStmt"));
            if (streamTokenizer.ttype == -3) {
                streamTokenizer.pushBack();
            }
            return;
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == 91) {
            this.edgeAttrib(streamTokenizer, graphEdge);
        } else {
            streamTokenizer.pushBack();
        }
    }

    protected void edgeAttrib(StreamTokenizer streamTokenizer, GraphEdge graphEdge) throws Exception {
        block21: {
            block20: {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 93) break block20;
                if (streamTokenizer.ttype != -1) break block21;
            }
            return;
        }
        if (streamTokenizer.ttype == -3) {
            if (streamTokenizer.sval.equalsIgnoreCase(LocalString.get("label"))) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                        System.err.println(LocalString.get("found label ") + streamTokenizer.sval);
                    } else {
                        System.err.println(LocalString.get("couldn't find label at line ") + streamTokenizer.lineno());
                        streamTokenizer.pushBack();
                    }
                } else {
                    System.err.println(LocalString.get("couldn't find label at line ") + streamTokenizer.lineno());
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase(LocalString.get("color"))) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                        System.err.println(LocalString.get("couldn't find color at line ") + streamTokenizer.lineno());
                        streamTokenizer.pushBack();
                    }
                } else {
                    System.err.println(LocalString.get("couldn't find color at line ") + streamTokenizer.lineno());
                    streamTokenizer.pushBack();
                }
            } else if (streamTokenizer.sval.equalsIgnoreCase(LocalString.get("style"))) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 61) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 && streamTokenizer.ttype != 34) {
                        System.err.println(LocalString.get("couldn't find style at line ") + streamTokenizer.lineno());
                        streamTokenizer.pushBack();
                    }
                } else {
                    System.err.println(LocalString.get("couldn't find style at line ") + streamTokenizer.lineno());
                    streamTokenizer.pushBack();
                }
            }
        }
        this.edgeAttrib(streamTokenizer, graphEdge);
    }

    public static void writeDOT(String string, String string2, FastVector fastVector, FastVector fastVector2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(LocalString.get("digraph "), 0, LocalString.get("digraph ").length());
            if (string2 != null) {
                fileWriter.write(string2 + " ", 0, string2.length() + 1);
            }
            fileWriter.write("{\n", 0, "{\n".length());
            for (int i = 0; i < fastVector2.size(); ++i) {
                GraphEdge graphEdge = (GraphEdge)fastVector2.elementAt(i);
                fileWriter.write(((GraphNode)fastVector.elementAt((int)graphEdge.src)).ID, 0, ((GraphNode)fastVector.elementAt((int)graphEdge.src)).ID.length());
                fileWriter.write("->", 0, "->".length());
                fileWriter.write(((GraphNode)fastVector.elementAt((int)graphEdge.dest)).ID + "\n", 0, ((GraphNode)fastVector.elementAt((int)graphEdge.dest)).ID.length() + 1);
            }
            fileWriter.write("}\n", 0, "}\n".length());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

