require 'wema/page'

class WemaApp
  class ConfigPage < CKComponent
    def init
      response.headers['Content-Type'] = 'text/html; charset=euc-jp'
      @page_title ||= request['page'] || 'FrontPage'
      @src_page ||= page_title_url
      @list = []
      @page_list = Wema::Pages::get(WemaApp.get_conf('data_path'))
      @site_title = WemaApp.get_conf('site_title')
      @resource_url = WemaApp.resource_url
      
      @site_name = WemaApp.get_conf('site_title')
      @bgcolor = WemaApp.get_conf('bgcolor')
      @bgimage = WemaApp.get_conf('bgimage')
      @color_label = WemaApp.get_conf('color_label')
      @color_value = WemaApp.get_conf('color_value')
      @sticky_style = WemaApp.get_conf('style')
      @color_value = WemaApp.get_conf('color_value')
      @text_format = WemaApp.get_conf('format')
      @formats = Dir.glob('./lib/wema/encode/*.rb').map{|f| File.basename(f, '.rb')}
      File.open('./style.css'){|f|
        @style_sheet = f.read
      }
    end

    def config_update
      @style_sheet.gsub!(/\r\n/,"\n")
      component_path = WemaApp.get_conf('component_path')
      data_path = WemaApp.get_conf('data_path')
      resource_url = WemaApp.get_conf('resource_url')
      top_url = WemaApp.get_conf('top_url')
      passkey = @password.crypt(@password)
      
      File.open('./wema.conf','w'){|f|
        if resource_url
          f.puts "resource_url\t#{resource_url}"
        end
        if top_url
          f.puts "top_url\t#{top_url}"
        end
        f.print <<"EOS"
component_path\t#{component_path}
data_path\t#{data_path}
site_title\t#{@site_name}
bgcolor\t#{@bgcolor}
bgimage\t#{@bgimage}
color_label\t#{@color_label}
color_value\t#{@color_value}
style\t#{@sticky_style}
password\t#{passkey}
format\t#{@text_format}
EOS
      }

      File.open('./style.css','w'){|f|
        f.print @style_sheet
      }
    end

    def css_url
      "#{WemaApp.top_url}?element_id=CSSPage"
    end

    def page_title_url
      CKUtilities.escape_url(@page_title)
    end
    
    def password?
      unless @password.nil?
        WemaApp.passwd?(@password)
      end
    end
  end
end
