require 'wema/sticky'
require 'wema/line'
require 'wema/page'
require 'wema/plugin'

class WemaApp
  class MainPage < CKComponent
    attr_accessor :page_title
    
    def init
      Dir.glob("./lib/plugin/*.rb") do |file|
        begin
          func = File.basename(file,'.rb')
          File.open(file){|f|
            instance_eval(f.read)
            send(func, request)
          }
        rescue Exception
        end
      end

      response.headers['Content-Type'] = 'text/html; charset=euc-jp'
      @page_title ||= request['page'] || 'FrontPage'
      @anchor_id ||= request['anchor_id'] || ''
      @src_page ||= page_title_url
      @site_title = WemaApp.get_conf('site_title')
      @resource_url = WemaApp.resource_url
      @version = WemaApp::VERSION
      @ruby_version = RUBY_VERSION
      @bgcolor = WemaApp.get_conf('bgcolor') || '#ffffff'

      plg = Wema::Plugin.new
      Dir.glob("#{WemaApp.get_conf('data_path')}/#{page_title_url}/*.txt") do |file|
        @list ||= []
        @list.push(plg.pre_run(Wema::Sticky.new(file), "#{WemaApp.get_conf('data_path')}/#{page_title_url}"))
      end

      Dir.glob("#{WemaApp.get_conf('data_path')}/#{page_title_url}/*.line") do |file|
        @line ||= []
        @line.push(Wema::Line.new(file))
      end

      @page_list = Wema::Pages::get(WemaApp.get_conf('data_path'))
      @line_width = 1

    end
    
    def post_action
      if @page_title == 'PageList'
        return page("PageList")
      end
    end
    
    def css_url
      "#{WemaApp.top_url}?element_id=CSSPage"
    end
    
    def rss_url
      "#{WemaApp.top_url}?element_id=RSSPage;page=#{page_title_url}"
    end
    
    def update_sticky
      unless File.exist?("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
        Dir.mkdir("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
      end
      
      sticky = Wema::Sticky.new
      sticky.sid = @sid if @sid != ''
      sticky.left = @left || 0
      sticky.top = @top || 0
      sticky.color = @color || '#aaf'
      sticky.source = @source
      sticky.parent = ''
      sticky.lock = ''
      sticky.save_to_file("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
      
      response.set_redirect("index.cgi?page=#{page_title_url}")
    end

    def move_sticky
      if @target_page != ''
        target_page = CKUtilities.escape_url(@target_page)
        if File.exist?("#{WemaApp.get_conf('data_path')}/#{target_page}")
          if File.exist?("#{WemaApp.get_conf('data_path')}/#{target_page}/lock")
            response.set_redirect("index.cgi?page=#{@src_page}")
            return 
          end
        else
          Dir.mkdir("#{WemaApp.get_conf('data_path')}/#{target_page}")
        end

        File::rename("#{WemaApp.get_conf('data_path')}/#{@src_page}/#{@move_sid}.txt", 
                     "#{WemaApp.get_conf('data_path')}/#{target_page}/#{@move_sid}.txt")
        File::utime(Time.now, Time.now, "#{WemaApp.get_conf('data_path')}/#{target_page}/#{@move_sid}.txt")

        Dir::glob("#{WemaApp.get_conf('data_path')}/#{@src_page}/*#{@move_sid}*.line") do |line|
          File::delete(line)
        end
      
        if target_page != 'DustBox'
          response.set_redirect("index.cgi?page=#{target_page}") 
        else
          sticky = Wema::Sticky.new("#{WemaApp.get_conf('data_path')}/#{target_page}/#{@move_sid}.txt")
          sticky.parent = @src_page
          sticky.save_to_file("#{WemaApp.get_conf('data_path')}/#{target_page}")
          response.set_redirect("index.cgi?page=#{@src_page}") 
        end
      end
    end

    def restore_sticky
      sticky = Wema::Sticky.new("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{@sid}.txt")
      restore_page = sticky.parent != '' ? sticky.parent : 'FrontPage'
      
      if restore_page != ''
        File::rename("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{@sid}.txt", 
                     "#{WemaApp.get_conf('data_path')}/#{restore_page}/#{@sid}.txt")
        File::utime(Time.now, Time.now, "#{WemaApp.get_conf('data_path')}/#{restore_page}/#{@sid}.txt")

        response.set_redirect("index.cgi?page=#{restore_page}") 
      end
    end

    def lock_sticky
      sticky = Wema::Sticky.new("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{@sid}.txt")
      sticky.lock = @pass
      sticky.save_to_file("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
      
      response.set_redirect("index.cgi?page=#{page_title_url}") 
    end

    def unlock_sticky
      sticky = Wema::Sticky.new("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{@sid}.txt")
      if sticky.lock == @pass or pass_word_check?(@pass)
        sticky.lock = ''
        sticky.save_to_file("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
      end
      
      response.set_redirect("index.cgi?page=#{page_title_url}") 
    end

    def restore_all_sticky
      if pass_word_check?(@pass)
        Dir.glob("#{WemaApp.get_conf('data_path')}/#{page_title_url}/*.txt") do |file|
          sticky = Wema::Sticky.new(file)
          restore_page = sticky.parent != '' ? sticky.parent : 'FrontPage'
      
          if restore_page != ''
            File::rename(file, "#{WemaApp.get_conf('data_path')}/#{restore_page}/#{sticky.sid}.txt")
            File::utime(Time.now, Time.now, "#{WemaApp.get_conf('data_path')}/#{restore_page}/#{sticky.sid}.txt")
          end
        end
      end

      response.set_redirect("index.cgi?page=#{page_title_url}")
    end

    def delete_sticky
      if File.exist?("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{@sid}.txt")
        File::delete("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{@sid}.txt")

        response.set_redirect("index.cgi?page=#{page_title_url}") 
      end
    end

    def delete_all_sticky
      if pass_word_check?(@pass)
        Dir.glob("#{WemaApp.get_conf('data_path')}/#{page_title_url}/*.txt") do |file|
          File::delete(file)
        end
      end

      response.set_redirect("index.cgi?page=#{page_title_url}")
    end

    def set_line
      if @src_line_id != @target_line_id
        line = Wema::Line.new
        line.source = @src_line_id
        line.target = @target_line_id
        line.color  = @line_color
        line.width  = @line_width
        line.style  = @line_style
        line.label  = @line_label
        line.arrow_s = @line_arrow_start ? '1' : '0'
        line.arrow_e = @line_arrow_end ? '1' : '0'
        
        line.save_to_file("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
      end
      
      response.set_redirect("index.cgi?page=#{page_title_url}")
    end
    
    def delete_line
      if File.exists?("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{@src_line_id}-#{@target_line_id}.line")
        File::delete("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{@src_line_id}-#{@target_line_id}.line")
      end
      
      response.set_redirect("index.cgi?page=#{page_title_url}")
    end
    
    def page_lock
      if pass_word_check?(@pass)
        unless File.exist?("#{WemaApp.get_conf('data_path')}/#{page_title_url}/lock")
          Dir.mkdir("#{WemaApp.get_conf('data_path')}/#{page_title_url}/lock")
        end
      end
    end

    def page_un_lock
      if pass_word_check?(@pass)
        if File.exist?("#{WemaApp.get_conf('data_path')}/#{page_title_url}/lock")
          Dir.rmdir("#{WemaApp.get_conf('data_path')}/#{page_title_url}/lock")
        end
      end
    end

    def all_set_position
      @position_env.split(/:/).each do |spos|
        id, left, top = spos.split(/,/)
        sticky = Wema::Sticky.new("#{WemaApp.get_conf('data_path')}/#{page_title_url}/#{id}.txt")
        if sticky.left != left or sticky.top != top
          sticky.left = left
          sticky.top = top
          sticky.save_to_file("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
        end
      end

      response.set_redirect("index.cgi?page=#{page_title_url}")
    end

    def isLockPage?
      File.exist?("#{WemaApp.get_conf('data_path')}/#{page_title_url}/lock")
    end

    def color_label
      WemaApp.color_label
    end

    def color_values
      WemaApp.color_value
    end
    
    def line_color_label
      Wema::Line.colors[0]
    end

    def line_color_values
      Wema::Line.colors[1]
    end
    
    def line_style_label
      Wema::Line.styles[0]
    end

    def line_style_values
      Wema::Line.styles[1]
    end
    
    def page_title_url
      CKUtilities.escape_url(@page_title)
    end
    
    def page_data_list
      @page_list.map{|p| CKUtilities.unescape_url(p)}
    end
    
    def pass_word_check?(pass)
      WemaApp.passwd?(pass)
    end
  end
end
