require 'wema/page'

class WemaApp
  class PageList < CKComponent
  
    attr_accessor :list, :page_title
  
    def init
      response.headers['Content-Type'] = 'text/html; charset=euc-jp'
      @list = Wema::Pages.get(WemaApp.get_conf('data_path'))
      @site_title = WemaApp.get_conf('site_title')
      @resource_url = WemaApp.resource_url
    end
  
    def css_url
      "#{WemaApp.top_url}?element_id=CSSPage"
    end
    
    def page_data_list
      @list.map{|p| CKUtilities.unescape_url(p)}
    end
  end
end
