require 'wema/sticky'
require 'wema/line'
require 'wema/page'
require 'uconv'

class WemaApp
  class RSSPage < CKComponent
    attr_accessor :page_title
  
    def init
      response.headers['Content-Type'] = 'text/xml; charset=utf-8'
      @page_title ||= request['page'] || 'FrontPage'

      Dir.glob("#{WemaApp.get_conf('data_path')}/#{page_title_url}/*.txt") do |file|
        @list ||= []
        @list.push(Wema::Sticky.new(file, page_title_url))
      end
    end

    def this_url
      "#{WemaApp.top_url}?element_id=RSSPage;page=#{page_title_url}"
    end
  
    def app_url
      "#{WemaApp.top_url}?page=#{page_title_url}"
    end

    def rss_page_title
      Uconv.euctou8(@page_title)
    end

    def rss_site_title
      Uconv.euctou8(WemaApp.get_conf('site_title'))
    end

    def page_title_url
      CKUtilities.escape_url(@page_title)
    end
  end
end
