require 'wema/page'
require 'wema/sticky'

class WemaApp
  class RecentPage < CKComponent
  
    attr_accessor :list, :page_title
  
    def init
      response.headers['Content-Type'] = 'text/html; charset=euc-jp'
      @list = Wema::Pages.get(WemaApp.get_conf('data_path'))
      @site_title = WemaApp.get_conf('site_title')
      @resource_url = WemaApp.resource_url
      Dir.glob("#{WemaApp.get_conf('data_path')}/*/*.txt").sort_by{|f| File::mtime(f) }.reverse[0..50].each do |file|
        @stickys ||= []
        @stickys.push(Wema::Sticky.new(file, @page_title))
      end
    end

    def rss_url
      "#{WemaApp.top_url}?element_id=RecentRSS"
    end
    
    def css_url
      "#{WemaApp.top_url}?element_id=CSSPage"
    end
    
    def page_data_list
      @list.map{|p| CKUtilities.unescape_url(p)}
    end
  end
end
