require 'wema/page'
require 'wema/sticky'
require 'uconv'

class WemaApp
  class RecentRSS < CKComponent
    
    attr_accessor :list, :page_title
    
    def init
      response.headers['Content-Type'] = 'text/xml; charset=utf-8'
      Dir.glob("#{WemaApp.get_conf('data_path')}/*/*.txt").sort_by{|f| File::mtime(f) }.reverse[0..50].each do |file|
        @list ||= []
        @list.push(Wema::Sticky.new(file, @page_title))
      end
    end
    
    def this_url
      "#{WemaApp.top_url}?element_id=RecentRSS"
    end
    
    def app_url
      "#{WemaApp.top_url}?element_id=RecentPage"
    end

    def rss_page_title
      'RecentPage'
    end

    def rss_site_title
      Uconv.euctou8(WemaApp.get_conf('site_title'))
    end

    def page_title_url
      'RecentPage'
    end
  end
end
