require 'wema/sticky'
require 'wema/line'
require 'wema/page'

class WemaApp
  class SearchPage < CKComponent
    attr_accessor :page_title
  
    def init
      response.headers['Content-Type'] = 'text/html; charset=euc-jp'
      @page_title ||= request['page'] || 'FrontPage'
      @src_page ||= page_title_url
      @list = []
      @page_list = Wema::Pages::get(WemaApp.get_conf('data_path'))
      @site_title = WemaApp.get_conf('site_title')
      @resource_url = WemaApp.resource_url
    end

    def css_url
      "#{WemaApp.top_url}?element_id=CSSPage"
    end
    
    def search_sticky
      regx = Regexp.new(@search_key)
      Dir.glob("#{WemaApp.get_conf('data_path')}/*/*.txt") do |file|
        s = Wema::Sticky.new(file)
        if s.match?(regx)
          @list ||= []
          @list.push(s)
        end
      end
    end
  
    def page_title_url
      CKUtilities.escape_url(@page_title)
    end
  end
end
