require 'kconv'
require 'uconv'
require 'cgikit'
require 'wemaapp'
require 'wema/sticky'

def trackback(req)
end

def trackback(req, res)
  title = req['title'] || ""
  url = req['url'] || ""
  excerpt = req['excerpt'] || ""
  blog_name = req['blog_name'] || ""

  if Kconv.guess(excerpt) == Kconv::JIS then
    title = Uconv.sjistou8(title.tosjis)
    url = Uconv.sjistou8(url.tosjis)
    excerpt = Uconv.sjistou8(excerpt.tosjis)
    blog_name = Uconv.sjistou8(blog_name.tosjis)
  elsif Kconv.guess(excerpt) == Kconv::EUC then
    title = Uconv.euctou8(title)
    url = Uconv.euctou8(url)
    excerpt = Uconv.euctou8(excerpt)
    blog_name = Uconv.euctou8(blog_name)
	elsif Kconv.guess(excerpt) == Kconv::SJIS then
	  if /[\020-\177][\200-\237]/n =~ excerpt or
	     /[\300-\377][\000-\177\300-\377]/n =~ excerpt then
      title = Uconv.sjistou8(title)
      url = Uconv.sjistou8(url)
      excerpt = Uconv.sjistou8(excerpt)
      blog_name = Uconv.sjistou8(blog_name)
    end
  end

  title = Uconv.u8toeuc(title)
  url = Uconv.u8toeuc(url)
  excerpt = Uconv.u8toeuc(excerpt)
  blog_name = Uconv.u8toeuc(blog_name)

  if title != ''
    page_title = req['page'] || 'FrontPage'
    page_title_url = CKUtilities.unescape_url(page_title)
    
    unless File.exist?("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
      Dir.mkdir("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
    end
    
    sticky = Wema::Sticky.new
    sticky.left = rand(800).to_s
    sticky.top = rand(600).to_s
    sticky.color = '#fff'
    sticky.source =<<EOS
[#{title}](#{url})
#{excerpt}

by #{blog_name}
EOS
    sticky.parent = ''
    sticky.lock = ''
    sticky.save_to_file("#{WemaApp.get_conf('data_path')}/#{page_title_url}")
  end

  res.headers['Content-Type'] = 'text/xml'
  res_code =<<EOS
<?xml version="1.0" encoding="iso-8859-1"?>
<response>
<error>0</error>
</response>
EOS
end

