require 'bluecloth'
require 'html/sanitize'

# Markdownˡ

def markdown(str)
  str.gsub!(/[^ ]{2}\r{0,1}\n/m) do |m|
    if m =~ /([^ ]{2})\r{0,1}\n/
      "#{$1}  \r\n"
    end
  end
  str = HTML::Sanitize::sanitize(BlueCloth.new(str).to_html)
  buf = str.gsub(/\[\[[^\]]*\]\]/) do |m|
    if m =~ /\[\[([^\]]*)\]\]/
      %[<a href="index.cgi?page=#{CKUtilities.escape_url($1)}">#{$1}</a>]
    end
  end
end
