require "rd/rdfmt"
require "rd/rd2html-lib"

def rd(str)
  rd_style_visitor = RD::RD2HTMLVisitor.new

  rd_style_visitor.instance_eval do
    base_level = 1
  end

  def rd_style_visitor.apply_to_DocumentElement(element, content)
    return content.join("")
  end

  def @rd_style_visitor.apply_to_Headline(element, title)
    anchor = get_anchor(element)
    label = hyphen_escape(element.label)
    return <<EOF
<h#{@base_level+element.level}><a name="#{anchor}" id="#{anchor}">#{title}</a>
</h#{@base_level+element.level}><!-- RDLabel: "#{label}" -->
EOF
  end

  src = []
  src.push("=begin\n")
  src += str.to_a
  src.push("=end\n")
  tree = RD::Tree.new(RD::DocumentStructure::RD, src)
  tree.parse
  str = rd_style_visitor.visit(tree)
end
