class MikiEngine

  # CCϊ
  def MikiEngine.inline(str)
    if str.nil?
      str = ""
    end
    str.gsub!(/(\\\\)/,"<br />")
    str.gsub!(/''(.+?)''/){|m| "<em>#{$1}</em>"}
    str.gsub!(/%%(.+?)%%/){|m| "<del>#{$1}</del>"}
    if str.nil?
      return ""
    else
      return str
    end
  end

  def MikiEngine.nvl(str)
    if str.nil?
      return ""
    else
      return str
    end
  end

  # hLg̏ϊ
  def MikiEngine.convert(str)
    list = nil
    buf = ""
    stack = []
    premode = 0
    cutflg = 0
    pid = 0
    str = CGI::escapeHTML(str)
    str.each_line { |line|
      line.sub!(/\r?\n/,"")
      if premode == 1
        if /^\-pre$/ =~ line
          premode = 0
        else
          buf << nvl(line)+"\n"
        end
        next
      end
      if /^$/ =~ line
        # pOt̏I
        buf << nvl(stack.pop) + "\n"
      elsif /^(=+)(.+)/ =~ line
        # o
        buf << nvl(stack.pop) + "\n"
        buf << "<h#{$1.length}>"
        buf << inline($2)
        buf << "</h#{$1.length}>\n"
      elsif /^\*+(.+)/ =~ line
        # Xg
        if stack.last != "</ul>"
          buf << nvl(stack.pop) + "\n"
          buf << "<ul>"
          buf << "<li>#{inline($1)}</li>\n"
          stack.push("</ul>")
        else
          buf << "<li>#{inline($1)}</li>\n"
        end
      elsif /^\#+(.+)/ =~ line
        # Xg
        if stack.last != "</ol>"
          buf << nvl(stack.pop) + "\n"
          buf << "<ol>"
          buf << "<li>#{inline($1)}</li>\n"
          stack.push("</ol>")
        else
          buf << "<li>#{inline($1)}</li>\n"
        end
      elsif /^\&gt;(.*)/ =~ line
        # p
        if stack.last != "</blockquote>"
          buf << nvl(stack.pop) + "\n"
          buf << "<blockquote>#{inline(nvl($1))}"
          stack.push("</blockquote>")
        else
          buf << inline(nvl($1))
        end
      elsif /^----$/ =~ line
        # ܂
        buf << nvl(stack.pop) + "\n"
        buf << "<hr/>"
      elsif /^([ @\t]+.*)/ =~ line
        # `ς݃eLXg
        if stack.last != "</pre>"
          buf << nvl(stack.pop) + "\n"
          buf << "<pre>#{nvl($1)}\n"
          stack.push("</pre>")
        else
          buf << nvl($1)+"\n"
        end
      elsif /^\-pre$/ =~ line
        # `ς݃eLXg
        if stack.last != "</pre>"
          buf << nvl(stack.pop) + "\n"
          buf << "<pre>#{nvl($1)}\n"
          stack.push("</pre>")
        end
        premode = 1
      else
        if stack.last != "</p>"
          buf << nvl(stack.pop) + "\n"
          buf << "<p>#{inline(nvl(line))}<br/>"
          stack.push("</p>")
        else
          buf << inline(nvl(line)+"<br/>\n")
        end
      end
    }
    buf << nvl(stack.pop)
    if cutflg == 1
      buf << "\n</div>\n"
    end
    return buf
  end
end

def wema1(str)
  str = MikiEngine.convert(str)
  str.gsub!(/(\[\[(.+?)\]\])|(http:\/\/[^<]*)/) do |m|
    if m =~ /\[\[(.+?)\]\]/
      name = $1
      if name =~ /(.+?)\|(.+)/
        name = $1
        url = $2
        if url =~ /http:\/\/.+/
          m = "<a href=\"#{url}\">#{name}</a>"
        else
          m = %[<a href="index.cgi?page=#{CKUtilities.escape_url(url)}">#{name}</a>]
        end
      else
        m = %[<a href="index.cgi?page=#{CKUtilities.escape_url(name)}">#{name}</a>]
      end
    elsif m =~ /http:\/\/.*/
      if @page_name != @dust
        if $& =~ /\.(gif)|(jpg)|(jpeg)|(png)$/
          m = "<img src=\"#{m}\" />"
        else
          m = "<a href=\"#{m}\">#{m}</a>"
        end
      else
        m = "<a href=\"#{m}\">#{m}</a>"
      end
    end
  end
  str
end
