module Wema
  class Line
    attr_accessor :source, :target, :label, :color, :width, :style, :arrow_s, :arrow_e

    def Line.colors
      [['','','','','','','',''],
       ['#000','#f00','#0f0','#00f','#ff0','#f0f','#0ff','#aaa']]
    end

    def Line.styles
      [['','','','','',''],
       ['solid','double','dotted','dashed','ridge','groove']]
    end

    def initialize(file = nil)
      unless file.nil?
        csv = CSVParser.new_with_file(file)
      
        csv.each do |line|
          @label   = line.shift
          @color   = line.shift
          @width   = line.shift
          @style   = line.shift
          @arrow_s = line.shift
          @arrow_e = line.shift
        end

        if File::basename(file, ".line") =~ /(\d*)-(\d*)/
          @source = $1
          @target = $2
        end
      end

      @label   ||= ''
      @color   ||= '#000'
      @width   ||= '1'
      @style   ||= 'solid'
      @arrow_s ||= '0'
      @arrow_e ||= '1'
    end
    
    def save_to_file(dir)
      csv = CSVParser.new
      csv << CSVLine.new([@label,@color,@width,@style,@arrow_s,@arrow_e])
      csv.write_to_file("#{dir}/#{@source}-#{@target}.line")
    end
  end
end
