require 'cgikit'

module Wema
  class Page
    attr_accessor :page, :cstr

    def initialize(p, ct = Time.now)
      @page = p
      @cstr = ct.strftime("%Y-%m-%d %H:%M")
    end
      
    def cstr=(ct)
      @cstr = ct.strftime("%Y-%m-%d %H:%M")
    end
      
    def page_escape
      CKUtilities.escape_url(@page)
    end
    
    def to_s()
      @page
    end
  end

  module Pages
    def Pages.get(dir_path)
      list = []
      
      pages = Dir.glob("#{dir_path}/*").map do |dir|
        if dir =~ /#{dir_path}\/(.*)/
          $1
        end
      end

      pages.each do |p|
        files = Dir::glob("#{dir_path}/#{p}/*.txt").sort_by{ |f|
          File::stat(f).mtime
        }
        if files.size > 0 then
          list.push(Page.new(CKUtilities.unescape_url(p),File::stat(files.pop).mtime))
        end
      end
      
      list.sort_by{|f| f.cstr}.reverse
    end
  end
end
