require 'wema/sticky'

module Wema
  class Plugin
    attr_accessor :header, :footer, :pre_handle
    
    def initialize
        @pre_handle = {}
        Dir.glob('./lib/wema/plugin/*.rb'){|file|
          begin
            File.open(file){|f|
              instance_eval(f.read)
            }
          rescue Exception
          end
        }
        @header = ""
        @footer = ""
    end
    
    def run(s)
      s.content.gsub!(/\{\{.*\}\}/) do |m|
        if m =~ /\{\{(.*)\}\}/
          (func, *args) = $1.split(/,/)
          unless @pre_handle.include?(func)
            begin
              m = send(func, s, args)
            rescue Exception
            end
          end
        end
      end
      s.content = header + s.content + footer
    end
    
    def pre_run(s, dir)
      s.source.gsub(/\{\{.*\}\}/) do |m|
        if m =~ /\{\{(.*)\}\}/
          (func, *args) = $1.split(/,/)
          if @pre_handle.include?(func)
            begin
              args.unshift(dir)
              send(func, s, args)
            rescue Exception
            end
          end
        end
      end
      s
    end
  end
end
