require 'csvparser'
require 'wemaapp'
require 'wema/encode'
require 'wema/plugin'
require 'uconv'

module Wema
  class Sticky
    attr_accessor :content, :source, :sid, :left, :top, :color, :parent, :lock, :page, :file, :zindex

    def initialize(file = nil, page = nil)
      if file.nil?
        @sid = "#{Time.now.to_i}#{$$}"
        @zindex = '1'
      else
        csv = CSVParser.new_with_file(file)
      
        csv.each do |line|
          @content = line.shift
          @source  = line.shift
          @sid     = line.shift
          @left    = line.shift
          @top     = line.shift
          @color   = line.shift
          @parent  = line.shift || ''
          @lock    = line.shift || ''
          @zindex  = line.shift || '1'
        end
      end
      
      @file = file
      @page = page
      if file =~ /#{WemaApp.get_conf('data_path')}\/(.*)\//
        @page ||= $1
      end
    end
    
    def page_title
      CKUtilities.unescape_url(@page)
    end
    
    def style
      WemaApp.sticky_style(self)
    end
    
    def position
      "left: #{@left}px; top: #{@top}px; z-index: #{@zindex};"
    end
    
    def js_source
      @source.gsub(/[<>\\"]/){|m| "\\#{$&}" }.gsub(/\r{0,1}\n/m,'\n').gsub(/\r/m,'\n')
    end
    
    def save_to_file(dir, rebuild = true)
      if rebuild
        enc = Wema::Encode.new
        @content = enc.convert(@source,@sid)
        plg = Wema::Plugin.new
        plg.run(self)
      end
      csv = CSVParser.new
      csv << CSVLine.new([@content,@source,@sid,@left,@top,@color,@parent,@lock,@zindex])
      csv.write_to_file("#{dir}/#{@sid}.txt")
    end
    
    def match?(regx)
      return false if @page == 'DustBox'
      str = @content.gsub(/<[^>]*>/,'')
      str =~ regx
    end
    
    def isLock?
      !(@lock.nil? or @lock == '')
    end
    
    def rss_url
      "#{WemaApp.top_url}?page=#{@page}&anchor_id=#{@sid}"
    end
    
    def title
      begin
        @content.split(/\r{0,1}\n/)[0].gsub(/<[^>]*>/,'').sub(/^$/,'̵')
      rescue
        ""
      end
    end
    
    def rss_title
      Uconv.euctou8(title)
    end
    
    def rss_date
      File::mtime(@file).strftime("%Y-%m-%dT%H:%M:%S+09:00")
    end
    
    def date
      File::mtime(@file).strftime("%Y-%m-%d %H:%M")
    end
    
    def rss_digest
      str = @content.gsub(/<[^>]*>/,'').gsub(/\s/,'')

      if /^.{0}(.{0,150})/ === str
          return Uconv.euctou8($1)
          else
                  return ""
          end
    end
    
    def digest
      str = @content.gsub(/<[^>]*>/,'').gsub(/\s/,'')

      if /^.{0}(.{0,30})/ === str
          $1
          else
                  ""
          end
    end
    
    def rss_content
      Uconv.euctou8(@content)
    end
    
  end
end
