require 'cgikit'
require 'wema/sticky'

class WemaApp < CKApplication
  attr_accessor :echo

  VERSION = '2.0.0'

  def WemaApp.get_conf(attr)
    @conf = {}
  
    File.open('wema.conf','r'){|f|
      f.each do |line|
        (key,val) = line.chomp.split(/\t/)
        if key == attr
          return val
        end
      end
    }
    
    return nil
  end

  def WemaApp.top_url
    if WemaApp.get_conf('top_url')
      WemaApp.get_conf('top_url')
    else
      require 'cgi'
      cgi = CGI.new
      "http://#{cgi.server_name}#{cgi.script_name}"
    end
  end

  def WemaApp.resource_url
    if WemaApp.get_conf('resource_url')
      WemaApp.get_conf('resource_url')
    else
      '.'
    end
  end

  def WemaApp.color_label
    WemaApp.get_conf('color_label').split(/,/)
  end

  def WemaApp.color_value
    WemaApp.get_conf('color_value').split(/,/)
  end
  
  def WemaApp.sticky_style(sticky)
    WemaApp.get_conf('style').gsub(/\[color\]/,sticky.color)
  end

  def WemaApp.passwd?(pass)
    if pass == ""
      return false
    end
    if WemaApp.get_conf('password')
      WemaApp.get_conf('password') == pass.crypt(pass)
    else
      pass == "nagisa"
    end
  end

  def load_conf
    self.component_path = WemaApp.get_conf('component_path')
    unless File.exist?(WemaApp.get_conf('data_path'))
      Dir.mkdir(WemaApp.get_conf('data_path'))
    end
    @echo = true
  end
end
