//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCbaseDialog.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>

WSMFguiClassInitialize(WSCbaseDialog,WSCwindow);
WSMFversion(WSCbaseDialog,WSCwindow);
static WSCushort D_BTN_WIDTH = 60;

WSMFpropertyValueChange(WSCbaseDialog,WSNshadowThickness,WSCuchar,0);
WSMFpropertyValueChange(WSCbaseDialog,WSNheight,WSCushort,100);
WSMFpropertyValueChange(WSCbaseDialog,WSNindicatorOn,WSCbool,False);



WSCbaseDialog::WSCbaseDialog(WSCbase* base,char* objname):
                WSCwindow(base,objname){
  _cmd_form = NULL;
  _end_btn  = NULL;
  _ok_btn   = NULL;
  _no_btn   = NULL;
  _ok_str = WSGFstrdup("OK");
  _no_str = WSGFstrdup("NO");
  _cancel_str = WSGFstrdup("Cancel");
  _ok = True;
  _no = True;
  _cancel = True;
  _title_pixmap = -1;
  _rep = NULL;
//  _shadow_thick = 1;
  _shadow_thick = 0;
  _modal = 0;
  _default_pos = 0;
  _popuped = 0;
  _h = 100;
  _indicator = 0;
  WSGIappObjectList()->addEvent(this,WSEV_GUI_POLICY_CH);

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCbaseDialog);

    WSMFpropertyCreate(WSNok,              WSCbool, _ok,WSSok );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNno,              WSCbool,  _no,WSSno );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNcancel,              WSCbool,  _cancel,WSScancel );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNlabelPixmap,     short,  _title_pixmap,WSSlabelPixmap );
    WSMFpropertyCreate(WSNokString,   char*,_ok_str,WSSokString );
    WSMFpropertyCreate(WSNnoString,   char*,_no_str,WSSnoString );
    WSMFpropertyCreate(WSNcancelString,   char*,_cancel_str,WSScancelString );
    WSMFpropertyCreate(WSNmodal,              WSCbool,  _modal,WSSmodal );
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);
    WSMFpropertyCreate(WSNdefaultPosition,    WSCbool,  _default_pos,WSSdefaultPosition );
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);
    WSMFpropertyCreate(WSNreplyHandler, void*,_rep,WSSreplyHandler );
    WSMFpropertyVisible( False );

    WSMFpropertyValueChangeDef(WSCbaseDialog,WSNshadowThickness,WSCuchar);
    WSMFpropertyValueChangeDef(WSCbaseDialog,WSNheight,WSCushort);
    WSMFpropertyValueChangeDef(WSCbaseDialog,WSNindicatorOn,WSCbool);
    WSMFpropertyVisibleOff( WSNindicatorOn );
    WSMFpropertyVisibleOff( WSNmargin );
    WSMFpropertyVisibleOff( WSNmarginLeft );
    WSMFpropertyVisibleOff( WSNbarThickness );
    WSMFpropertyVisibleOff( WSNemboss );

    WSMFaddExtTrigger(WSEV_GUI_POLICY_CH,"GUI_POLICY_CH");

  WSMFpropertyCreateEnd
}
WSCbaseDialog::~WSCbaseDialog(){
  WSGIappDev()->setFocusDialog(this,False);
  WSGIappObjectList()->delEvent(this,WSEV_GUI_POLICY_CH);
  if (_ok_str != NULL){
    delete _ok_str;
    _ok_str = NULL;
  }
  if (_no_str != NULL){
    delete _no_str;
    _no_str = NULL;
  }
}
WSMFproperty( WSCbaseDialog, WSNok, WSCbool,   _ok     ,True );
WSMFproperty( WSCbaseDialog, WSNno, WSCbool,   _no     ,True );
WSMFproperty( WSCbaseDialog, WSNcancel, WSCbool,   _cancel     ,True );
WSMFproperty( WSCbaseDialog, WSNlabelPixmap, short,  _title_pixmap,-1 );
WSMFproperty( WSCbaseDialog, WSNokString, char*,  _ok_str,WSGFstrdup("OK") );
WSMFproperty( WSCbaseDialog, WSNnoString, char*,  _no_str,WSGFstrdup("NO") );
WSMFproperty( WSCbaseDialog, WSNcancelString, char*,  _cancel_str,WSGFstrdup("Cancel") );
WSMFproperty( WSCbaseDialog, WSNreplyHandler, void*,  _rep,NULL );
WSMFproperty( WSCbaseDialog, WSNmodal, WSCbool,  _modal,False );
WSMFproperty( WSCbaseDialog, WSNdefaultPosition, WSCbool,  _default_pos,False );

void WSCbaseDialog::setWorkWSNreplyHandler(void*){}
void WSCbaseDialog::getWorkWSNreplyHandler(void**){}
void WSCbaseDialog::setWorkWSNokString(char* str){
  if (_ok_btn != NULL){
    _ok_btn->setPropertyV(WSNlabelString,str);
  }
}
void WSCbaseDialog::getWorkWSNokString(char**){}
void WSCbaseDialog::setWorkWSNnoString(char* str){
  if (_no_btn != NULL){
    _no_btn->setPropertyV(WSNlabelString,str);
  }
}
void WSCbaseDialog::getWorkWSNnoString(char**){}
void WSCbaseDialog::setWorkWSNcancelString(char* str){
  if (_end_btn != NULL){
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      _end_btn->setPropertyV(WSNlabelString,str);
    }
  }
}
void WSCbaseDialog::getWorkWSNcancelString(char**){}
void WSCbaseDialog::setWorkWSNtitleString(char* str){
  WSCwindow::setWorkWSNtitleString(str);
  if (_title_labels1 != NULL){
    _title_labels1->setPropertyV(WSNlabelString,str);
    _title_labels2->setPropertyV(WSNlabelString,str);
  }
}
void WSCbaseDialog::setWorkWSNok(WSCbool fl){
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  if (fl == False){
    _ok_btn->setPropertyV(WSNvis,(WSCbool)False);
  }else{
    _ok_btn->setPropertyV(WSNvis,(WSCbool)True);
  }
}
void WSCbaseDialog::getWorkWSNok(WSCbool*){}
void WSCbaseDialog::setWorkWSNno(WSCbool fl){
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  if (fl == False){
    if (_no_btn != NULL){
      _no_btn->setPropertyV(WSNvis,(WSCbool)False);
    }
  }else{
    if (_no_btn != NULL){
      _no_btn->setPropertyV(WSNvis,(WSCbool)True);
    }
  }
}
void WSCbaseDialog::getWorkWSNno(WSCbool*){}

void WSCbaseDialog::setWorkWSNcancel(WSCbool fl){
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  if (fl == False){
    if (_end_btn != NULL){
      _end_btn->setPropertyV(WSNvis,(WSCbool)False);
    }
  }else{
    if (_end_btn != NULL){
      _end_btn->setPropertyV(WSNvis,(WSCbool)True);
    }
  }
}
void WSCbaseDialog::getWorkWSNcancel(WSCbool*){}

void WSCbaseDialog::setWorkWSNlabelPixmap(short no){
  if (_title_label != NULL){
    _title_label->clear();
    _title_label->setPropertyV(WSNlabelPixmap,no );
    _title_label->redraw();
  }
}
void WSCbaseDialog::getWorkWSNlabelPixmap(short*){}
void WSCbaseDialog::setWorkWSNwidth(WSCushort width){
  WSCwindow::setWorkWSNwidth(width);
  if (_cmd_form != NULL){
    _cmd_form->setPropertyV(WSNwidth, (WSCushort)(width -2));
//    _cmd_form->setPropertyV(WSNbackPixmap,WSGFgetBarPixmap(width,WS_HORIZONTAL));
    _title_labels1->clear();
    _title_labels2->clear();
    _title_labels1->setPropertyV(WSNwidth,(WSCushort)(_w - 20));
    _title_labels2->setPropertyV(WSNwidth,(WSCushort)(_w - 20));
    _title_labels1->redraw();
    _title_labels2->redraw();
    long ediff = 0;
    if (_cancel != False){
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
        ediff = 0;
      }else
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        ediff = D_BTN_WIDTH -26 + 10;
      }
    }
    if (_cancel != False){
      _end_btn->clear();
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
        _end_btn->setPropertyV(WSNx,(short)(width -40));
      }else
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        _end_btn->setPropertyV(WSNx,(short)(width - D_BTN_WIDTH -14));
      }
      _end_btn->redraw();
    }
    short pos = width -40 -ediff;

    if (_no != False){ 
      pos -= D_BTN_WIDTH;
      _no_btn->clear();
      _no_btn->setPropertyV(WSNx,(short)(pos));
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        pos -= 10;
      }
      _no_btn->redraw();
    }
    if (_ok != False){ 
      pos -= D_BTN_WIDTH;
      _ok_btn->clear();
      _ok_btn->setPropertyV(WSNx,(short)(pos));
      _ok_btn->redraw();
    }
    _cmd_form->update();
  }
}
void WSCbaseDialog::setWorkWSNheight(WSCushort height){
  WSCwindow::setWorkWSNheight(height);
  if (_cmd_form != NULL){
    _cmd_form->setPropertyV(WSNy,(short)(height - 35));
    _cmd_form->update();
  }
}
void WSCbaseDialog::setWorkWSNmodal(WSCbool fl){
  if (getPropertyEditMode() == False){
    WSDdev* dev = getowndev();
    if (dev != NULL){
      dev->setValue(WSDEV_FLOAT_ON_TOP,&fl);
      dev->setValue(WSDEV_MODAL,&fl);
    }
    if (getVisible() != False){
      WSGIappDev()->setModalClient(this);
    }
  }
}
void WSCbaseDialog::getWorkWSNmodal(WSCbool* fl){}
void WSCbaseDialog::setWorkWSNdefaultPosition(WSCbool){}
void WSCbaseDialog::getWorkWSNdefaultPosition(WSCbool*){}

long WSCbaseDialog::_device_initialize(){
  WSCwindow::_device_initialize();
  WSDdev* dev = getowndev();
  if (dev != NULL){
    if (getPropertyEditMode() == False){
      WSCbool fl = _modal; 
      dev->setValue(WSDEV_FLOAT_ON_TOP,&fl);
      dev->setValue(WSDEV_MODAL,&fl);
    }
  }else{
    return WS_ERR;
  }
  return WS_NO_ERR;
}
static void _setup_btn(WSCbase* btn,WSCbase* dlg){
  btn->initialize();
  btn->setInternalObject(True);
  btn->setPropertyV(WSNy,         (short)4                  );
  btn->setPropertyV(WSNheight,    (WSCushort)23        );
//  btn->setPropertyV(WSNforeColor, WSGFcolor("black")        );
//  btn->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  btn->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
  btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  btn->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  btn->setUserData("DLG_BASE",(void*)dlg); 
  WSGFsetMargin(btn,0);
 
}
long WSCbaseDialog::initialize(){
  WSCwindow::initialize();

  _cmd_form = new WSCform(this,"bd-cform");
  _cmd_form->setInternalObject(True);
  _cmd_form->setUseParentBaseDev(True);
  _cmd_form->initialize();
  _cmd_form->setPropertyV(WSNx,     (short)1 );
  _cmd_form->setPropertyV(WSNy,     (short)(_h - 35) );
  _cmd_form->setPropertyV(WSNwidth, (WSCushort)(_w -2));
  _cmd_form->setPropertyV(WSNheight,(WSCushort)30);
  _cmd_form->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cmd_form->setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
//  _cmd_form->setPropertyV(WSNforeColor,WSGFcolor("gray55"));
//  _cmd_form->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  _cmd_form->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  _cmd_form->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _cmd_form->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
//  _cmd_form->setPropertyV(WSNbackPixmap,WSGFgetBarPixmap(_w,WS_HORIZONTAL));
//  _cmd_form->setProperty(WSNpixmapStyle,WS_DYNAMIC_PIXMAP);
  _cmd_form->setVisible(True);

  _title_label = new WSCvlabel(_cmd_form,"bd-t");
  _title_label->setInternalObject(True);
  _title_label->initialize();
  _title_label->setPropertyV(WSNx,     (short)3 );
  _title_label->setPropertyV(WSNy,     (short)1 );
  _title_label->setPropertyV(WSNwidth, (WSCushort)32 );
  _title_label->setPropertyV(WSNheight,(WSCushort)28 );
  _title_label->setPropertyV(WSNlabelPixmap,_title_pixmap);
  _title_label->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  WSGFsetMargin(_title_label,0);
  _title_label->setVisible(True);

  _title_labels1 = new WSCvlabel(_cmd_form,"bd-ts1");
  _title_labels1->setInternalObject(True);
  _title_labels1->initialize();
  _title_labels1->setPropertyV(WSNx,     (short)35 );
  _title_labels1->setPropertyV(WSNy,     (short)5 );
  _title_labels1->setPropertyV(WSNwidth,(WSCushort)(_w - 20) );
  _title_labels1->setPropertyV(WSNheight,(WSCushort)20 );
  _title_labels1->setPropertyV(WSNforeColor,"#ffffff" );
  _title_labels1->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT );
  _title_labels1->setPropertyV(WSNlabelString,_title_string);
  _title_labels1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _title_labels1->setVisible(True);
  WSGFsetMargin(_title_labels1,0);

  _title_labels2 = new WSCvlabel(_cmd_form,"bd-ts2");
  _title_labels2->setInternalObject(True);
  _title_labels2->initialize();
  _title_labels2->setPropertyV(WSNx,     (short)36 );
  _title_labels2->setPropertyV(WSNy,     (short)6 );
  _title_labels2->setPropertyV(WSNwidth,(WSCushort)(_w - 20) );
  _title_labels2->setPropertyV(WSNheight,(WSCushort)20 );
  _title_labels2->setPropertyV(WSNforeColor,"#000000" );
  _title_labels2->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT );
  _title_labels2->setPropertyV(WSNlabelString,_title_string);
  _title_labels2->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _title_labels2->setVisible(True);
  WSGFsetMargin(_title_labels2,0);

  _ok_btn = new WSCvbtn(_cmd_form,"bd-ok-btn");
  _ok_btn->setInternalObject(True);
  _setup_btn(_ok_btn,this);
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    D_BTN_WIDTH = 60;
  }else{
    D_BTN_WIDTH = 80;
  }
  _ok_btn->setPropertyV(WSNwidth,     (WSCushort)D_BTN_WIDTH        );
//  _ok_btn->setPropertyV(WSNlabelPixmap,WS_BTN_PIX);
//  _ok_btn->setProperty(WSNusePixmap,True);
  _ok_btn->setPropertyV(WSNlabelString,_ok_str);

  if (_ok != False){
    if (_no != False){
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
        _ok_btn->setPropertyV(WSNx, (short)(_w -40 - D_BTN_WIDTH*2)  );
      }else{
        _ok_btn->setPropertyV(WSNx, (short)(_w -50 - D_BTN_WIDTH*2)  );
      }
    }else{
      _ok_btn->setPropertyV(WSNx,         (short)(_w -40 - D_BTN_WIDTH)  );
    }
    _ok_btn->setVisible(True);
  }
  WSCprocedure* op1 = new WSCprocedure("op1",WSEV_ACTIVATE);
  op1->setInternal(True);
  op1->setFunction(_ok_btn_work,"_ok_btn_work");
  _ok_btn->addProcedure(op1);

  _no_btn = new WSCvbtn(_cmd_form,"bd-no-btn");
  _no_btn->setInternalObject(True);
  _setup_btn(_no_btn,this);
//  _no_btn->setPropertyV(WSNwidth,     (WSCushort)26        );
//  _no_btn->setPropertyV(WSNlabelPixmap,WS_BTN_PIX);
//  _no_btn->setProperty(WSNusePixmap,True);
  _no_btn->setPropertyV(WSNlabelString,_no_str);
  _no_btn->setPropertyV(WSNwidth,     (WSCushort)D_BTN_WIDTH        );

  WSCprocedure* op2 = new WSCprocedure("op1",WSEV_ACTIVATE);
  op2->setInternal(True);
  op2->setFunction(_no_btn_work,"_no_btn_work");
  _no_btn->addProcedure(op2);

  if (_no != False){
    _no_btn->setVisible(True);
    _no_btn->setPropertyV(WSNx,         (short)(_w -40 - D_BTN_WIDTH)  );
  }
  _end_btn = new WSCvbtn(_cmd_form,"bd-end-btn");
  _end_btn->setInternalObject(True);
  _setup_btn(_end_btn,this);
  _end_btn->setPropertyV(WSNx,         (short)(_w -40)  );
  _end_btn->setPropertyV(WSNwidth,     (WSCushort)26        );
//  _end_btn->setProperty(WSNusePixmap,True);
  _end_btn->setPropertyV(WSNlabelPixmap,WS_EBTN_PIX);
  if (_cancel != False){
    _end_btn->setVisible(True);
  }

  WSCprocedure* op3 = new WSCprocedure("op1",WSEV_ACTIVATE);
  op3->setInternal(True);
  op3->setFunction(_end_btn_work,"_end_btn_work");
  _end_btn->addProcedure(op3);

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  return WS_NO_ERR;
}
void WSCbaseDialog::onParentVisibleChange(WSCbool fl){
  WSCwindow::onParentVisibleChange(fl);
  if (fl != False){
    onGuiPolicyChange( WSGIappDev()->getGuiPolicy());
    if (_modal == True && getPropertyEditMode() == False){
      if (getVisible() != False){
        WSGIappDev()->setModalClient(this);
      }
    }
  }else{
//    if (_modal == True && getPropertyEditMode() == False &&
    if (this == WSGIappDev()->getModalClient()){
      WSGIappDev()->setModalClient(NULL);
    }
    _popuped = 0;
    if (_status == 0){
      _status = WS_DIALOG_CANCEL;
    }
  }
}
void WSCbaseDialog::onVisibleChange(WSCbool fl){
  if (fl != False){
    _status = 0;
    _status = WS_DIALOG_CANCEL;
    if (_modal == True && getPropertyEditMode() == False){
      WSGIappDev()->setModalClient(this);
    }

    WSGIappDev()->setFocusDialog(this,True);
    if (_default_pos != False && getPropertyEditMode() == False){
      short x = (WSGIappDev()->getWidth() - _w)/2;
      short y = (WSGIappDev()->getHeight() - _h)/2;
      setPropertyV(WSNx,x);
      setPropertyV(WSNy,y);
    }
  }else{
//    if (_modal == True && getPropertyEditMode() == False &&
//      this == WSGIappDev()->getModalClient()){
    if (this == WSGIappDev()->getModalClient()){
      WSGIappDev()->setModalClient(NULL);
    }
    _popuped = 0;
    if (_status == 0){
      _status = WS_DIALOG_CANCEL;
    }
  }
  WSCwindow::onVisibleChange(fl);
}
void WSCbaseDialog::onResize(WSCrect* rect){
  if (_w != rect->width){
    if (_cmd_form != NULL){
      _cmd_form->setPropertyV(WSNwidth, (WSCushort)(rect->width -2));
//      _cmd_form->setPropertyV(WSNbackPixmap,WSGFgetBarPixmap(rect->width,WS_HORIZONTAL));
      _title_labels1->clear();
      _title_labels2->clear();
      _title_labels1->setPropertyV(WSNwidth,(WSCushort)(_w - 20));
      _title_labels2->setPropertyV(WSNwidth,(WSCushort)(_w - 20));
      _title_labels1->redraw();
      _title_labels2->redraw();
      long ediff = 0;
      if (_cancel != False){
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          ediff = 0;
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          ediff = D_BTN_WIDTH -26 + 10;
        }
      }
      if (_cancel != False){
        _end_btn->clear();
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          _end_btn->setPropertyV(WSNx,(short)(rect->width -40));
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          _end_btn->setPropertyV(WSNx,(short)(rect->width - D_BTN_WIDTH -14));
        }
        _end_btn->redraw();
      }
      short pos = rect->width -40 -ediff;
      if (_no != False){
        pos -= D_BTN_WIDTH;
        _no_btn->clear();
        _no_btn->setPropertyV(WSNx,(short)(pos));
        _no_btn->setProperty(WSNwidth,D_BTN_WIDTH);
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pos -=10;
        }
        _no_btn->redraw();
      }
      if (_ok != False){
        pos -= D_BTN_WIDTH;
        _ok_btn->clear();
        _ok_btn->setPropertyV(WSNx,(short)(pos));
        _ok_btn->setProperty(WSNwidth,D_BTN_WIDTH);
        _ok_btn->redraw();
      }
      _cmd_form->update();
    }
  }

  if (_h != rect->height){
    if (_cmd_form != NULL){
      _cmd_form->setPropertyV(WSNy,(short)(rect->height - 35));
      _cmd_form->update();
    }
  }

  WSCwindow::onResize(rect);
}
WSCbase* WSCbaseDialog::getFormObject(){
  return this;
}
WSCbase* WSCbaseDialog::getCmdFormObject(){
  return _cmd_form;
}
void WSCbaseDialog::onActivate(){
  if (_rep != NULL){
     void (*hd)(WSCbase*) = (void(*)(WSCbase*))_rep;
     hd(this);
  }
  execProcedure(WSEV_ACTIVATE);
}
void WSCbaseDialog::_ok_btn_work(WSCbase* obj){
  WSCbaseDialog* dlb_base = (WSCbaseDialog*)obj->getUserData("DLG_BASE");
//  dlb_base->_popuped = 0;
  if (dlb_base->getPropertyEditMode() == False){
    dlb_base->_status = WS_DIALOG_OK;
    dlb_base->onActivate();
    if (dlb_base->getVisible() != False){
      dlb_base->_status = WS_DIALOG_CANCEL;
    }
//    dlb_base->execEventProc(WSEV_ACTIVATE,NULL);
  }
}
void WSCbaseDialog::_no_btn_work(WSCbase* obj){
  WSCbaseDialog* dlb_base = (WSCbaseDialog*)obj->getUserData("DLG_BASE");
//  dlb_base->_popuped = 0;
  if (dlb_base->getPropertyEditMode() == False){
    dlb_base->_status = WS_DIALOG_NO;
    dlb_base->onActivate();
    if (dlb_base->getVisible() != False){
      dlb_base->_status = WS_DIALOG_CANCEL;
    }
//    dlb_base-> execEventProc(WSEV_ACTIVATE,NULL);
  }
}
void WSCbaseDialog::_end_btn_work(WSCbase* obj){
  WSCbaseDialog* dlb_base = (WSCbaseDialog*)obj->getUserData("DLG_BASE");
  dlb_base->_popuped = 0;
  if (dlb_base->getPropertyEditMode() == False){
    dlb_base->_status = WS_DIALOG_CANCEL;
    dlb_base->onActivate();
//    dlb_base-> execEventProc(WSEV_ACTIVATE,NULL);
    dlb_base->setVisible(False);
  }
}
long WSCbaseDialog::getStatus(){
  return _status;
}
long WSCbaseDialog::popup(){
  setVisible(True);
  update();
  WSGIappObjectList()->execUpdate();

  if (getVisible() == False){
    return WS_ERR;
  }
  _popuped = 1;
  if (_ok != False){
    _ok_btn->setFocus();
  }else
  if (_no != False){
    _no_btn->setFocus();
  }else{
    _end_btn->setFocus();
  }
  WSGIappDev()->setFocusDialog(this,True);
  while(1){
    if (_popuped == 0){
      break;
    }
    WSGIappDev()->setFocusDialog(this,True);
    WSGIappDev()->dispatchEvent();
    WSGIappDevice()->clearDeleteList();
  }
  setVisible(False);
  return _status;
}

void WSCbaseDialog::onGuiPolicyChange(long policy){
  if (policy & WS_POLICY_ORIGINAL){
    D_BTN_WIDTH = 60;
    _title_label->setVisible(True);
    _title_labels1->setVisible(True);
    _title_labels2->setVisible(True);
    _cmd_form->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _cmd_form->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    if (policy & WS_POLICY_GRADATION){
      _cmd_form->setProperty(WSNgradation,WS_GR_LT_RB);
    }else{
      _cmd_form->setProperty(WSNgradation,WS_GR_NONE);
    }
//    _ok_btn->setPropertyV(WSNy,         (short)4        );
//    _ok_btn->setPropertyV(WSNheight,    (WSCushort)23   );
    _ok_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//    _no_btn->setPropertyV(WSNy,         (short)4        );
//    _no_btn->setPropertyV(WSNheight,    (WSCushort)23   );
    _no_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _end_btn->setProperty(WSNlabelString,"");
//    _end_btn->setVisible(True);
    _end_btn->setProperty(WSNx,_w - 40);
    _end_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _end_btn->setPropertyV(WSNwidth,     (WSCushort)26        );
    _end_btn->setPropertyV(WSNlabelPixmap,WS_EBTN_PIX);
  }else{
    D_BTN_WIDTH = 80;
    _title_label->setVisible(False);
    _title_labels1->setVisible(False);
    _title_labels2->setVisible(False);
    _cmd_form->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    _cmd_form->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
    _cmd_form->setProperty(WSNgradation,WS_GR_NONE);
//    _ok_btn->setPropertyV(WSNy,         (short)0        );
//    _ok_btn->setPropertyV(WSNheight,    (WSCushort)30   );
    _ok_btn->setPropertyV(WSNshadowThickness,(WSCuchar)2);
//    _no_btn->setPropertyV(WSNy,         (short)0        );
//    _no_btn->setPropertyV(WSNheight,    (WSCushort)30   );
    _no_btn->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    _end_btn->setProperty(WSNlabelString,_cancel_str);
//    _end_btn->setVisible(False);
    _end_btn->setProperty(WSNx,_w - D_BTN_WIDTH -14);
    _end_btn->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    _end_btn->setProperty(WSNwidth,D_BTN_WIDTH);
    _end_btn->setProperty(WSNlabelPixmap,"");
  }
  if (policy & WS_POLICY_GRADATION){
    _ok_btn->setProperty(WSNgradation,WS_GR_T_B);
    _no_btn->setProperty(WSNgradation,WS_GR_T_B);
    _end_btn->setProperty(WSNgradation,WS_GR_T_B);
  }else{
    _ok_btn->setProperty(WSNgradation,WS_GR_NONE);
    _no_btn->setProperty(WSNgradation,WS_GR_NONE);
    _end_btn->setProperty(WSNgradation,WS_GR_NONE);
  }

  _ok_btn->setProperty(WSNwidth,D_BTN_WIDTH);
  _no_btn->setProperty(WSNwidth,D_BTN_WIDTH);
  long ediff = 0;
  if (_cancel != False){
    if (policy & WS_POLICY_ORIGINAL){
      ediff = 0;
    }else
    if (policy & WS_POLICY_WINDOWS){
      ediff = D_BTN_WIDTH -26 + 10;
    }
  }
  if (_no == False){
    if (_no_btn != NULL){
      _no_btn->setProperty(WSNvis,(WSCbool)False);
      _ok_btn->setProperty(WSNx,  (short)(_w -40 - D_BTN_WIDTH -ediff));
    }
  }else{
    if (_no_btn != NULL){
      _no_btn->setProperty(WSNx,(short)(_w -40 - D_BTN_WIDTH -ediff) );
      _no_btn->setProperty(WSNvis,(WSCbool)True);

      _ok_btn->clear();
      if (policy & WS_POLICY_ORIGINAL){
        _ok_btn->setProperty(WSNx,(short)(_w -40 - D_BTN_WIDTH*2 )  );
      }else{
        _ok_btn->setProperty(WSNx,(short)0);
        _ok_btn->setProperty(WSNx,(short)(_w -50 - D_BTN_WIDTH*2 -ediff)  );
      }
      _ok_btn->redraw();
    }
  }
  //to destroy internal pixmap..
  _cmd_form->internalUpdate();
  WSCbase::onGuiPolicyChange(policy);
}
void WSCbaseDialog::onFocusChange(WSCbool fl){
  if (fl != False){
    WSGIappDev()->setFocusDialog(this,True);
  }else{
    WSGIappDev()->setFocusDialog(this,False);
  }
}
