//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <win/WSDwinEnv.h>
#include <WSCstring.h>
#include <direct.h>

WSDenv* _win_env_chandler(){
  return new WSDwinEnv();
}
class _win_env_init{
  public: _win_env_init(){
    WSDenv::setCreateInstanceHandler(_win_env_chandler);
  };
};
static _win_env_init _win_env_init_execute;

void WSGFwinEnvInit(){
  WSDenv::setCreateInstanceHandler(_win_env_chandler);
}

WSDwinEnv::WSDwinEnv(){}
WSDwinEnv::~WSDwinEnv(){}

char* WSDwinEnv::getEnv(char* src){
  WSCstring str(src);
  str.delString("(",0);
  str.delString(")",0);
  WSCstring new_str = str.getWord(0);
  WSCbool wsdir = !strcmp("WSDIR",new_str.getString());
  WSCbool windir = !strcmp("WINDIR",new_str.getString());
static char buffer2[2048];
  if (!strcmp("HOME",new_str.getString())){
    new_str.setString("USERPROFILE");
  }
  if (!strcmp("USER",new_str.getString())){
    new_str.setString("USERNAME");
  }

  if (windir != 0){
    GetWindowsDirectory(buffer2,2048);
    return buffer2;
  }
  char* ret = getenv( new_str.getString() );

  if (ret == NULL){
    if (wsdir != 0){
static int init = 0;
      if (init == 0){ 
        char buffer[2048];
        _getcwd(buffer,2000);
        sprintf(buffer2,"%s\\..",buffer);
        init = 1;
WSMFtrace("WSDwinEnv::getEnv getcwd=%s\n",buffer2);
      }
      return buffer2;
    }else{
      return "";
    }
  }
  return ret;
}
