//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDMOUSE_H
#define WSDMOUSE_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSClistData.h>

class WSDmouse  :public WSCroot{

  protected:
    WSClistData _mlist;
    WSCulong _target_btn;
    WSCulong _status; 
    WSCbase* _fclient; 
  public:
    WSDmouse();

    virtual WSCbool getMousePosition(short* x,short* y);
    virtual WSCbool getMousePosition(short* x,short* y,WSCbase*);
 
    virtual long getMouseStatus()=0;
    virtual void setMousePosition(short x, short y);
    virtual void setMouseCursor(long);

    void  addMouseCursor(long id,long val,char*);
    char* getMouseCursorName(long id);
    long  getMouseCursorId(long pos);
    long  getMouseCursor(long id);
//DEVELOP
    virtual void setupMouseCursor(char*);
    virtual void initialize();
    virtual void resetMouseCursors();
    virtual void delMouseCursor(long pos);

    WSCulong getStatus();
    void setStatus(WSCulong);
    WSCulong getTargetBtn();
    void setTargetBtn(WSCulong);
    void setMouseFocusClient(WSCbase*);
    WSCbase* getMouseFocusClient();

    static  void setCreateInstanceHandler( WSDmouse* (*hd)() );

    WSMFclassDef(WSDmouse,WSCroot);
};
extern WSDLEX WSDmouse*  WSGIappMouse();
#endif//  WSDMOUSE_H
